Notebook[{

Cell[CellGroupData[{
Cell["\<\

      Basic examples with xConf\
\>", "Subtitle",
 FontSize->24,ExpressionUUID->"b73ea991-a1e7-4945-91d0-4054ec287b18"],

Cell["\<\
xConf is a small package which must be loaded on top of xAct (see \
https://www.xact.es ).
It allows to perform Weyl rescaling which corresponds to what is described as \
\[OpenCurlyQuote]conformal transformation\[CloseCurlyQuote] in appendix D od \
Wald\[CloseCurlyQuote]s Book on General Relativity (1984).

In this example notebook we collect the most basic examples.\
\>", "Text",ExpressionUUID->"a9ef2e77-0e93-4fa2-8628-4fcd9bdb00bf"],

Cell[CellGroupData[{

Cell["Set - up", \
"Section",ExpressionUUID->"fbee73f7-0c49-47a5-b99e-0261723fb6da"],

Cell[CellGroupData[{

Cell["Loading package", \
"Subsubsection",ExpressionUUID->"a01f0422-816a-4bb3-ba97-902f22456d74"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<xAct`xConf`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",ExpressionUUID->"678b56c2-43ca-42da-a7c6-2d1dc4257ac4"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"d0aa38c4-6177-45d9-8f52-7c2ae9e28ec3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xPerm`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.2.3\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2015", ",", "8", ",", "23"}], "}"}]}],
  SequenceForm["Package xAct`xPerm`  version ", "1.2.3", ", ", {2015, 8, 23}],
  
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"eab57772-d1c6-43ee-91be-eed5512167f4"],

Cell[BoxData["\<\"CopyRight (C) 2003-2020, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"bae39a65-84ac-4480-b30a-dd8290b00dd8"],

Cell[BoxData["\<\"Connecting to external mac executable...\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"d46b037d-467e-4a75-a281-af34d481781a"],

Cell[BoxData["\<\"Connection established.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"458d0f6d-ea2a-4119-aef6-53e9c6e7fb90"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"65d6ce3a-7f7b-4350-87c7-ae72b698c0fd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xTensor`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.2.0\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2021", ",", "10", ",", "17"}], "}"}]}],
  SequenceForm[
  "Package xAct`xTensor`  version ", "1.2.0", ", ", {2021, 10, 17}],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"22d430b8-522a-44f6-932b-9e16c483662b"],

Cell[BoxData["\<\"CopyRight (C) 2002-2021, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"c21f8249-b495-4698-adeb-c0028d22c45e"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"d35feb70-da66-4177-b06b-d0110924d06f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xConf`  version \"\>", 
   "\[InvisibleSpace]", "\<\"0.0.1\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2025", ",", "4", ",", "4"}], "}"}]}],
  SequenceForm["Package xAct`xConf`  version ", "0.0.1", ", ", {2025, 4, 4}],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"7da57df4-a75e-42ac-9a28-9ec3b6321144"],

Cell[BoxData["\<\"CopyRight (C) 2025-2026, Cyril Pitrou, Guillaume under the \
General Public License.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"cb10ae87-0af0-4fec-b09f-215457edc39e"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"1cb2e6fc-f7d7-49de-809d-629bf294b374"],

Cell[BoxData["\<\"These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"4fda6b6f-5f6d-4e5a-87b4-3c0eb96232a6"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"33bd56d0-cbcb-47b0-b1fe-ab2e0f45b46c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** Option \"\>", "\[InvisibleSpace]", "AllowUpperDerivatives", 
   "\[InvisibleSpace]", "\<\" of \"\>", "\[InvisibleSpace]", "ContractMetric",
    "\[InvisibleSpace]", "\<\" changed from \"\>", "\[InvisibleSpace]", 
   "False", "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", "True"}],
  SequenceForm[
  "** Option ", xAct`xTensor`AllowUpperDerivatives, " of ", 
   xAct`xTensor`ContractMetric, " changed from ", False, " to ", True],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"347cee9a-fac8-4749-872c-2dd56d8c25f9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** Option \"\>", "\[InvisibleSpace]", "UseMetricOnVBundle", 
   "\[InvisibleSpace]", "\<\" of \"\>", "\[InvisibleSpace]", "ToCanonical", 
   "\[InvisibleSpace]", "\<\" changed from \"\>", "\[InvisibleSpace]", "All", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", "None"}],
  SequenceForm[
  "** Option ", xAct`xTensor`UseMetricOnVBundle, " of ", 
   xAct`xTensor`ToCanonical, " changed from ", All, " to ", None],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"c065e521-f726-4696-8baf-b0ca6ecb6fd5"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Set - up manifold and conformal relations", \
"Subsubsection",ExpressionUUID->"36a7f468-076b-4507-908d-d3d2fef02bf0"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DefManifold", "[", 
  RowBox[{"M", ",", "4", ",", 
   RowBox[{"{", 
    RowBox[{
    "\[Alpha]", ",", "\[Beta]", ",", "\[Gamma]", ",", "\[Mu]", ",", "\[Nu]", 
     ",", "\[Lambda]", ",", "\[Sigma]"}], "}"}]}], "]"}], "\n", 
 RowBox[{
  RowBox[{"DefMetric", "[", 
   RowBox[{
    RowBox[{"-", "1"}], ",", 
    RowBox[{"g", "[", 
     RowBox[{
      RowBox[{"-", "\[Alpha]"}], ",", 
      RowBox[{"-", "\[Beta]"}]}], "]"}], ",", "CD", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<;\>\"", ",", "\"\<\[Del]\>\""}], "}"}], ",", 
    RowBox[{"PrintAs", "\[Rule]", "\"\<g\>\""}]}], "]"}], ";"}]}], "Input",
 CellLabel->"In[2]:=",ExpressionUUID->"e5a250ec-cb66-4862-b7ba-440ac45c6456"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefManifold", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"manifold \"\>", "\[InvisibleSpace]", "M", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefManifold, ": Defining ", "manifold ", $CellContext`M,
    ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"2111f5da-b7ed-44de-b656-28af8d926b2b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle \"\>", "\[InvisibleSpace]", "TangentM", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "vbundle ", $CellContext`TangentM, ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"987b9881-3563-4fea-a889-c490eb827b50"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric metric tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric metric tensor ", 
   $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Beta]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"6ddd2949-9b1a-4576-a41c-daf90bbec1c6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric tensor \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"epsilong", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric tensor ", 
   $CellContext`epsilong[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"f799cf5c-1420-4681-a3d1-ba30807145fc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tetrametric \"\>", "\[InvisibleSpace]", 
   RowBox[{"Tetrag", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tetrametric ", 
   $CellContext`Tetrag[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"09df66fb-b5e9-41e6-add3-27978c99c05f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tetrametric \"\>", "\[InvisibleSpace]", 
   RowBox[{"Tetrag\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tetrametric ", 
   $CellContext`Tetrag\[Dagger][-$CellContext`\[Alpha], \
-$CellContext`\[Beta], -$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ",
    ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"fd645276-8ce3-4ca8-bcc0-52f2b15a2cfb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"CD", "[", 
    RowBox[{"-", "\[Alpha]"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "covariant derivative ", 
   $CellContext`CD[-$CellContext`\[Alpha]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"2d414e44-4350-4ae2-87c2-2e5a4812a481"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing torsion tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TorsionCD", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing torsion tensor ", 
   $CellContext`TorsionCD[$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"1f9b8f18-2e09-49bd-8281-6cb334e249ab"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCD", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Christoffel tensor ", 
   $CellContext`ChristoffelCD[$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"78ebc261-7473-4082-a1c3-e38656c10ab6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannCD", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`RiemannCD[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"cf2d26ec-0687-4370-9f30-c876f2c03ea1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciCD", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric Ricci tensor ", 
   $CellContext`RicciCD[-$CellContext`\[Alpha], -$CellContext`\[Beta]], ". ", 
   ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"80ecd705-aa27-4818-ba44-72be08172522"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Riemann automatically replaced \
by Ricci.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"6e4e1728-cd7e-4c7c-96d8-ead7fb7c9053"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"RicciScalarCD", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Ricci scalar ", 
   $CellContext`RicciScalarCD[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"4f71947f-e57f-48f8-9c77-1a1ce5980aec"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Ricci automatically replaced \
by RicciScalar.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"6edcd9e4-06f6-4c1d-ba1d-e282976bf640"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Einstein tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"EinsteinCD", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Einstein tensor ", 
   $CellContext`EinsteinCD[-$CellContext`\[Alpha], -$CellContext`\[Beta]], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"48aad657-ee79-47b9-bb48-369c12c55a58"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Weyl tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"WeylCD", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "Weyl tensor ", 
   $CellContext`WeylCD[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"16294ae8-595f-4107-a4cf-8b18f3fcbeb6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric TFRicci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TFRicciCD", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric TFRicci tensor ", 
   $CellContext`TFRicciCD[-$CellContext`\[Alpha], -$CellContext`\[Beta]], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"738084b2-6fc3-4b17-aba9-ea98012ff725"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Kretschmann scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"KretschmannCD", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Kretschmann scalar ", 
   $CellContext`KretschmannCD[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"b0155749-34f3-4833-997b-8f2f68731698"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RiemannToWeylRules for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RiemannToWeylRules for dim ", 4],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"ee05eb79-2ad7-49cc-ae6b-4649b854c115"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToTFRicci for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RicciToTFRicci for dim ", 4],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"70ac3728-6a77-400f-9e75-14552667376e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToEinsteinRules for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RicciToEinsteinRules for dim ", 4],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"e55c094f-db9f-4a8b-97af-3e8490bc2a36"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"weight +2 density \"\>", "\[InvisibleSpace]", 
   RowBox[{"Detg", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Determinant.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "weight +2 density ", 
   $CellContext`Detg[], ". ", "Determinant."],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"70770521-f351-4bc3-83f1-dd3cf0937bdd"]
}, Open  ]]
}, Open  ]],

Cell["\<\
We define several metrics which are conformally related to g.\
\>", "Text",ExpressionUUID->"7233aac8-9b37-4856-be3a-04f44c3e11f3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "DefConformalMetric"}]], "Input",
 CellLabel->"In[4]:=",ExpressionUUID->"38475ed4-6dea-4030-adfe-ba5f7dcd6f86"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"DefConformalMetric[g,S] defines a metric \
conformally related to 'g', with the conformal factor 'S'. If other metrics \
are conformally related to 'g', then 'gS2' is related to them by transitivity \
of the conformal transformation. If the scalar field S[] does not exist, it \
is defined.\\n   Options are PrintAs->printasform, \
ConformalMetricName->MetricName, FrameColor->somecolor and \
SymbolOfCovD->{postfixsymbol,prefixsymbol}. If no ConformalMetricName is \
provided the name chosen is the concatenation 'metric+conformalfactor+2'. If \
no color is provided, it choses randomly a color. If no SymbolOfCovD is \
provided, the combination {:,\[Del]metricname} is chosen.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[
           TagBox[GridBox[{
              {
               StyleBox[
                TagBox[
                 TooltipBox[
                  StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                   StripOnInput->False],
                  "\"Definitions\"",
                  TooltipStyle->"TextStyling"],
                 Annotation[#, "Definitions", "Tooltip"]& ], "DialogStyle",
                StripOnInput->False]},
              {
               TemplateBox[{"\"\[ThinSpace]\"", 
                 GridBox[{{
                    RowBox[{
                    RowBox[{"DefConformalMetric", "[", "]"}], ":=", 
                    RowBox[{"Message", "[", 
                    RowBox[{
                    StyleBox[
                    RowBox[{"DefConformalMetric", "::", "argm"}], 
                    "MessageName"], ",", "DefConformalMetric", ",", "0", ",", 
                    "2"}], "]"}]}]}, {" "}, {
                    RowBox[{
                    RowBox[{"DefConformalMetric", "[", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`g_", "?", "MetricQ"}], ",", 
                    "xAct`xConf`Private`conffactor_", ",", 
                    RowBox[{"xAct`xConf`Private`options", ":", 
                    RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"xAct`xConf`Private`nmetlist", ",", 
                    "xAct`xConf`Private`pas", ",", 
                    "xAct`xConf`Private`gconfnameraw", ",", 
                    "xAct`xConf`Private`cdgconf", ",", 
                    "xAct`xConf`Private`metlist", ",", 
                    "xAct`xConf`Private`color", ",", 
                    "xAct`xConf`Private`symbolscovd"}], "}"}], ",", 
                    RowBox[{"Catch", "[", 
                    RowBox[{"With", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`M", "=", 
                    RowBox[{"ManifoldOfCovD", "[", 
                    
                    RowBox[{"CovDOfMetric", "[", "xAct`xConf`Private`g", 
                    "]"}], "]"}]}], ",", 
                    RowBox[{"xAct`xConf`Private`CD", "=", 
                    
                    RowBox[{"CovDOfMetric", "[", "xAct`xConf`Private`g", 
                    "]"}]}]}], "}"}], ",", 
                    RowBox[{"With", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`i1", "=", 
                    RowBox[{"DummyIn", "[", 
                    RowBox[{"Tangent", "[", "xAct`xConf`Private`M", "]"}], 
                    "]"}]}], ",", 
                    RowBox[{"xAct`xConf`Private`i2", "=", 
                    RowBox[{"DummyIn", "[", 
                    RowBox[{"Tangent", "[", "xAct`xConf`Private`M", "]"}], 
                    "]"}]}], ",", 
                    RowBox[{"xAct`xConf`Private`sy1", "=", 
                    RowBox[{
                    
                    RowBox[{"SymbolOfCovD", "[", "xAct`xConf`Private`CD", 
                    "]"}], "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ",", 
                    RowBox[{"xAct`xConf`Private`sy2", "=", 
                    RowBox[{
                    
                    RowBox[{"SymbolOfCovD", "[", "xAct`xConf`Private`CD", 
                    "]"}], "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}]}]}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`metlist", "=", "$Metrics"}], 
                    ";", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"xAct`xConf`Private`pas", ",", 
                    "xAct`xConf`Private`gconfnameraw", ",", 
                    "xAct`xConf`Private`color", ",", 
                    "xAct`xConf`Private`symbolscovd"}], "}"}], "=", 
                    RowBox[{"OptionValue", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"PrintAs", ",", "ConformalMetricName", ",", 
                    "FrameColor", ",", "SymbolOfCovD"}], "}"}], "]"}]}], ";", 
                    
                    RowBox[{"If", "[", 
                    RowBox[{
                    
                    RowBox[{"xAct`xConf`Private`gconfnameraw", "===", 
                    "Automatic"}], ",", 
                    RowBox[{"xAct`xConf`Private`gconfnameraw", "=", 
                    RowBox[{"ConformalMetricName", "[", 
                    
                    RowBox[{"xAct`xConf`Private`g", ",", 
                    "xAct`xConf`Private`conffactor"}], "]"}]}]}], "]"}], ";", 
                    
                    RowBox[{"With", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"xAct`xConf`Private`gconfname", "=", 
                    "xAct`xConf`Private`gconfnameraw"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`cdgconf", "=", 
                    RowBox[{"SymbolJoin", "[", 
                    
                    RowBox[{"xAct`xConf`Private`CD", ",", 
                    "xAct`xConf`Private`gconfname"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    
                    RowBox[{"MetricQ", "[", "xAct`xConf`Private`gconfname", 
                    "]"}], ",", 
                    RowBox[{"Message", "[", 
                    RowBox[{
                    StyleBox[
                    RowBox[{"DefConformalMetric", "::", "old"}], 
                    "MessageName"], ",", "xAct`xConf`Private`gconfname"}], 
                    "]"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    
                    RowBox[{"xAct`xConf`Private`symbolscovd", "\[Equal]", 
                    "Automatic"}], ",", 
                    RowBox[{"xAct`xConf`Private`symbolscovd", "=", 
                    RowBox[{"{", 
                    RowBox[{"\":\"", ",", 
                    RowBox[{"\"\[Del]\"", "<>", 
                    
                    RowBox[{"ToString", "[", "xAct`xConf`Private`gconfname", 
                    "]"}]}]}], "}"}]}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"xTensorQ", "[", "xAct`xConf`Private`gconfname", 
                    "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`pas", "===", "Automatic"}], 
                    ",", 
                    RowBox[{"xAct`xConf`Private`pas", "=", 
                    RowBox[{"\"[\"", "<>", 
                    RowBox[{"PrintAs", "[", "xAct`xConf`Private`g", "]"}], 
                    "<>", 
                    RowBox[{"(", 
                    RowBox[{"\"\\!\\(\"", "<>", 
                    
                    RowBox[{"PrintAs", "[", "xAct`xConf`Private`conffactor", 
                    "]"}], "<>", "\"\\^2\\)\""}], ")"}], "<>", "\"]\""}]}]}], 
                    "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`color", "===", "Automatic"}], 
                    ",", 
                    RowBox[{"xAct`xConf`Private`color", "=", 
                    RowBox[{"RandomColor", "[", "]"}]}]}], "]"}], ";", 
                    RowBox[{"Print", "[", 
                    
                    RowBox[{"\"Choosing color \"", ",", 
                    "xAct`xConf`Private`color", ",", 
                    "\" for this conformal frame.\""}], "]"}], ";", 
                    RowBox[{
                    
                    RowBox[{"xAct`xConf`Private`ColorFrame", "[", 
                    "xAct`xConf`Private`gconfname", "]"}], "=", 
                    "xAct`xConf`Private`color"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"xTensorQ", "[", "xAct`xConf`Private`conffactor", 
                    "]"}]}], ",", 
                    RowBox[{"DefTensor", "[", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`conffactor", "[", "]"}], ",", 
                    
                    RowBox[{"{", "xAct`xConf`Private`M", "}"}], ",", 
                    RowBox[{"PrintAs", "\[Rule]", 
                    RowBox[{"ToString", "[", "xAct`xConf`Private`conffactor", 
                    "]"}]}]}], "]"}]}], "]"}], ";", 
                    RowBox[{"Off", "[", 
                    StyleBox[
                    RowBox[{"DefMetric", "::", "old"}], "MessageName"], "]"}],
                     ";", 
                    RowBox[{"DefMetric", "[", 
                    RowBox[{
                    
                    RowBox[{"SignDetOfMetric", "[", "xAct`xConf`Private`g", 
                    "]"}], ",", 
                    RowBox[{"xAct`xConf`Private`gconfname", "[", 
                    RowBox[{
                    RowBox[{"-", "xAct`xConf`Private`i1"}], ",", 
                    RowBox[{"-", "xAct`xConf`Private`i2"}]}], "]"}], ",", 
                    "xAct`xConf`Private`cdgconf", ",", 
                    "xAct`xConf`Private`symbolscovd", ",", 
                    RowBox[{"PrintAs", "\[Rule]", "xAct`xConf`Private`pas"}], 
                    ",", 
                    RowBox[{"ConformalTo", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`g", "[", 
                    RowBox[{
                    RowBox[{"-", "xAct`xConf`Private`i1"}], ",", 
                    RowBox[{"-", "xAct`xConf`Private`i2"}]}], "]"}], ",", 
                    SuperscriptBox[
                    RowBox[{"xAct`xConf`Private`conffactor", "[", "]"}], 
                    "2"]}], "}"}]}]}], "]"}], ";", 
                    RowBox[{"DefInertHead", "[", 
                    RowBox[{
                    
                    RowBox[{"ConformalFrame", "[", 
                    "xAct`xConf`Private`gconfname", "]"}], ",", 
                    RowBox[{"ContractThrough", "\[Rule]", 
                    RowBox[{"{", "delta", "}"}]}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"InertHeadQ", "[", 
                    
                    RowBox[{"ConformalFrame", "[", "xAct`xConf`Private`g", 
                    "]"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"DefInertHead", "[", 
                    RowBox[{
                    
                    RowBox[{"ConformalFrame", "[", "xAct`xConf`Private`g", 
                    "]"}], ",", 
                    RowBox[{"ContractThrough", "\[Rule]", 
                    RowBox[{"{", "delta", "}"}]}]}], "]"}], ";"}]}], "]"}], 
                    ";", 
                    RowBox[{"xAct`xConf`Private`gconfname", "/:", 
                    RowBox[{"SqrtConformalFactor", "[", 
                    
                    RowBox[{"xAct`xConf`Private`gconfname", ",", 
                    "xAct`xConf`Private`g"}], "]"}], "=", 
                    RowBox[{"xAct`xConf`Private`conffactor", "[", "]"}]}], 
                    ";", 
                    RowBox[{"xAct`xConf`Private`gconfname", "/:", 
                    RowBox[{"SqrtConformalFactor", "[", 
                    
                    RowBox[{"xAct`xConf`Private`g", ",", 
                    "xAct`xConf`Private`gconfname"}], "]"}], "=", 
                    FractionBox["1", 
                    RowBox[{"xAct`xConf`Private`conffactor", "[", "]"}]]}], 
                    ";", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ConformalFrame", "[", "_", "]"}], "[", 
                    RowBox[{"xAct`xConf`Private`conffactor", "[", "]"}], 
                    "]"}], ":=", 
                    RowBox[{"xAct`xConf`Private`conffactor", "[", "]"}]}], 
                    ";", 
                    RowBox[{"RulesChangeConformalFrame", "[", 
                    
                    RowBox[{"xAct`xConf`Private`g", ",", 
                    "xAct`xConf`Private`gconfname"}], "]"}], ";", 
                    RowBox[{"RulesChangeConformalFrame", "[", 
                    
                    RowBox[{"xAct`xConf`Private`gconfname", ",", 
                    "xAct`xConf`Private`g"}], "]"}], ";", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Catch", "[", 
                    RowBox[{"ConformalRules", "[", 
                    RowBox[{"xAct`xConf`Private`g", ",", "#1"}], "]"}], "]"}],
                     "=!=", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{
                    RowBox[{"SetConformalTo", "[", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`gconfname", "[", 
                    RowBox[{
                    RowBox[{"-", "xAct`xConf`Private`i1"}], ",", 
                    RowBox[{"-", "xAct`xConf`Private`i2"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{
                    RowBox[{"-", "xAct`xConf`Private`i1"}], ",", 
                    RowBox[{"-", "xAct`xConf`Private`i2"}]}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"ConformalFactor", "[", 
                    RowBox[{"xAct`xConf`Private`g", ",", "#1"}], "]"}], " ", 
                    SuperscriptBox[
                    RowBox[{"xAct`xConf`Private`conffactor", "[", "]"}], 
                    "2"]}]}], "}"}]}], "]"}], ";", 
                    RowBox[{"xAct`xConf`Private`gconfname", "/:", 
                    RowBox[{"SqrtConformalFactor", "[", 
                    RowBox[{"xAct`xConf`Private`gconfname", ",", "#1"}], 
                    "]"}], "=", 
                    RowBox[{
                    RowBox[{"SqrtConformalFactor", "[", 
                    RowBox[{"xAct`xConf`Private`g", ",", "#1"}], "]"}], " ", 
                    RowBox[{"xAct`xConf`Private`conffactor", "[", "]"}]}]}], 
                    ";", 
                    RowBox[{"xAct`xConf`Private`gconfname", "/:", 
                    RowBox[{"SqrtConformalFactor", "[", 
                    RowBox[{"#1", ",", "xAct`xConf`Private`gconfname"}], 
                    "]"}], "=", 
                    FractionBox["1", 
                    RowBox[{
                    RowBox[{"SqrtConformalFactor", "[", 
                    RowBox[{"xAct`xConf`Private`g", ",", "#1"}], "]"}], " ", 
                    RowBox[{"xAct`xConf`Private`conffactor", "[", "]"}]}]]}], 
                    ";", 
                    RowBox[{"RulesChangeConformalFrame", "[", 
                    RowBox[{"#1", ",", "xAct`xConf`Private`gconfname"}], 
                    "]"}], ";", 
                    RowBox[{"RulesChangeConformalFrame", "[", 
                    RowBox[{"xAct`xConf`Private`gconfname", ",", "#1"}], 
                    "]"}], ";"}]}], "]"}], "&"}], ")"}], "/@", 
                    "xAct`xConf`Private`metlist"}], ";"}]}], "]"}], ";"}]}], 
                    "]"}]}]}], "]"}]}], "]"}], "]"}]}], "]"}]}]}, {" "}, {
                    RowBox[{
                    RowBox[{"DefConformalMetric", "[", "_", "]"}], ":=", 
                    RowBox[{"Message", "[", 
                    RowBox[{
                    StyleBox[
                    RowBox[{"DefConformalMetric", "::", "argr"}], 
                    "MessageName"], ",", "DefConformalMetric", ",", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", "\[Infinity]"}], "}"}]}], "]"}]}]}, {
                   " "}}, GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                  DefaultBaseStyle -> "Column", 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                "RowDefault"]}
             },
             DefaultBaseStyle->"Column",
             GridBoxAlignment->{"Columns" -> {{Left}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
            "Column"],
           FrameMargins->{{6, 0}, {3, 6}}], "\<\"\"\>"},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   PaneSelectorBox[{True->
                    ButtonBox[
                    PaneSelectorBox[{False->
                    TemplateBox[{"\[ThickSpace]", "\"\[ThickSpace]\"", 
                    StyleBox[
                    "\"Options\"", "InformationRowLabel", StripOnInput -> 
                    False], 
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "DownPointerOpener"]]},
                    "RowWithSeparators"], True->
                    TemplateBox[{"\[ThickSpace]", "\"\[ThickSpace]\"", 
                    StyleBox[
                    "\"Options\"", "InformationRowLabel", StripOnInput -> 
                    False], 
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "DownPointerOpenerHot"]]},
                    "RowWithSeparators"]}, Dynamic[
                    CurrentValue["MouseOver"]],
                    FrameMargins->0,
                    ImageSize->Automatic],
                    Appearance->None,
                    BaseStyle->None,
                    
                    ButtonFunction:>(Part[System`InformationDump`open$$, 3] = 
                    False),
                    Evaluator->Automatic,
                    FrameMargins->0,
                    ImageMargins->0,
                    Method->"Preemptive"], False->
                    ButtonBox[
                    PaneSelectorBox[{False->
                    TemplateBox[{"\[ThickSpace]", "\"\[ThickSpace]\"", 
                    StyleBox[
                    "\"Options\"", "InformationRowLabel", StripOnInput -> 
                    False], 
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "RightPointerOpener"]]},
                    "RowWithSeparators"], True->
                    TemplateBox[{"\[ThickSpace]", "\"\[ThickSpace]\"", 
                    StyleBox[
                    "\"Options\"", "InformationRowLabel", StripOnInput -> 
                    False], 
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "RightPointerOpenerHot"]]},
                    "RowWithSeparators"]}, Dynamic[
                    CurrentValue["MouseOver"]],
                    FrameMargins->0,
                    ImageSize->Automatic],
                    Appearance->None,
                    BaseStyle->None,
                    
                    ButtonFunction:>(Part[System`InformationDump`open$$, 3] = 
                    True),
                    Evaluator->Automatic,
                    FrameMargins->0,
                    ImageMargins->0,
                    Method->"Preemptive"]}, Dynamic[
                    FEPrivate`Part[System`InformationDump`open$$, 3]]], 
                   PaneSelectorBox[{True->GridBox[{
                    {
                    RowBox[{"PrintAs", "\[Rule]", "Automatic"}]},
                    {
                    RowBox[{"ConformalMetricName", "\[Rule]", "Automatic"}]},
                    {
                    RowBox[{"FrameColor", "\[Rule]", "Automatic"}]},
                    {
                    RowBox[{"SymbolOfCovD", "\[Rule]", "Automatic"}]},
                    {
                    StyleBox[
                    
                    TemplateBox[{
                    "\"(\"", "\"\[InvisibleSpace]\"", "4", "\" total)\""},
                    "RowDefault"], "InformationRowOpener",
                    StripOnInput->False]}
                    },
                    BaselinePosition->{Baseline, {1, 1}},
                    DefaultBaseStyle->"Column",
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{1.}}}], False->
                    RowBox[{
                    RowBox[{"PrintAs", "\[Rule]", "Automatic"}], 
                    "\[ThinSpace]", 
                    StyleBox["\<\"\[Ellipsis]\"\>", "InformationRowOpener",
                    StripOnInput->False], "\[ThinSpace]", 
                    StyleBox[
                    
                    TemplateBox[{
                    "\"(\"", "\"\[InvisibleSpace]\"", "4", "\" total)\""},
                    "RowDefault"], "InformationRowOpener",
                    StripOnInput->False]}]}, Dynamic[
                    FEPrivate`Part[System`InformationDump`open$$, 3]],
                    BaselinePosition->Baseline,
                    ImageSize->Automatic]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xConf`DefConformalMetric\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->{{6, 6}, {6, 3}}], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"DefConformalMetric[g,S] defines a metric \
conformally related to 'g', with the conformal factor 'S'. If other metrics \
are conformally related to 'g', then 'gS2' is related to them by transitivity \
of the conformal transformation. If the scalar field S[] does not exist, it \
is defined.\\n   Options are PrintAs->printasform, \
ConformalMetricName->MetricName, FrameColor->somecolor and \
SymbolOfCovD->{postfixsymbol,prefixsymbol}. If no ConformalMetricName is \
provided the name chosen is the concatenation 'metric+conformalfactor+2'. If \
no color is provided, it choses randomly a color. If no SymbolOfCovD is \
provided, the combination {:,\[Del]metricname} is chosen.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "DefConformalMetric[g,S] defines a metric conformally related to 'g', \
with the conformal factor 'S'. If other metrics are conformally related to \
'g', then 'gS2' is related to them by transitivity of the conformal \
transformation. If the scalar field S[] does not exist, it is defined.\n   \
Options are PrintAs->printasform, ConformalMetricName->MetricName, \
FrameColor->somecolor and SymbolOfCovD->{postfixsymbol,prefixsymbol}. If no \
ConformalMetricName is provided the name chosen is the concatenation \
'metric+conformalfactor+2'. If no color is provided, it choses randomly a \
color. If no SymbolOfCovD is provided, the combination {:,\[Del]metricname} \
is chosen.", "Documentation" -> None, "OwnValues" -> None, "UpValues" -> None,
     "DownValues" -> 
    Information`InformationValueForm[
     DownValues, xAct`xConf`DefConformalMetric, {
      xAct`xConf`DefConformalMetric[] :> Message[
         MessageName[xAct`xConf`DefConformalMetric, "argm"], 
         xAct`xConf`DefConformalMetric, 0, 2], xAct`xConf`DefConformalMetric[
         PatternTest[
          Pattern[xAct`xConf`Private`g, 
           Blank[]], xAct`xTensor`MetricQ], 
         Pattern[xAct`xConf`Private`conffactor, 
          Blank[]], 
         Pattern[xAct`xConf`Private`options, 
          OptionsPattern[]]] :> 
       Module[{xAct`xConf`Private`nmetlist, xAct`xConf`Private`pas, 
          xAct`xConf`Private`gconfnameraw, xAct`xConf`Private`cdgconf, 
          xAct`xConf`Private`metlist, xAct`xConf`Private`color, 
          xAct`xConf`Private`symbolscovd}, 
         Catch[
          With[{xAct`xConf`Private`M = xAct`xTensor`ManifoldOfCovD[
              xAct`xTensor`CovDOfMetric[xAct`xConf`Private`g]], 
            xAct`xConf`Private`CD = 
            xAct`xTensor`CovDOfMetric[xAct`xConf`Private`g]}, 
           With[{xAct`xConf`Private`i1 = xAct`xTensor`DummyIn[
               xAct`xTensor`Tangent[xAct`xConf`Private`M]], 
             xAct`xConf`Private`i2 = xAct`xTensor`DummyIn[
               xAct`xTensor`Tangent[xAct`xConf`Private`M]], 
             xAct`xConf`Private`sy1 = Part[
               xAct`xTensor`SymbolOfCovD[xAct`xConf`Private`CD], 1], 
             xAct`xConf`Private`sy2 = Part[
               xAct`xTensor`SymbolOfCovD[xAct`xConf`Private`CD], 2]}, 
            xAct`xConf`Private`metlist = 
             xAct`xTensor`$Metrics; {
              xAct`xConf`Private`pas, xAct`xConf`Private`gconfnameraw, 
               xAct`xConf`Private`color, xAct`xConf`Private`symbolscovd} = 
             OptionValue[{
               xAct`xTensor`PrintAs, xAct`xConf`ConformalMetricName, 
                xAct`xConf`FrameColor, xAct`xTensor`SymbolOfCovD}]; 
            If[xAct`xConf`Private`gconfnameraw === Automatic, 
              xAct`xConf`Private`gconfnameraw = 
              xAct`xConf`ConformalMetricName[
               xAct`xConf`Private`g, xAct`xConf`Private`conffactor]]; 
            With[{xAct`xConf`Private`gconfname = 
               xAct`xConf`Private`gconfnameraw}, 
              xAct`xConf`Private`cdgconf = 
               xAct`xCore`SymbolJoin[
                xAct`xConf`Private`CD, xAct`xConf`Private`gconfname]; If[
                xAct`xTensor`MetricQ[xAct`xConf`Private`gconfname], 
                Message[
                 MessageName[xAct`xConf`DefConformalMetric, "old"], 
                 xAct`xConf`Private`gconfname]]; 
              If[xAct`xConf`Private`symbolscovd == Automatic, 
                xAct`xConf`Private`symbolscovd = {
                 ":", "\[Del]" <> ToString[xAct`xConf`Private`gconfname]}]; If[
                Not[
                 xAct`xTensor`xTensorQ[xAct`xConf`Private`gconfname]], 
                If[xAct`xConf`Private`pas === Automatic, 
                  xAct`xConf`Private`pas = 
                  "[" <> xAct`xTensor`PrintAs[xAct`xConf`Private`g] <> (
                    "\!\(" <> xAct`xTensor`PrintAs[
                    xAct`xConf`Private`conffactor] <> "\^2\)") <> "]"]; 
                If[xAct`xConf`Private`color === Automatic, 
                  xAct`xConf`Private`color = RandomColor[]]; 
                Print["Choosing color ", xAct`xConf`Private`color, 
                  " for this conformal frame."]; 
                xAct`xConf`Private`ColorFrame[xAct`xConf`Private`gconfname] = 
                 xAct`xConf`Private`color; If[
                  Not[
                   xAct`xTensor`xTensorQ[xAct`xConf`Private`conffactor]], 
                  xAct`xTensor`DefTensor[
                   xAct`xConf`Private`conffactor[], {xAct`xConf`Private`M}, 
                   xAct`xTensor`PrintAs -> 
                   ToString[xAct`xConf`Private`conffactor]]]; Off[
                  MessageName[xAct`xTensor`DefMetric, "old"]]; 
                xAct`xTensor`DefMetric[
                  xAct`xTensor`SignDetOfMetric[xAct`xConf`Private`g], 
                  
                  xAct`xConf`Private`gconfname[-xAct`xConf`Private`i1, -
                   xAct`xConf`Private`i2], xAct`xConf`Private`cdgconf, 
                  xAct`xConf`Private`symbolscovd, xAct`xTensor`PrintAs -> 
                  xAct`xConf`Private`pas, xAct`xTensor`ConformalTo -> {
                    
                    xAct`xConf`Private`g[-xAct`xConf`Private`i1, -
                    xAct`xConf`Private`i2], 
                    xAct`xConf`Private`conffactor[]^2}]; 
                xAct`xTensor`DefInertHead[
                  xAct`xConf`ConformalFrame[xAct`xConf`Private`gconfname], 
                  xAct`xTensor`ContractThrough -> {xAct`xTensor`delta}]; If[
                  Not[
                   xAct`xTensor`InertHeadQ[
                    xAct`xConf`ConformalFrame[xAct`xConf`Private`g]]], 
                  xAct`xTensor`DefInertHead[
                    xAct`xConf`ConformalFrame[xAct`xConf`Private`g], 
                    xAct`xTensor`ContractThrough -> {xAct`xTensor`delta}]; 
                  Null]; TagSet[xAct`xConf`Private`gconfname, 
                  xAct`xConf`SqrtConformalFactor[
                  xAct`xConf`Private`gconfname, xAct`xConf`Private`g], 
                  xAct`xConf`Private`conffactor[]]; 
                TagSet[xAct`xConf`Private`gconfname, 
                  xAct`xConf`SqrtConformalFactor[
                  xAct`xConf`Private`g, xAct`xConf`Private`gconfname], 1/
                  xAct`xConf`Private`conffactor[]]; 
                xAct`xConf`ConformalFrame[
                   Blank[]][
                   xAct`xConf`Private`conffactor[]] := 
                 xAct`xConf`Private`conffactor[]; 
                xAct`xConf`RulesChangeConformalFrame[
                 xAct`xConf`Private`g, xAct`xConf`Private`gconfname]; 
                xAct`xConf`RulesChangeConformalFrame[
                 xAct`xConf`Private`gconfname, xAct`xConf`Private`g]; 
                Map[If[Catch[
                    xAct`xTensor`ConformalRules[
                    xAct`xConf`Private`g, #]] =!= {}, 
                   xAct`xTensor`SetConformalTo[
                    
                    xAct`xConf`Private`gconfname[-xAct`xConf`Private`i1, -
                    xAct`xConf`Private`i2], {
                    #[-xAct`xConf`Private`i1, -xAct`xConf`Private`i2], 
                    xAct`xTensor`ConformalFactor[xAct`xConf`Private`g, #] 
                    xAct`xConf`Private`conffactor[]^2}]; 
                   TagSet[xAct`xConf`Private`gconfname, 
                    xAct`xConf`SqrtConformalFactor[
                    xAct`xConf`Private`gconfname, #], 
                    xAct`xConf`SqrtConformalFactor[xAct`xConf`Private`g, #] 
                    xAct`xConf`Private`conffactor[]]; 
                   TagSet[xAct`xConf`Private`gconfname, 
                    
                    xAct`xConf`SqrtConformalFactor[#, 
                    xAct`xConf`Private`gconfname], 1/(
                    xAct`xConf`SqrtConformalFactor[xAct`xConf`Private`g, #] 
                    xAct`xConf`Private`conffactor[])]; 
                   xAct`xConf`RulesChangeConformalFrame[#, 
                    xAct`xConf`Private`gconfname]; 
                   xAct`xConf`RulesChangeConformalFrame[
                    xAct`xConf`Private`gconfname, #]; Null]& , 
                  xAct`xConf`Private`metlist]; Null]; Null]]]]], 
       xAct`xConf`DefConformalMetric[
         Blank[]] :> Message[
         MessageName[xAct`xConf`DefConformalMetric, "argr"], 
         xAct`xConf`DefConformalMetric, {2, 
          DirectedInfinity[1]}]}], "SubValues" -> None, "DefaultValues" -> 
    None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> {
     xAct`xTensor`PrintAs -> Automatic, xAct`xConf`ConformalMetricName -> 
      Automatic, xAct`xConf`FrameColor -> Automatic, 
      xAct`xTensor`SymbolOfCovD -> Automatic}, "Attributes" -> {Protected}, 
    "FullName" -> "xAct`xConf`DefConformalMetric"|>, False]]], "Output",
 CellLabel->"Out[4]=",ExpressionUUID->"b4c0de23-ccc6-4c91-9573-6b875d6f24e7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DefConformalMetric", "[", 
  RowBox[{"g", ",", "S", ",", 
   RowBox[{"FrameColor", "->", "Red"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"DefConformalMetric", "[", 
  RowBox[{"g", ",", "s", ",", 
   RowBox[{"FrameColor", "->", "Blue"}]}], "]"}]}], "Input",
 CellLabel->"In[5]:=",ExpressionUUID->"5fd15a73-c93c-4f82-9220-eae3263c5564"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Choosing color \"\>", "\[InvisibleSpace]", 
   TemplateBox[<|"color" -> RGBColor[1, 0, 0]|>,
    "RGBColorSwatchTemplate"], 
   "\[InvisibleSpace]", "\<\" for this conformal frame.\"\>"}],
  SequenceForm["Choosing color ", 
   RGBColor[1, 0, 0], " for this conformal frame."],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"f3911d5f-c72f-4491-94d9-c2b5a38ca6ac"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"S", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`S[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"bda08027-2239-4118-bf22-2c89b2352250"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric metric tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"gS2", "[", 
    RowBox[{
     RowBox[{"-", "\[Sigma]$4399"}], ",", 
     RowBox[{"-", "\[Sigma]$4400"}]}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric metric tensor ", 
   $CellContext`gS2[-$CellContext`\[Sigma]$4399, -$CellContext`\[Sigma]$4400],
    ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"c6b919b5-38ba-4b83-bfc0-6ce5c08503bb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"inverse metric tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"InvgS2", "[", 
    RowBox[{"\[Sigma]$4399", ",", "\[Sigma]$4400"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Metric is frozen!\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "inverse metric tensor ", 
   $CellContext`InvgS2[$CellContext`\[Sigma]$4399, \
$CellContext`\[Sigma]$4400], ". ", "Metric is frozen!"],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"a4b0af34-5551-4ce9-a177-386063f4ae92"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric tensor \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"epsilongS2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric tensor ", 
   $CellContext`epsilongS2[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"7aa3ddea-94ad-4f81-b46b-f7a8d730ec18"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tetrametric \"\>", "\[InvisibleSpace]", 
   RowBox[{"TetragS2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tetrametric ", 
   $CellContext`TetragS2[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"7825d055-b80b-4d82-8c74-f45178186802"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tetrametric \"\>", "\[InvisibleSpace]", 
   RowBox[{"TetragS2\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tetrametric ", 
   $CellContext`TetragS2\[Dagger][-$CellContext`\[Alpha], -$CellContext`\
\[Beta], -$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"98e3202b-92b8-4e49-b62a-1c7e3e037c2e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"CDgS2", "[", 
    RowBox[{"-", "\[Sigma]$4399"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "covariant derivative ", 
   $CellContext`CDgS2[-$CellContext`\[Sigma]$4399], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"a65a2b8d-8fa4-4816-a1c2-029de7dd846a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing torsion tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TorsionCDgS2", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing torsion tensor ", 
   $CellContext`TorsionCDgS2[$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"4c5651db-b657-45cd-ad9c-49540ea4b165"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCDgS2", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Christoffel tensor ", 
   $CellContext`ChristoffelCDgS2[$CellContext`\[Alpha], \
-$CellContext`\[Beta], -$CellContext`\[Gamma]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"edabcb54-be5d-40f4-8917-576899e69862"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannDownCDgS2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`RiemannDownCDgS2[-$CellContext`\[Alpha], \
-$CellContext`\[Beta], -$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ",
    ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"d1407b54-074b-4543-915d-1a9f84ecb18f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannCDgS2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", "\[Lambda]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Antisymmetric only in the first pair.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`RiemannCDgS2[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], $CellContext`\[Lambda]], ". ", 
   "Antisymmetric only in the first pair."],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"2f5db2b0-6ea5-4b0c-a907-641ded6f1570"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciCDgS2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric Ricci tensor ", 
   $CellContext`RicciCDgS2[-$CellContext`\[Alpha], -$CellContext`\[Beta]], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"d701c35d-ffa0-4fd2-b7e3-427a35819c7c"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Riemann automatically replaced \
by Ricci.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"e3a6ba41-8391-4d53-a1b0-8f37fc09325e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"RicciScalarCDgS2", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Ricci scalar ", 
   $CellContext`RicciScalarCDgS2[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"4c7a67b9-5ee1-4c17-89ed-765b702c699a"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Ricci automatically replaced \
by RicciScalar.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"a77e566c-7b0b-4715-b98c-1fcfcaf07d64"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Einstein tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"EinsteinCDgS2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Einstein tensor ", 
   $CellContext`EinsteinCDgS2[-$CellContext`\[Alpha], -$CellContext`\[Beta]], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"048c9f2b-42c8-40d8-9c64-7163315288b7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Weyl tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"WeylCDgS2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "Weyl tensor ", 
   $CellContext`WeylCDgS2[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"65db86ce-1e53-4e93-b726-71d459a79bfc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric TFRicci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TFRicciCDgS2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric TFRicci tensor ", 
   $CellContext`TFRicciCDgS2[-$CellContext`\[Alpha], -$CellContext`\[Beta]], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"27add888-17a0-447d-8b1e-5858dd9a8493"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Kretschmann scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"KretschmannCDgS2", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Kretschmann scalar ", 
   $CellContext`KretschmannCDgS2[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"7bf17336-f8fd-4a1d-9809-7977341518bf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RiemannToWeylRules for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RiemannToWeylRules for dim ", 4],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"e2487b85-612c-481a-be59-db2c255d0022"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToEinsteinRules for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RicciToEinsteinRules for dim ", 4],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"a244d7b3-a6c6-4c16-baaf-acb7feac0d46"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"weight +2 density \"\>", "\[InvisibleSpace]", 
   RowBox[{"DetgS2", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Determinant.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "weight +2 density ", 
   $CellContext`DetgS2[], ". ", "Determinant."],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"4d101911-0b22-4393-ad97-c298d0d6706d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefInertHead", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"inert head \"\>", "\[InvisibleSpace]", 
   RowBox[{"ConformalFrame", "[", "gS2", "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefInertHead, ": Defining ", "inert head ", 
   xAct`xConf`ConformalFrame[$CellContext`gS2], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"613cd1d4-388d-4cd2-af3e-e2c185b3ea24"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefInertHead", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"inert head \"\>", "\[InvisibleSpace]", 
   RowBox[{"ConformalFrame", "[", "g", "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefInertHead, ": Defining ", "inert head ", 
   xAct`xConf`ConformalFrame[$CellContext`g], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"f7f31e01-e72a-4006-b6e6-3b105b3841d5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Choosing color \"\>", "\[InvisibleSpace]", 
   TemplateBox[<|"color" -> RGBColor[0, 0, 1]|>,
    "RGBColorSwatchTemplate"], 
   "\[InvisibleSpace]", "\<\" for this conformal frame.\"\>"}],
  SequenceForm["Choosing color ", 
   RGBColor[0, 0, 1], " for this conformal frame."],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"e4672297-fb22-4fa1-813a-f7017afb1c88"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"s", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`s[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"f228d0fa-29b5-4e8b-8aaa-628703d1a0e6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric metric tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"gs2", "[", 
    RowBox[{
     RowBox[{"-", "\[Sigma]$4782"}], ",", 
     RowBox[{"-", "\[Sigma]$4783"}]}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric metric tensor ", 
   $CellContext`gs2[-$CellContext`\[Sigma]$4782, -$CellContext`\[Sigma]$4783],
    ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"dfefb2c1-ce10-4ce8-a567-e1fc231cecba"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"inverse metric tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Invgs2", "[", 
    RowBox[{"\[Sigma]$4782", ",", "\[Sigma]$4783"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Metric is frozen!\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "inverse metric tensor ", 
   $CellContext`Invgs2[$CellContext`\[Sigma]$4782, \
$CellContext`\[Sigma]$4783], ". ", "Metric is frozen!"],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"489a919f-af9c-4c7b-adba-a9f033680072"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric tensor \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"epsilongs2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric tensor ", 
   $CellContext`epsilongs2[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"ea44259a-d4c4-4c86-bfa5-2905280d3e84"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tetrametric \"\>", "\[InvisibleSpace]", 
   RowBox[{"Tetrags2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tetrametric ", 
   $CellContext`Tetrags2[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"c22b0b96-2e1e-4de7-bae8-4ed326dc0455"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tetrametric \"\>", "\[InvisibleSpace]", 
   RowBox[{"Tetrags2\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tetrametric ", 
   $CellContext`Tetrags2\[Dagger][-$CellContext`\[Alpha], -$CellContext`\
\[Beta], -$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"ff2b833d-9e0d-479e-b273-ca611e21c607"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"CDgs2", "[", 
    RowBox[{"-", "\[Sigma]$4782"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "covariant derivative ", 
   $CellContext`CDgs2[-$CellContext`\[Sigma]$4782], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"d97f7f7a-e788-40cb-a8c4-7c7e1449d227"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing torsion tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TorsionCDgs2", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing torsion tensor ", 
   $CellContext`TorsionCDgs2[$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"50efde67-db53-4269-9204-93c231cd6fbf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCDgs2", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Christoffel tensor ", 
   $CellContext`ChristoffelCDgs2[$CellContext`\[Alpha], \
-$CellContext`\[Beta], -$CellContext`\[Gamma]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"afdf82a2-005d-4d15-b3fe-0ff0b67972c3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannDownCDgs2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`RiemannDownCDgs2[-$CellContext`\[Alpha], \
-$CellContext`\[Beta], -$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ",
    ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"cff3989e-6b5a-4a99-b0e8-800549cc7c72"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannCDgs2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", "\[Lambda]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Antisymmetric only in the first pair.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`RiemannCDgs2[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], $CellContext`\[Lambda]], ". ", 
   "Antisymmetric only in the first pair."],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"04e3083d-8ee9-45a9-8393-db40a53eeba1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciCDgs2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric Ricci tensor ", 
   $CellContext`RicciCDgs2[-$CellContext`\[Alpha], -$CellContext`\[Beta]], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"391a5ebb-9880-47e7-b0bf-865bd421bdf8"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Riemann automatically replaced \
by Ricci.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"1a5d094b-199c-4c9f-88fa-d19e431d6cba"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"RicciScalarCDgs2", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Ricci scalar ", 
   $CellContext`RicciScalarCDgs2[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"f0be2ea0-d089-41b9-a7d5-cc5fa07dae34"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Ricci automatically replaced \
by RicciScalar.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"9cb9d4d5-889e-4ff7-8e4b-592b028884ad"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Einstein tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"EinsteinCDgs2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Einstein tensor ", 
   $CellContext`EinsteinCDgs2[-$CellContext`\[Alpha], -$CellContext`\[Beta]], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"8eb58580-9b13-4b72-80ad-831eed431050"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Weyl tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"WeylCDgs2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "Weyl tensor ", 
   $CellContext`WeylCDgs2[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"6de43b5d-2435-4082-b6ce-79663c1b36d3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric TFRicci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TFRicciCDgs2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric TFRicci tensor ", 
   $CellContext`TFRicciCDgs2[-$CellContext`\[Alpha], -$CellContext`\[Beta]], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"e958796c-70d3-4e6f-889a-4a6cc27aa04d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Kretschmann scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"KretschmannCDgs2", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Kretschmann scalar ", 
   $CellContext`KretschmannCDgs2[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"50daea3a-f747-4ba6-a42e-574db76302eb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RiemannToWeylRules for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RiemannToWeylRules for dim ", 4],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"be89e528-738b-404f-ac2f-1e2570e70e5e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToEinsteinRules for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RicciToEinsteinRules for dim ", 4],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"843b4ae7-0ef8-4bca-b50e-e080eb0fd0ed"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"weight +2 density \"\>", "\[InvisibleSpace]", 
   RowBox[{"Detgs2", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Determinant.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "weight +2 density ", 
   $CellContext`Detgs2[], ". ", "Determinant."],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"d52b0ad4-d4a3-4382-bed0-eb556ef685f4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefInertHead", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"inert head \"\>", "\[InvisibleSpace]", 
   RowBox[{"ConformalFrame", "[", "gs2", "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefInertHead, ": Defining ", "inert head ", 
   xAct`xConf`ConformalFrame[$CellContext`gs2], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"769632ae-290d-4819-b381-0a0bcde1a219"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Head", "[", 
  RowBox[{
   RowBox[{"Christoffel", "[", "CDgS2", "]"}], "[", 
   RowBox[{"\[Alpha]", ",", 
    RowBox[{"-", "\[Mu]"}], ",", 
    RowBox[{"-", "\[Nu]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[7]:=",ExpressionUUID->"30b99c1f-ecba-4b77-a1c3-9af2a5059ac9"],

Cell[BoxData["ChristoffelCDgS2"], "Output",
 CellLabel->"Out[7]=",ExpressionUUID->"22234953-7133-4169-a20e-4d16f9f993d3"]
}, Open  ]],

Cell["\<\
We check that we now have 3 metrics, but only the first one is used to raise \
and lower indices . This is the ambient metric .\
\>", "Text",ExpressionUUID->"47f3d780-3e97-4608-9511-f3c4a8473788"],

Cell[CellGroupData[{

Cell[BoxData["$Metrics"], "Input",
 CellLabel->"In[8]:=",ExpressionUUID->"035a2530-fef1-40c7-93eb-141dc6dbe2ea"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"g", ",", "gS2", ",", "gs2"}], "}"}]], "Output",
 CellLabel->"Out[8]=",ExpressionUUID->"bce2d499-22df-4ed3-8b6c-6612ebe50c09"]
}, Open  ]],

Cell["\<\
The package has defined automatically all relevant conformal rules to relate \
two by two all metrics given the known conformal factors.\
\>", "Text",ExpressionUUID->"cd631931-80b9-456b-b8ad-19127b7f93df"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ConformalRules", "[", 
  RowBox[{"g", ",", "gS2"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ConformalRules", "[", 
  RowBox[{"g", ",", "gs2"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ConformalRules", "[", 
  RowBox[{"gS2", ",", "gs2"}], "]"}]}], "Input",
 CellLabel->"In[9]:=",ExpressionUUID->"ceb81265-5e81-4ee7-94b1-7498416bbcd8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {
             UnderscriptBox[
              UnderscriptBox["\[Sigma]$4399", "_"], "_"], 
             UnderscriptBox[
              UnderscriptBox["\[Sigma]$4400", "_"], "_"]},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[
      PatternTest[
       Pattern[$CellContext`\[Sigma]$4399, 
        Blank[]], xAct`xTensor`DownIndexQ], 
      PatternTest[
       Pattern[$CellContext`\[Sigma]$4400, 
        Blank[]], xAct`xTensor`DownIndexQ]],
     Editable->False], "\[Rule]", 
    FractionBox[
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"[", 
           RowBox[{"g", 
            SuperscriptBox["S", "2"]}], "]"}], 
          StyleBox[GridBox[{
             {"\[Sigma]$4399", "\[Sigma]$4400"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`gS2[$CellContext`\[Sigma]$4399, $CellContext`\[Sigma]$4400],
      Editable->False], 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["S",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`S[],
       Editable->False], "2"]]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {
             UnderscriptBox[
              UnderscriptBox["\[Sigma]$4399", "_"], "_"], 
             UnderscriptBox[
              UnderscriptBox["\[Sigma]$4400", "_"], "_"]},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[
      PatternTest[
       Pattern[$CellContext`\[Sigma]$4399, 
        Blank[]], xAct`xTensor`UpIndexQ], 
      PatternTest[
       Pattern[$CellContext`\[Sigma]$4400, 
        Blank[]], xAct`xTensor`UpIndexQ]],
     Editable->False], "\[Rule]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"i", "[", 
           RowBox[{"g", 
            SuperscriptBox["S", "2"]}], "]"}], 
          StyleBox[GridBox[{
             {"\[Sigma]$4399", "\[Sigma]$4400"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`InvgS2[$CellContext`\[Sigma]$4399, \
$CellContext`\[Sigma]$4400],
      Editable->False], " ", 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["S",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`S[],
       Editable->False], "2"]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      OverscriptBox["g", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Detg[],
     Editable->False], "\[Rule]", 
    FractionBox[
     InterpretationBox[
      StyleBox[
       OverscriptBox[
        RowBox[{"[", 
         RowBox[{"g", 
          SuperscriptBox["S", "2"]}], "]"}], 
        OverscriptBox[
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]], 
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]]]],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`DetgS2[],
      Editable->False], 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["S",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`S[],
       Editable->False], "8"]]}]}], "}"}]], "Output",
 CellLabel->"Out[9]=",ExpressionUUID->"822eabfc-8942-4c62-a622-568f91a7657f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {
             UnderscriptBox[
              UnderscriptBox["\[Sigma]$4782", "_"], "_"], 
             UnderscriptBox[
              UnderscriptBox["\[Sigma]$4783", "_"], "_"]},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[
      PatternTest[
       Pattern[$CellContext`\[Sigma]$4782, 
        Blank[]], xAct`xTensor`DownIndexQ], 
      PatternTest[
       Pattern[$CellContext`\[Sigma]$4783, 
        Blank[]], xAct`xTensor`DownIndexQ]],
     Editable->False], "\[Rule]", 
    FractionBox[
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"[", 
           RowBox[{"g", 
            SuperscriptBox["s", "2"]}], "]"}], 
          StyleBox[GridBox[{
             {"\[Sigma]$4782", "\[Sigma]$4783"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`gs2[$CellContext`\[Sigma]$4782, $CellContext`\[Sigma]$4783],
      Editable->False], 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["s",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`s[],
       Editable->False], "2"]]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {
             UnderscriptBox[
              UnderscriptBox["\[Sigma]$4782", "_"], "_"], 
             UnderscriptBox[
              UnderscriptBox["\[Sigma]$4783", "_"], "_"]},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[
      PatternTest[
       Pattern[$CellContext`\[Sigma]$4782, 
        Blank[]], xAct`xTensor`UpIndexQ], 
      PatternTest[
       Pattern[$CellContext`\[Sigma]$4783, 
        Blank[]], xAct`xTensor`UpIndexQ]],
     Editable->False], "\[Rule]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"i", "[", 
           RowBox[{"g", 
            SuperscriptBox["s", "2"]}], "]"}], 
          StyleBox[GridBox[{
             {"\[Sigma]$4782", "\[Sigma]$4783"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Invgs2[$CellContext`\[Sigma]$4782, \
$CellContext`\[Sigma]$4783],
      Editable->False], " ", 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["s",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`s[],
       Editable->False], "2"]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      OverscriptBox["g", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Detg[],
     Editable->False], "\[Rule]", 
    FractionBox[
     InterpretationBox[
      StyleBox[
       OverscriptBox[
        RowBox[{"[", 
         RowBox[{"g", 
          SuperscriptBox["s", "2"]}], "]"}], 
        OverscriptBox[
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]], 
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]]]],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Detgs2[],
      Editable->False], 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["s",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`s[],
       Editable->False], "8"]]}]}], "}"}]], "Output",
 CellLabel->"Out[10]=",ExpressionUUID->"4585a404-70cf-4b96-94ea-8c398e0429cf"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"[", 
          RowBox[{"g", 
           SuperscriptBox["S", "2"]}], "]"}], 
         StyleBox[GridBox[{
            {
             UnderscriptBox["\[Sigma]$4782", "_"], 
             UnderscriptBox["\[Sigma]$4783", "_"]},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`gS2[
      Pattern[$CellContext`\[Sigma]$4782, 
       Blank[]], 
      Pattern[$CellContext`\[Sigma]$4783, 
       Blank[]]],
     Editable->False], "\[Rule]", 
    FractionBox[
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"[", 
            RowBox[{"g", 
             SuperscriptBox["s", "2"]}], "]"}], 
           StyleBox[GridBox[{
              {"\[Sigma]$4782", "\[Sigma]$4783"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`gs2[$CellContext`\[Sigma]$4782, \
$CellContext`\[Sigma]$4783],
       Editable->False], " ", 
      SuperscriptBox[
       InterpretationBox[
        StyleBox["S",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`S[],
        Editable->False], "2"]}], 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["s",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`s[],
       Editable->False], "2"]]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"i", "[", 
          RowBox[{"g", 
           SuperscriptBox["S", "2"]}], "]"}], 
         StyleBox[GridBox[{
            {
             UnderscriptBox["\[Sigma]$4782", "_"], 
             UnderscriptBox["\[Sigma]$4783", "_"]},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`InvgS2[
      Pattern[$CellContext`\[Sigma]$4782, 
       Blank[]], 
      Pattern[$CellContext`\[Sigma]$4783, 
       Blank[]]],
     Editable->False], "\[Rule]", 
    FractionBox[
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"i", "[", 
            RowBox[{"g", 
             SuperscriptBox["s", "2"]}], "]"}], 
           StyleBox[GridBox[{
              {"\[Sigma]$4782", "\[Sigma]$4783"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`Invgs2[$CellContext`\[Sigma]$4782, \
$CellContext`\[Sigma]$4783],
       Editable->False], " ", 
      SuperscriptBox[
       InterpretationBox[
        StyleBox["s",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`s[],
        Editable->False], "2"]}], 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["S",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`S[],
       Editable->False], "2"]]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      OverscriptBox[
       RowBox[{"[", 
        RowBox[{"g", 
         SuperscriptBox["S", "2"]}], "]"}], 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`DetgS2[],
     Editable->False], "\[Rule]", 
    FractionBox[
     RowBox[{
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         RowBox[{"[", 
          RowBox[{"g", 
           SuperscriptBox["s", "2"]}], "]"}], 
         OverscriptBox[
          StyleBox["~",
           FontColor->RGBColor[0, 0, 0]], 
          StyleBox["~",
           FontColor->RGBColor[0, 0, 0]]]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`Detgs2[],
       Editable->False], " ", 
      SuperscriptBox[
       InterpretationBox[
        StyleBox["S",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`S[],
        Editable->False], "8"]}], 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["s",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`s[],
       Editable->False], "8"]]}]}], "}"}]], "Output",
 CellLabel->
  "Out[11]=",ExpressionUUID->"5b81b765-0b63-4272-a03a-82e43485d885"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Defining tensors with their conformal weight.", \
"Subsubsection",ExpressionUUID->"7ad0eab4-069d-441e-a08c-c090b19d09d8"],

Cell["\<\
Let us define a vector and a tensor, with down indices in the natural \
position.\
\>", "Text",ExpressionUUID->"15ec7c16-ebe2-4d98-9e44-b5302cec91df"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"k", "[", 
    RowBox[{"-", "\[Alpha]"}], "]"}], ",", 
   RowBox[{"{", "M", "}"}], ",", 
   RowBox[{"PrintAs", "\[Rule]", "\"\<k\>\""}]}], "]"}]], "Input",
 CellLabel->"In[12]:=",ExpressionUUID->"72fcdf3b-ff17-4f6e-9938-97de62c0f675"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"k", "[", 
    RowBox[{"-", "\[Alpha]"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`k[-$CellContext`\[Alpha]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[12]:=",ExpressionUUID->"5073fbd3-a4f4-4f18-9e43-f1a9128915c0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"MT2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], ",", 
   RowBox[{"{", "M", "}"}], ",", 
   RowBox[{"PrintAs", "\[Rule]", "\"\<M\>\""}]}], "]"}]], "Input",
 CellLabel->"In[13]:=",ExpressionUUID->"c01c8c21-de80-400b-9ea5-0aea07a39de1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"MT2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`MT2[-$CellContext`\[Alpha], -$CellContext`\[Beta]], ". ", ""],
  
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[13]:=",ExpressionUUID->"ed0e6cdf-6475-4c2f-8db3-076cd240d10d"]
}, Open  ]],

Cell["\<\
By default the conformal weight is the number of down indices - the number of \
up indices .\
\>", "Text",ExpressionUUID->"c5722dc6-7ed3-4edf-9451-fd6ff7abcc33"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "ConformalWeight"}]], "Input",
 CellLabel->"In[14]:=",ExpressionUUID->"e8d883d1-5416-4f5f-a4fa-bd1ddd2987c9"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"ConformalWeight[tensor[inds]] specifies the power \
of the conformal factor applied in the conformal transformation of the tensor \
'tensor'. It corresponds to the number of down indices, minus the number of \
up indices, plus the quantity ConformalWeight[tensor] (without the indices). \
The latter is set by default to zero. \\n\\nFor instance, with the setting \
ConformalWeight[tensor] = 0, we have: \
ConformalWeight[tensor[\[Alpha],\[Beta]]] = -2, and ConformalWeight[tensor[-\
\[Alpha],-\[Beta]]] = 2.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[
           TagBox[GridBox[{
              {
               StyleBox[
                TagBox[
                 TooltipBox[
                  StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                   StripOnInput->False],
                  "\"Definitions\"",
                  TooltipStyle->"TextStyling"],
                 Annotation[#, "Definitions", "Tooltip"]& ], "DialogStyle",
                StripOnInput->False]},
              {
               TemplateBox[{"\"\[ThinSpace]\"", 
                 GridBox[{{
                    RowBox[{
                    RowBox[{"ConformalWeight", "[", 
                    RowBox[{"xAct`xConf`Private`tens_", "?", "xTensorQ"}], 
                    "]"}], ":=", "0"}]}, {" "}, {
                    RowBox[{
                    RowBox[{"ConformalWeight", "[", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`tens_", "?", "xTensorQ"}], 
                    "[", "xAct`xConf`Private`indices___", "]"}], "]"}], ":=", 
                    
                    RowBox[{
                    
                    RowBox[{
                    "ConformalWeight", "[", "xAct`xConf`Private`tens", "]"}], 
                    "+", 
                    RowBox[{"xAct`xConf`Private`WeightOfIndicesList", "[", 
                    RowBox[{"{", "xAct`xConf`Private`indices", "}"}], 
                    "]"}]}]}]}, {" "}, {
                    RowBox[{
                    RowBox[{"ConformalWeight", "[", 
                    RowBox[{"xAct`xConf`Private`f_", "?", "ScalarFunctionQ"}],
                     "]"}], ":=", "0"}]}, {" "}}, 
                  GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                  DefaultBaseStyle -> "Column", 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                "RowDefault"]}
             },
             DefaultBaseStyle->"Column",
             GridBoxAlignment->{"Columns" -> {{Left}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
            "Column"],
           FrameMargins->{{6, 0}, {3, 6}}], "\<\"\"\>"},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xConf`ConformalWeight\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->{{6, 6}, {6, 3}}], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"ConformalWeight[tensor[inds]] specifies the power \
of the conformal factor applied in the conformal transformation of the tensor \
'tensor'. It corresponds to the number of down indices, minus the number of \
up indices, plus the quantity ConformalWeight[tensor] (without the indices). \
The latter is set by default to zero. \\n\\nFor instance, with the setting \
ConformalWeight[tensor] = 0, we have: \
ConformalWeight[tensor[\[Alpha],\[Beta]]] = -2, and ConformalWeight[tensor[-\
\[Alpha],-\[Beta]]] = 2.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "ConformalWeight[tensor[inds]] specifies the power of the conformal \
factor applied in the conformal transformation of the tensor 'tensor'. It \
corresponds to the number of down indices, minus the number of up indices, \
plus the quantity ConformalWeight[tensor] (without the indices). The latter \
is set by default to zero. \n\nFor instance, with the setting \
ConformalWeight[tensor] = 0, we have: \
ConformalWeight[tensor[\[Alpha],\[Beta]]] = -2, and ConformalWeight[tensor[-\
\[Alpha],-\[Beta]]] = 2.", "Documentation" -> None, "OwnValues" -> None, 
    "UpValues" -> None, "DownValues" -> 
    Information`InformationValueForm[
     DownValues, xAct`xConf`ConformalWeight, {xAct`xConf`ConformalWeight[
         PatternTest[
          Pattern[xAct`xConf`Private`tens, 
           Blank[]], xAct`xTensor`xTensorQ]] :> 0, 
       xAct`xConf`ConformalWeight[
         PatternTest[
          Pattern[xAct`xConf`Private`tens, 
           Blank[]], xAct`xTensor`xTensorQ][
          Pattern[xAct`xConf`Private`indices, 
           BlankNullSequence[]]]] :> 
       xAct`xConf`ConformalWeight[xAct`xConf`Private`tens] + 
        xAct`xConf`Private`WeightOfIndicesList[{xAct`xConf`Private`indices}], 
       xAct`xConf`ConformalWeight[
         PatternTest[
          Pattern[xAct`xConf`Private`f, 
           Blank[]], xAct`xTensor`ScalarFunctionQ]] :> 0}], "SubValues" -> 
    None, "DefaultValues" -> None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> None, "Attributes" -> {}, "FullName" -> 
    "xAct`xConf`ConformalWeight"|>, False]]], "Output",
 CellLabel->
  "Out[14]=",ExpressionUUID->"6a1afa90-afa4-4d64-9bd3-1a41b92f5d87"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ConformalWeight", "[", 
  RowBox[{"k", "[", "\[Mu]", "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ConformalWeight", "[", 
  RowBox[{"k", "[", 
   RowBox[{"-", "\[Mu]"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ConformalWeight", "[", 
  RowBox[{"MT2", "[", 
   RowBox[{
    RowBox[{"-", "\[Alpha]"}], ",", 
    RowBox[{"-", "\[Beta]"}]}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ConformalWeight", "[", 
  RowBox[{"MT2", "[", 
   RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"ConformalWeight", "[", 
  RowBox[{"MT2", "[", 
   RowBox[{"\[Alpha]", ",", 
    RowBox[{"-", "\[Beta]"}]}], "]"}], "]"}]}], "Input",
 CellLabel->"In[15]:=",ExpressionUUID->"53c4f8dc-f78f-48af-9682-6d242150f948"],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 CellLabel->"Out[15]=",ExpressionUUID->"53987bac-e9e6-4eda-8b8d-ac32947ae3ff"],

Cell[BoxData["1"], "Output",
 CellLabel->"Out[16]=",ExpressionUUID->"682fe606-910f-4b8f-baf6-62f973071738"],

Cell[BoxData["2"], "Output",
 CellLabel->"Out[17]=",ExpressionUUID->"9b707690-2be8-4dd9-89c1-8a1d392fa470"],

Cell[BoxData[
 RowBox[{"-", "2"}]], "Output",
 CellLabel->"Out[18]=",ExpressionUUID->"319b82ec-2367-4fcc-a9f1-3523348a4ed9"],

Cell[BoxData["0"], "Output",
 CellLabel->
  "Out[19]=",ExpressionUUID->"cfb8dfc1-71b5-463d-ba7c-a4c0dcc119a1"]
}, Open  ]],

Cell["\<\
This can be offset by redefining the conformal weight of the symbol itself . \
By default it is 0.\
\>", "Text",ExpressionUUID->"dd3b3c65-0f31-4e63-a351-2d5af6d72b36"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ConformalWeight", "[", "k", "]"}], "\[IndentingNewLine]", 
 RowBox[{"ConformalWeight", "[", "MT2", "]"}]}], "Input",
 CellLabel->"In[20]:=",ExpressionUUID->"e19c15bc-f638-4b7a-9931-94271713ead9"],

Cell[BoxData["0"], "Output",
 CellLabel->"Out[20]=",ExpressionUUID->"f2e0e038-b624-4da3-b100-455926738094"],

Cell[BoxData["0"], "Output",
 CellLabel->
  "Out[21]=",ExpressionUUID->"09ea8235-8dea-447b-b67f-42ba6c854e24"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ConformalWeight", "[", "k", "]"}], "=", 
   RowBox[{"-", "1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ConformalWeight", "[", 
  RowBox[{"k", "[", 
   RowBox[{"-", "\[Mu]"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ConformalWeight", "[", 
  RowBox[{"k", "[", "\[Mu]", "]"}], "]"}]}], "Input",
 CellLabel->"In[22]:=",ExpressionUUID->"c28adb5e-25f2-4596-b43f-bffb98a8222a"],

Cell[BoxData["0"], "Output",
 CellLabel->"Out[23]=",ExpressionUUID->"1df284f8-fa61-440d-8698-6f53fbe00f5a"],

Cell[BoxData[
 RowBox[{"-", "2"}]], "Output",
 CellLabel->
  "Out[24]=",ExpressionUUID->"239cbdb4-9d6a-4d37-9e7f-a7a57e13e693"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Conformally transformed tensors", \
"Subsubsection",ExpressionUUID->"add61510-727f-4d1c-923f-55e3a482ff3a"],

Cell["\<\
Any tensor defined on the manifold of the base metric is considered to be in \
the conformal frame of that metric.
If we actively transform it (Weyl rescaling of metric and fields), then this \
is noted by an inert head notation as\
\>", "Text",ExpressionUUID->"ca05fa9b-a52f-4589-a9eb-30f56b5dfbae"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "ConformalFrame"}]], "Input",
 CellLabel->"In[25]:=",ExpressionUUID->"826e352c-d689-446c-886e-63ad8ffefcfa"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Formal scalar head ConformalFrame[metric][expr] \
which indicates that expr (which must be of the form tens[inds]) is in fact \
the transformation of that quantity from the ambient frame to the frame \
associated with metric. Hence if metric is the first metric \
ConformalFrame[firstmetric][expr] = expr. \"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[
           TagBox[GridBox[{
              {
               StyleBox[
                TagBox[
                 TooltipBox[
                  
                  StyleBox["\<\" UpValue Definitions\"\>", 
                   "InformationRowLabel",
                   StripOnInput->False],
                  "\"UpValues\"",
                  TooltipStyle->"TextStyling"],
                 Annotation[#, "UpValues", "Tooltip"]& ], "DialogStyle",
                StripOnInput->False]},
              {
               TemplateBox[{"\"\[ThinSpace]\"", 
                 GridBox[{{
                    RowBox[{"ConformalFrame", "/:", 
                    RowBox[{"ContractThroughQ", "[", 
                    RowBox[{
                    RowBox[{"ConformalFrame", "[", "g", "]"}], ",", "delta"}],
                     "]"}], "=", "True"}]}, {" "}, {
                    RowBox[{"ConformalFrame", "/:", 
                    RowBox[{"ContractThroughQ", "[", 
                    RowBox[{
                    RowBox[{"ConformalFrame", "[", "gs2", "]"}], ",", 
                    "delta"}], "]"}], "=", "True"}]}, {" "}, {
                    RowBox[{"ConformalFrame", "/:", 
                    RowBox[{"ContractThroughQ", "[", 
                    RowBox[{
                    RowBox[{"ConformalFrame", "[", "gS2", "]"}], ",", 
                    "delta"}], "]"}], "=", "True"}]}, {" "}, {
                    RowBox[{
                    RowBox[{"DefInfo", "[", 
                    RowBox[{"ConformalFrame", "[", "g", "]"}], "]"}], "^=", 
                    RowBox[{"{", 
                    RowBox[{"\"inert head\"", ",", "\"\""}], "}"}]}]}, {" "}, {
                    RowBox[{
                    RowBox[{"DefInfo", "[", 
                    RowBox[{"ConformalFrame", "[", "gs2", "]"}], "]"}], "^=", 
                    
                    RowBox[{"{", 
                    RowBox[{"\"inert head\"", ",", "\"\""}], "}"}]}]}, {" "}, {
                    RowBox[{
                    RowBox[{"DefInfo", "[", 
                    RowBox[{"ConformalFrame", "[", "gS2", "]"}], "]"}], "^=", 
                    
                    RowBox[{"{", 
                    RowBox[{"\"inert head\"", ",", "\"\""}], "}"}]}]}, {" "}, {
                    RowBox[{
                    RowBox[{"InertHeadQ", "[", 
                    RowBox[{"ConformalFrame", "[", "g", "]"}], "]"}], "^=", 
                    "True"}]}, {" "}, {
                    RowBox[{
                    RowBox[{"InertHeadQ", "[", 
                    RowBox[{"ConformalFrame", "[", "gs2", "]"}], "]"}], "^=", 
                    "True"}]}, {" "}, {
                    RowBox[{
                    RowBox[{"InertHeadQ", "[", 
                    RowBox[{"ConformalFrame", "[", "gS2", "]"}], "]"}], "^=", 
                    "True"}]}, {" "}, {
                    RowBox[{
                    RowBox[{"LinearQ", "[", 
                    RowBox[{"ConformalFrame", "[", "g", "]"}], "]"}], "^=", 
                    "False"}]}, {" "}, {
                    RowBox[{
                    RowBox[{"LinearQ", "[", 
                    RowBox[{"ConformalFrame", "[", "gs2", "]"}], "]"}], "^=", 
                    "False"}]}, {" "}, {
                    RowBox[{
                    RowBox[{"LinearQ", "[", 
                    RowBox[{"ConformalFrame", "[", "gS2", "]"}], "]"}], "^=", 
                    "False"}]}, {" "}, {
                    RowBox[{
                    RowBox[{"PrintAs", "[", 
                    RowBox[{"ConformalFrame", "[", "g", "]"}], "]"}], "^=", 
                    "\"ConformalFrame[g]\""}]}, {" "}, {
                    RowBox[{
                    RowBox[{"PrintAs", "[", 
                    RowBox[{"ConformalFrame", "[", "gs2", "]"}], "]"}], "^=", 
                    "\"ConformalFrame[gs2]\""}]}, {" "}, {
                    RowBox[{
                    RowBox[{"PrintAs", "[", 
                    RowBox[{"ConformalFrame", "[", "gS2", "]"}], "]"}], "^=", 
                    "\"ConformalFrame[gS2]\""}]}, {" "}}, 
                  GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                  DefaultBaseStyle -> "Column", 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                "RowDefault"]},
              {
               StyleBox[
                TagBox[
                 TooltipBox[
                  
                  StyleBox["\<\" SubValue Definitions\"\>", 
                   "InformationRowLabel",
                   StripOnInput->False],
                  "\"SubValues\"",
                  TooltipStyle->"TextStyling"],
                 Annotation[#, "SubValues", "Tooltip"]& ], "DialogStyle",
                StripOnInput->False]},
              {
               TemplateBox[{"\"\[ThinSpace]\"", 
                 GridBox[{{
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> GrayLevel[0]], 
                    InterpretationBox[
                    StyleBox[
                    "\!\([g\!\(s\^2\)]\&\*StyleBox[\"~\",FontColor->RGBColor[\
0, 0, 0]]\&\*StyleBox[\"~\",FontColor->RGBColor[0, 0, 0]]\)", AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    $CellContext`Detgs2[], Editable -> False], 
                    StyleBox["]", FontColor -> GrayLevel[0]]}], AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`g][
                    $CellContext`Detgs2[]], Editable -> False], ":=", 
                    InterpretationBox[
                    StyleBox[
                    "\!\(g\&\*StyleBox[\"~\",FontColor->RGBColor[0, 0, \
0]]\&\*StyleBox[\"~\",FontColor->RGBColor[0, 0, 0]]\)", AutoSpacing -> False, 
                    ShowAutoStyles -> False], 
                    $CellContext`Detg[], Editable -> False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> GrayLevel[0]], 
                    InterpretationBox[
                    StyleBox[
                    "\!\([g\!\(S\^2\)]\&\*StyleBox[\"~\",FontColor->RGBColor[\
0, 0, 0]]\&\*StyleBox[\"~\",FontColor->RGBColor[0, 0, 0]]\)", AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    $CellContext`DetgS2[], Editable -> False], 
                    StyleBox["]", FontColor -> GrayLevel[0]]}], AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`g][
                    $CellContext`DetgS2[]], Editable -> False], ":=", 
                    InterpretationBox[
                    StyleBox[
                    "\!\(g\&\*StyleBox[\"~\",FontColor->RGBColor[0, 0, \
0]]\&\*StyleBox[\"~\",FontColor->RGBColor[0, 0, 0]]\)", AutoSpacing -> False, 
                    ShowAutoStyles -> False], 
                    $CellContext`Detg[], Editable -> False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> GrayLevel[0]], 
                    InterpretationBox[
                    StyleBox[
                    "R[\[Del]gs2]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`RicciScalarCDgs2[], Editable -> False], 
                    StyleBox["]", FontColor -> GrayLevel[0]]}], AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`g][
                    $CellContext`RicciScalarCDgs2[]], Editable -> False], 
                    ":=", 
                    InterpretationBox[
                    StyleBox[
                    "R[\[Del]]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`RicciScalarCD[], Editable -> False]}]}, {
                   " "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> GrayLevel[0]], 
                    InterpretationBox[
                    StyleBox[
                    "R[\[Del]gS2]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`RicciScalarCDgS2[], Editable -> False], 
                    StyleBox["]", FontColor -> GrayLevel[0]]}], AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`g][
                    $CellContext`RicciScalarCDgS2[]], Editable -> False], 
                    ":=", 
                    InterpretationBox[
                    StyleBox[
                    "R[\[Del]]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`RicciScalarCD[], Editable -> False]}]}, {
                   " "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[0, 0, 1]], 
                    InterpretationBox[
                    StyleBox[
                    "\!\(g\&\*StyleBox[\"~\",FontColor->RGBColor[0, 0, \
0]]\&\*StyleBox[\"~\",FontColor->RGBColor[0, 0, 0]]\)", AutoSpacing -> False, 
                    ShowAutoStyles -> False], 
                    $CellContext`Detg[], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gs2][
                    $CellContext`Detg[]], Editable -> False], ":=", 
                    InterpretationBox[
                    StyleBox[
                    "\!\([g\!\(s\^2\)]\&\*StyleBox[\"~\",FontColor->RGBColor[\
0, 0, 0]]\&\*StyleBox[\"~\",FontColor->RGBColor[0, 0, 0]]\)", AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    $CellContext`Detgs2[], Editable -> False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[0, 0, 1]], 
                    InterpretationBox[
                    StyleBox[
                    "\!\([g\!\(S\^2\)]\&\*StyleBox[\"~\",FontColor->RGBColor[\
0, 0, 0]]\&\*StyleBox[\"~\",FontColor->RGBColor[0, 0, 0]]\)", AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    $CellContext`DetgS2[], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gs2][
                    $CellContext`DetgS2[]], Editable -> False], ":=", 
                    InterpretationBox[
                    StyleBox[
                    "\!\([g\!\(s\^2\)]\&\*StyleBox[\"~\",FontColor->RGBColor[\
0, 0, 0]]\&\*StyleBox[\"~\",FontColor->RGBColor[0, 0, 0]]\)", AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    $CellContext`Detgs2[], Editable -> False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[0, 0, 1]], 
                    InterpretationBox[
                    StyleBox[
                    "R[\[Del]]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`RicciScalarCD[], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gs2][
                    $CellContext`RicciScalarCD[]], Editable -> False], ":=", 
                    InterpretationBox[
                    StyleBox[
                    "R[\[Del]gs2]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`RicciScalarCDgs2[], Editable -> False]}]}, {
                   " "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[0, 0, 1]], 
                    InterpretationBox[
                    StyleBox[
                    "R[\[Del]gS2]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`RicciScalarCDgS2[], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gs2][
                    $CellContext`RicciScalarCDgS2[]], Editable -> False], 
                    ":=", 
                    InterpretationBox[
                    StyleBox[
                    "R[\[Del]gs2]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`RicciScalarCDgs2[], Editable -> False]}]}, {
                   " "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[1, 0, 0]], 
                    InterpretationBox[
                    StyleBox[
                    "\!\(g\&\*StyleBox[\"~\",FontColor->RGBColor[0, 0, \
0]]\&\*StyleBox[\"~\",FontColor->RGBColor[0, 0, 0]]\)", AutoSpacing -> False, 
                    ShowAutoStyles -> False], 
                    $CellContext`Detg[], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[1, 0, 0]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gS2][
                    $CellContext`Detg[]], Editable -> False], ":=", 
                    InterpretationBox[
                    StyleBox[
                    "\!\([g\!\(S\^2\)]\&\*StyleBox[\"~\",FontColor->RGBColor[\
0, 0, 0]]\&\*StyleBox[\"~\",FontColor->RGBColor[0, 0, 0]]\)", AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    $CellContext`DetgS2[], Editable -> False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[1, 0, 0]], 
                    InterpretationBox[
                    StyleBox[
                    "\!\([g\!\(s\^2\)]\&\*StyleBox[\"~\",FontColor->RGBColor[\
0, 0, 0]]\&\*StyleBox[\"~\",FontColor->RGBColor[0, 0, 0]]\)", AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    $CellContext`Detgs2[], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[1, 0, 0]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gS2][
                    $CellContext`Detgs2[]], Editable -> False], ":=", 
                    InterpretationBox[
                    StyleBox[
                    "\!\([g\!\(S\^2\)]\&\*StyleBox[\"~\",FontColor->RGBColor[\
0, 0, 0]]\&\*StyleBox[\"~\",FontColor->RGBColor[0, 0, 0]]\)", AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    $CellContext`DetgS2[], Editable -> False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[1, 0, 0]], 
                    InterpretationBox[
                    StyleBox[
                    "R[\[Del]]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`RicciScalarCD[], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[1, 0, 0]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gS2][
                    $CellContext`RicciScalarCD[]], Editable -> False], ":=", 
                    InterpretationBox[
                    StyleBox[
                    "R[\[Del]gS2]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`RicciScalarCDgS2[], Editable -> False]}]}, {
                   " "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[1, 0, 0]], 
                    InterpretationBox[
                    StyleBox[
                    "R[\[Del]gs2]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`RicciScalarCDgs2[], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[1, 0, 0]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gS2][
                    $CellContext`RicciScalarCDgs2[]], Editable -> False], 
                    ":=", 
                    InterpretationBox[
                    StyleBox[
                    "R[\[Del]gS2]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`RicciScalarCDgS2[], Editable -> False]}]}, {
                   " "}, {
                    RowBox[{
                    RowBox[{
                    RowBox[{"ConformalFrame", "[", "_", "]"}], "[", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"\[Delta]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(xAct`xConf`Private`\[Mu]\+_\)", 
                    "\!\(xAct`xConf`Private`\[Nu]\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xTensor`delta[
                    Pattern[xAct`xConf`Private`\[Mu], 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`\[Nu], 
                    Blank[]]], Editable -> False], "]"}], ":=", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"\[Delta]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`\[Mu]", 
                    "xAct`xConf`Private`\[Nu]"}, {" ", " "}}, RowSpacings -> 
                    0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xTensor`delta[
                    xAct`xConf`Private`\[Mu], xAct`xConf`Private`\[Nu]], 
                    Editable -> False]}]}, {" "}, {
                    RowBox[{
                    RowBox[{
                    RowBox[{"ConformalFrame", "[", 
                    RowBox[{"xAct`xConf`Private`g1_", "?", "MetricQ"}], "]"}],
                     "[", 
                    RowBox[{"xAct`xConf`Private`val_", "?", "NumberQ"}], 
                    "]"}], ":=", "xAct`xConf`Private`val"}]}, {" "}, {
                    RowBox[{
                    RowBox[{
                    RowBox[{"ConformalFrame", "[", 
                    RowBox[{"xAct`xConf`Private`g1_", "?", "MetricQ"}], "]"}],
                     "[", 
                    
                    RowBox[{
                    "xAct`xConf`Private`val_", "?", "ConstantSymbolQ"}], 
                    "]"}], ":=", "xAct`xConf`Private`val"}]}, {" "}, {
                    RowBox[{
                    RowBox[{
                    RowBox[{"ConformalFrame", "[", 
                    RowBox[{"xAct`xConf`Private`g1_", "?", "MetricQ"}], "]"}],
                     "[", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"xAct`xConf`Private`S_", "?", "ScalarQ"}], ")"}], 
                    "xAct`xConf`Private`n_"], "]"}], ":=", 
                    SuperscriptBox[
                    RowBox[{
                    
                    RowBox[{
                    "ConformalFrame", "[", "xAct`xConf`Private`g1", "]"}], 
                    "[", "xAct`xConf`Private`S", "]"}], 
                    "xAct`xConf`Private`n"]}]}, {" "}, {
                    RowBox[{
                    RowBox[{
                    RowBox[{"ConformalFrame", "[", 
                    RowBox[{"xAct`xConf`Private`g1_", "?", "MetricQ"}], "]"}],
                     "[", "xAct`xConf`Private`product_Times", "]"}], ":=", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"ConformalFrame", "[", "xAct`xConf`Private`g1", 
                    "]"}], "[", "#1", "]"}], "&"}], ")"}], "/@", 
                    "xAct`xConf`Private`product"}]}]}, {" "}, {
                    RowBox[{
                    RowBox[{
                    RowBox[{"ConformalFrame", "[", 
                    RowBox[{"xAct`xConf`Private`g1_", "?", "MetricQ"}], "]"}],
                     "[", "xAct`xConf`Private`sum_Plus", "]"}], ":=", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"ConformalFrame", "[", "xAct`xConf`Private`g1", 
                    "]"}], "[", "#1", "]"}], "&"}], ")"}], "/@", 
                    "xAct`xConf`Private`sum"}]}]}, {" "}, {
                    RowBox[{
                    RowBox[{
                    RowBox[{"ConformalFrame", "[", 
                    RowBox[{"xAct`xConf`Private`g1_", "?", "MetricQ"}], "]"}],
                     "[", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["(", FontColor -> RGBColor[1, 0, 0]], 
                    "xAct`xConf`Private`expr_", 
                    StyleBox[")", FontColor -> RGBColor[1, 0, 0]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xTensor`Scalar[
                    Pattern[xAct`xConf`Private`expr, 
                    Blank[]]], Editable -> False], "]"}], ":=", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["(", FontColor -> RGBColor[1, 0, 0]], 
                    RowBox[{
                    
                    RowBox[{"ConformalFrame", "[", "xAct`xConf`Private`g1", 
                    "]"}], "[", "xAct`xConf`Private`expr", "]"}], 
                    StyleBox[")", FontColor -> RGBColor[1, 0, 0]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xTensor`Scalar[
                    xAct`xConf`ConformalFrame[xAct`xConf`Private`g1][
                    xAct`xConf`Private`expr]], Editable -> False]}]}, {" "}, {
                   
                    RowBox[{
                    RowBox[{
                    RowBox[{"ConformalFrame", "[", 
                    RowBox[{"xAct`xConf`Private`g1_", "?", "MetricQ"}], "]"}],
                     "[", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`f_", "?", "ScalarFunctionQ"}],
                     "[", "xAct`xConf`Private`expr_", "]"}], "]"}], ":=", 
                    RowBox[{"xAct`xConf`Private`f", "[", 
                    RowBox[{
                    
                    RowBox[{
                    "ConformalFrame", "[", "xAct`xConf`Private`g1", "]"}], 
                    "[", "xAct`xConf`Private`expr", "]"}], "]"}]}]}, {" "}, {
                    RowBox[{
                    RowBox[{
                    RowBox[{"ConformalFrame", "[", 
                    RowBox[{"xAct`xConf`Private`g1_", "?", "MetricQ"}], "]"}],
                     "[", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`S_", "?", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ScalarQ", "[", "#1", "]"}], "&&", 
                    RowBox[{
                    RowBox[{"ConformalWeight", "[", "#1", "]"}], "===", 
                    "0"}]}], "&"}], ")"}]}], "[", "]"}], "]"}], ":=", 
                    RowBox[{"xAct`xConf`Private`S", "[", "]"}]}]}, {" "}, {
                    RowBox[{
                    RowBox[{
                    RowBox[{"ConformalFrame", "[", 
                    RowBox[{"xAct`xConf`Private`g1_", "?", "MetricQ"}], "]"}],
                     "[", 
                    RowBox[{
                    RowBox[{"ConformalFrame", "[", 
                    RowBox[{"xAct`xConf`Private`g2_", "?", "MetricQ"}], "]"}],
                     "[", "xAct`xConf`Private`expr_", "]"}], "]"}], ":=", 
                    RowBox[{
                    
                    RowBox[{
                    "ConformalFrame", "[", "xAct`xConf`Private`g1", "]"}], 
                    "[", "xAct`xConf`Private`expr", "]"}]}]}, {" "}, {
                    RowBox[{
                    RowBox[{
                    RowBox[{"ConformalFrame", "[", "_", "]"}], "[", 
                    InterpretationBox[
                    StyleBox[
                    "S", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`S[], Editable -> False], "]"}], ":=", 
                    InterpretationBox[
                    StyleBox[
                    "S", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`S[], Editable -> False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[1, 0, 0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"g", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`i1$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i2$\+_\)\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`g[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[1, 0, 0]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gS2][
                    $CellContext`g[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ]]], Editable -> False], 
                    ":=", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"[g\!\(S\^2\)]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$"}, {" ", " "}}, RowSpacings -> 0, 
                    ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`gS2[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], Editable -> 
                    False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[1, 0, 0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"g", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`i1$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i2$\+_\)\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`g[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`UpIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`UpIndexQ]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[1, 0, 0]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gS2][
                    $CellContext`g[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`UpIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`UpIndexQ]]], Editable -> False], 
                    ":=", 
                    RowBox[{
                    RowBox[{"Inv", "[", "gS2", "]"}], "[", 
                    
                    RowBox[{
                    "xAct`xConf`Private`i1$", ",", "xAct`xConf`Private`i2$"}],
                     "]"}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[1, 0, 0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`i1$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i2$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i3$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i4$\+_\)\+_\)"}, {
                    " ", " ", " ", " "}}, RowSpacings -> 0, ColumnSpacings -> 
                    0.05, GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RiemannCD[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i3$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i4$, 
                    Blank[]], xAct`xTensor`UpIndexQ]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[1, 0, 0]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gS2][
                    $CellContext`RiemannCD[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i3$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i4$, 
                    Blank[]], xAct`xTensor`UpIndexQ]]], Editable -> False], 
                    ":=", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gS2]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$", "xAct`xConf`Private`i3$", 
                    "xAct`xConf`Private`i4$"}, {" ", " ", " ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RiemannCDgS2[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
                    xAct`xConf`Private`i3$, xAct`xConf`Private`i4$], Editable -> 
                    False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[1, 0, 0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(xAct`xConf`Private`i1$\+_\)", 
                    "\!\(xAct`xConf`Private`i2$\+_\)", 
                    "\!\(xAct`xConf`Private`i3$\+_\)", 
                    "\!\(xAct`xConf`Private`i4$\+_\)"}, {" ", " ", " ", " "}},
                     RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RiemannCD[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i3$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i4$, 
                    Blank[]]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[1, 0, 0]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gS2][
                    $CellContext`RiemannCD[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i3$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i4$, 
                    Blank[]]]], Editable -> False], ":=", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "S", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`S[], Editable -> False], 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`WeightOfIndicesList", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"xAct`xConf`Private`i1$", ",", 
                    "xAct`xConf`Private`i2$", ",", "xAct`xConf`Private`i3$", 
                    ",", "xAct`xConf`Private`i4$"}], "}"}], "]"}], "-", 
                    "2"}]], " ", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gS2]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$", "xAct`xConf`Private`i3$", 
                    "xAct`xConf`Private`i4$"}, {" ", " ", " ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RiemannCDgS2[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
                    xAct`xConf`Private`i3$, xAct`xConf`Private`i4$], Editable -> 
                    False]}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[1, 0, 0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`i1$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i2$\+_\)\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RicciCD[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[1, 0, 0]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gS2][
                    $CellContext`RicciCD[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ]]], Editable -> False], 
                    ":=", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gS2]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$"}, {" ", " "}}, RowSpacings -> 0, 
                    ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RicciCDgS2[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], Editable -> 
                    False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[1, 0, 0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(xAct`xConf`Private`i1$\+_\)", 
                    "\!\(xAct`xConf`Private`i2$\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RicciCD[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[1, 0, 0]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gS2][
                    $CellContext`RicciCD[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]]]], Editable -> False], ":=", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "S", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`S[], Editable -> False], 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`WeightOfIndicesList", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"xAct`xConf`Private`i1$", ",", 
                    "xAct`xConf`Private`i2$"}], "}"}], "]"}], "-", "2"}]], 
                    " ", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gS2]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$"}, {" ", " "}}, RowSpacings -> 0, 
                    ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RicciCDgS2[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], Editable -> 
                    False]}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"ConformalFrame[gS2]", "[", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    SuperscriptBox[
                    "\[Del]", "\!\(xAct`xConf`Private`i1$\+_\)"], 
                    "xAct`xConf`Private`ex$_"}], AutoSpacing -> False, 
                    ShowAutoStyles -> False], 
                    $CellContext`CD[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]]][
                    Pattern[xAct`xConf`Private`ex$, 
                    Blank[]]], Editable -> False], "]"}], AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gS2][
                    $CellContext`CD[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]]][
                    Pattern[xAct`xConf`Private`ex$, 
                    Blank[]]]], Editable -> False], ":=", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "S", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`S[], Editable -> False], 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`WeightOfIndicesList", "[", 
                    RowBox[{"{", "xAct`xConf`Private`i1$", "}"}], "]"}], "-", 
                    "1"}]], " ", 
                    RowBox[{"(", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    SuperscriptBox["\[Del]gS2", "xAct`xConf`Private`i1$"], 
                    "ConformalFrame[gS2]", "[", "xAct`xConf`Private`ex$", 
                    "]"}], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`CDgS2[xAct`xConf`Private`i1$][
                    xAct`xConf`ConformalFrame[$CellContext`gS2][
                    xAct`xConf`Private`ex$]], Editable -> False], 
                    ")"}]}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[1, 0, 0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"\[Epsilon]g", 
                    StyleBox[
                    
                    GridBox[{{"\!\(xAct`xConf`Private`inds$\+_\)"}, {" "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`epsilong[
                    Pattern[xAct`xConf`Private`inds$, 
                    BlankSequence[]]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[1, 0, 0]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gS2][
                    $CellContext`epsilong[
                    Pattern[xAct`xConf`Private`inds$, 
                    BlankSequence[]]]], Editable -> False], ":=", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "S", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`S[], Editable -> False], 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`WeightOfIndicesList", "[", 
                    RowBox[{"{", "xAct`xConf`Private`inds$", "}"}], "]"}], 
                    "-", 
                    RowBox[{"Length", "[", 
                    RowBox[{"{", "xAct`xConf`Private`inds$", "}"}], "]"}]}]], 
                    " ", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"\[Epsilon][g\!\(S\^2\)]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`inds$"}, {" "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`epsilongS2[xAct`xConf`Private`inds$], 
                    Editable -> False]}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> GrayLevel[0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"[g\!\(S\^2\)]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`i1$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i2$\+_\)\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`gS2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ]], Editable -> False], 
                    StyleBox["]", FontColor -> GrayLevel[0]]}], AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`g][
                    $CellContext`gS2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ]]], Editable -> False], 
                    ":=", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"g", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$"}, {" ", " "}}, RowSpacings -> 0, 
                    ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`g[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], Editable -> 
                    False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> GrayLevel[0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"i[g\!\(S\^2\)]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`i1$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i2$\+_\)\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`InvgS2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`UpIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`UpIndexQ]], Editable -> False], 
                    StyleBox["]", FontColor -> GrayLevel[0]]}], AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`g][
                    $CellContext`InvgS2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`UpIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`UpIndexQ]]], Editable -> False], 
                    ":=", 
                    RowBox[{
                    RowBox[{"Inv", "[", "g", "]"}], "[", 
                    
                    RowBox[{
                    "xAct`xConf`Private`i1$", ",", "xAct`xConf`Private`i2$"}],
                     "]"}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> GrayLevel[0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gS2]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`i1$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i2$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i3$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i4$\+_\)\+_\)"}, {
                    " ", " ", " ", " "}}, RowSpacings -> 0, ColumnSpacings -> 
                    0.05, GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RiemannCDgS2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i3$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i4$, 
                    Blank[]], xAct`xTensor`UpIndexQ]], Editable -> False], 
                    StyleBox["]", FontColor -> GrayLevel[0]]}], AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`g][
                    $CellContext`RiemannCDgS2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i3$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i4$, 
                    Blank[]], xAct`xTensor`UpIndexQ]]], Editable -> False], 
                    ":=", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$", "xAct`xConf`Private`i3$", 
                    "xAct`xConf`Private`i4$"}, {" ", " ", " ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RiemannCD[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
                    xAct`xConf`Private`i3$, xAct`xConf`Private`i4$], Editable -> 
                    False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> GrayLevel[0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gS2]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(xAct`xConf`Private`i1$\+_\)", 
                    "\!\(xAct`xConf`Private`i2$\+_\)", 
                    "\!\(xAct`xConf`Private`i3$\+_\)", 
                    "\!\(xAct`xConf`Private`i4$\+_\)"}, {" ", " ", " ", " "}},
                     RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RiemannCDgS2[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i3$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i4$, 
                    Blank[]]], Editable -> False], 
                    StyleBox["]", FontColor -> GrayLevel[0]]}], AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`g][
                    $CellContext`RiemannCDgS2[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i3$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i4$, 
                    Blank[]]]], Editable -> False], ":=", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{"(", 
                    FractionBox["1", 
                    InterpretationBox[
                    StyleBox[
                    "S", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`S[], Editable -> False]], ")"}], 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`WeightOfIndicesList", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"xAct`xConf`Private`i1$", ",", 
                    "xAct`xConf`Private`i2$", ",", "xAct`xConf`Private`i3$", 
                    ",", "xAct`xConf`Private`i4$"}], "}"}], "]"}], "-", 
                    "2"}]], " ", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$", "xAct`xConf`Private`i3$", 
                    "xAct`xConf`Private`i4$"}, {" ", " ", " ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RiemannCD[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
                    xAct`xConf`Private`i3$, xAct`xConf`Private`i4$], Editable -> 
                    False]}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> GrayLevel[0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gS2]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`i1$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i2$\+_\)\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RicciCDgS2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ]], Editable -> False], 
                    StyleBox["]", FontColor -> GrayLevel[0]]}], AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`g][
                    $CellContext`RicciCDgS2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ]]], Editable -> False], 
                    ":=", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$"}, {" ", " "}}, RowSpacings -> 0, 
                    ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RicciCD[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], Editable -> 
                    False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> GrayLevel[0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gS2]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(xAct`xConf`Private`i1$\+_\)", 
                    "\!\(xAct`xConf`Private`i2$\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RicciCDgS2[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]]], Editable -> False], 
                    StyleBox["]", FontColor -> GrayLevel[0]]}], AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`g][
                    $CellContext`RicciCDgS2[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]]]], Editable -> False], ":=", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{"(", 
                    FractionBox["1", 
                    InterpretationBox[
                    StyleBox[
                    "S", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`S[], Editable -> False]], ")"}], 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`WeightOfIndicesList", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"xAct`xConf`Private`i1$", ",", 
                    "xAct`xConf`Private`i2$"}], "}"}], "]"}], "-", "2"}]], 
                    " ", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$"}, {" ", " "}}, RowSpacings -> 0, 
                    ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RicciCD[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], Editable -> 
                    False]}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"ConformalFrame[g]", "[", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    SuperscriptBox[
                    "\[Del]gS2", "\!\(xAct`xConf`Private`i1$\+_\)"], 
                    "xAct`xConf`Private`ex$_"}], AutoSpacing -> False, 
                    ShowAutoStyles -> False], 
                    $CellContext`CDgS2[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]]][
                    Pattern[xAct`xConf`Private`ex$, 
                    Blank[]]], Editable -> False], "]"}], AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`g][
                    $CellContext`CDgS2[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]]][
                    Pattern[xAct`xConf`Private`ex$, 
                    Blank[]]]], Editable -> False], ":=", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{"(", 
                    FractionBox["1", 
                    InterpretationBox[
                    StyleBox[
                    "S", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`S[], Editable -> False]], ")"}], 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`WeightOfIndicesList", "[", 
                    RowBox[{"{", "xAct`xConf`Private`i1$", "}"}], "]"}], "-", 
                    "1"}]], " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    SuperscriptBox["\[Del]", "xAct`xConf`Private`i1$"], 
                    "ConformalFrame[g]", "[", "xAct`xConf`Private`ex$", "]"}],
                     AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`CD[xAct`xConf`Private`i1$][
                    xAct`xConf`ConformalFrame[$CellContext`g][
                    xAct`xConf`Private`ex$]], Editable -> False]}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> GrayLevel[0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"\[Epsilon][g\!\(S\^2\)]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(xAct`xConf`Private`inds$\+_\)"}, {" "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`epsilongS2[
                    Pattern[xAct`xConf`Private`inds$, 
                    BlankSequence[]]], Editable -> False], 
                    StyleBox["]", FontColor -> GrayLevel[0]]}], AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`g][
                    $CellContext`epsilongS2[
                    Pattern[xAct`xConf`Private`inds$, 
                    BlankSequence[]]]], Editable -> False], ":=", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{"(", 
                    FractionBox["1", 
                    InterpretationBox[
                    StyleBox["S", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`S[], Editable -> False]], ")"}], 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`WeightOfIndicesList", "[", 
                    RowBox[{"{", "xAct`xConf`Private`inds$", "}"}], "]"}], 
                    "-", 
                    RowBox[{"Length", "[", 
                    RowBox[{"{", "xAct`xConf`Private`inds$", "}"}], "]"}]}]], 
                    " ", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"\[Epsilon]g", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`inds$"}, {" "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`epsilong[xAct`xConf`Private`inds$], Editable -> 
                    False]}]}]}, {" "}, {
                    RowBox[{
                    RowBox[{
                    RowBox[{"ConformalFrame", "[", "_", "]"}], "[", 
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], "]"}], ":=", 
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[0, 0, 1]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"g", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`i1$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i2$\+_\)\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`g[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gs2][
                    $CellContext`g[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ]]], Editable -> False], 
                    ":=", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"[g\!\(s\^2\)]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$"}, {" ", " "}}, RowSpacings -> 0, 
                    ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`gs2[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], Editable -> 
                    False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[0, 0, 1]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"g", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`i1$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i2$\+_\)\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`g[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`UpIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`UpIndexQ]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gs2][
                    $CellContext`g[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`UpIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`UpIndexQ]]], Editable -> False], 
                    ":=", 
                    RowBox[{
                    RowBox[{"Inv", "[", "gs2", "]"}], "[", 
                    
                    RowBox[{
                    "xAct`xConf`Private`i1$", ",", "xAct`xConf`Private`i2$"}],
                     "]"}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[0, 0, 1]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`i1$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i2$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i3$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i4$\+_\)\+_\)"}, {
                    " ", " ", " ", " "}}, RowSpacings -> 0, ColumnSpacings -> 
                    0.05, GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RiemannCD[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i3$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i4$, 
                    Blank[]], xAct`xTensor`UpIndexQ]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gs2][
                    $CellContext`RiemannCD[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i3$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i4$, 
                    Blank[]], xAct`xTensor`UpIndexQ]]], Editable -> False], 
                    ":=", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gs2]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$", "xAct`xConf`Private`i3$", 
                    "xAct`xConf`Private`i4$"}, {" ", " ", " ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RiemannCDgs2[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
                    xAct`xConf`Private`i3$, xAct`xConf`Private`i4$], Editable -> 
                    False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[0, 0, 1]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(xAct`xConf`Private`i1$\+_\)", 
                    "\!\(xAct`xConf`Private`i2$\+_\)", 
                    "\!\(xAct`xConf`Private`i3$\+_\)", 
                    "\!\(xAct`xConf`Private`i4$\+_\)"}, {" ", " ", " ", " "}},
                     RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RiemannCD[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i3$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i4$, 
                    Blank[]]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gs2][
                    $CellContext`RiemannCD[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i3$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i4$, 
                    Blank[]]]], Editable -> False], ":=", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`WeightOfIndicesList", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"xAct`xConf`Private`i1$", ",", 
                    "xAct`xConf`Private`i2$", ",", "xAct`xConf`Private`i3$", 
                    ",", "xAct`xConf`Private`i4$"}], "}"}], "]"}], "-", 
                    "2"}]], " ", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gs2]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$", "xAct`xConf`Private`i3$", 
                    "xAct`xConf`Private`i4$"}, {" ", " ", " ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RiemannCDgs2[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
                    xAct`xConf`Private`i3$, xAct`xConf`Private`i4$], Editable -> 
                    False]}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[0, 0, 1]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`i1$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i2$\+_\)\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RicciCD[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gs2][
                    $CellContext`RicciCD[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ]]], Editable -> False], 
                    ":=", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gs2]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$"}, {" ", " "}}, RowSpacings -> 0, 
                    ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RicciCDgs2[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], Editable -> 
                    False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[0, 0, 1]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(xAct`xConf`Private`i1$\+_\)", 
                    "\!\(xAct`xConf`Private`i2$\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RicciCD[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gs2][
                    $CellContext`RicciCD[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]]]], Editable -> False], ":=", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`WeightOfIndicesList", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"xAct`xConf`Private`i1$", ",", 
                    "xAct`xConf`Private`i2$"}], "}"}], "]"}], "-", "2"}]], 
                    " ", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gs2]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$"}, {" ", " "}}, RowSpacings -> 0, 
                    ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RicciCDgs2[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], Editable -> 
                    False]}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"ConformalFrame[gs2]", "[", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    SuperscriptBox[
                    "\[Del]", "\!\(xAct`xConf`Private`i1$\+_\)"], 
                    "xAct`xConf`Private`ex$_"}], AutoSpacing -> False, 
                    ShowAutoStyles -> False], 
                    $CellContext`CD[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]]][
                    Pattern[xAct`xConf`Private`ex$, 
                    Blank[]]], Editable -> False], "]"}], AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gs2][
                    $CellContext`CD[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]]][
                    Pattern[xAct`xConf`Private`ex$, 
                    Blank[]]]], Editable -> False], ":=", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`WeightOfIndicesList", "[", 
                    RowBox[{"{", "xAct`xConf`Private`i1$", "}"}], "]"}], "-", 
                    "1"}]], " ", 
                    RowBox[{"(", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    SuperscriptBox["\[Del]gs2", "xAct`xConf`Private`i1$"], 
                    "ConformalFrame[gs2]", "[", "xAct`xConf`Private`ex$", 
                    "]"}], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`CDgs2[xAct`xConf`Private`i1$][
                    xAct`xConf`ConformalFrame[$CellContext`gs2][
                    xAct`xConf`Private`ex$]], Editable -> False], 
                    ")"}]}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[0, 0, 1]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"\[Epsilon]g", 
                    StyleBox[
                    
                    GridBox[{{"\!\(xAct`xConf`Private`inds$\+_\)"}, {" "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`epsilong[
                    Pattern[xAct`xConf`Private`inds$, 
                    BlankSequence[]]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gs2][
                    $CellContext`epsilong[
                    Pattern[xAct`xConf`Private`inds$, 
                    BlankSequence[]]]], Editable -> False], ":=", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`WeightOfIndicesList", "[", 
                    RowBox[{"{", "xAct`xConf`Private`inds$", "}"}], "]"}], 
                    "-", 
                    RowBox[{"Length", "[", 
                    RowBox[{"{", "xAct`xConf`Private`inds$", "}"}], "]"}]}]], 
                    " ", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"\[Epsilon][g\!\(s\^2\)]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`inds$"}, {" "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`epsilongs2[xAct`xConf`Private`inds$], 
                    Editable -> False]}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> GrayLevel[0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"[g\!\(s\^2\)]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`i1$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i2$\+_\)\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`gs2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ]], Editable -> False], 
                    StyleBox["]", FontColor -> GrayLevel[0]]}], AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`g][
                    $CellContext`gs2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ]]], Editable -> False], 
                    ":=", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"g", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$"}, {" ", " "}}, RowSpacings -> 0, 
                    ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`g[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], Editable -> 
                    False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> GrayLevel[0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"i[g\!\(s\^2\)]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`i1$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i2$\+_\)\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`Invgs2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`UpIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`UpIndexQ]], Editable -> False], 
                    StyleBox["]", FontColor -> GrayLevel[0]]}], AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`g][
                    $CellContext`Invgs2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`UpIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`UpIndexQ]]], Editable -> False], 
                    ":=", 
                    RowBox[{
                    RowBox[{"Inv", "[", "g", "]"}], "[", 
                    
                    RowBox[{
                    "xAct`xConf`Private`i1$", ",", "xAct`xConf`Private`i2$"}],
                     "]"}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> GrayLevel[0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gs2]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`i1$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i2$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i3$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i4$\+_\)\+_\)"}, {
                    " ", " ", " ", " "}}, RowSpacings -> 0, ColumnSpacings -> 
                    0.05, GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RiemannCDgs2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i3$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i4$, 
                    Blank[]], xAct`xTensor`UpIndexQ]], Editable -> False], 
                    StyleBox["]", FontColor -> GrayLevel[0]]}], AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`g][
                    $CellContext`RiemannCDgs2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i3$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i4$, 
                    Blank[]], xAct`xTensor`UpIndexQ]]], Editable -> False], 
                    ":=", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$", "xAct`xConf`Private`i3$", 
                    "xAct`xConf`Private`i4$"}, {" ", " ", " ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RiemannCD[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
                    xAct`xConf`Private`i3$, xAct`xConf`Private`i4$], Editable -> 
                    False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> GrayLevel[0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gs2]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(xAct`xConf`Private`i1$\+_\)", 
                    "\!\(xAct`xConf`Private`i2$\+_\)", 
                    "\!\(xAct`xConf`Private`i3$\+_\)", 
                    "\!\(xAct`xConf`Private`i4$\+_\)"}, {" ", " ", " ", " "}},
                     RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RiemannCDgs2[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i3$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i4$, 
                    Blank[]]], Editable -> False], 
                    StyleBox["]", FontColor -> GrayLevel[0]]}], AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`g][
                    $CellContext`RiemannCDgs2[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i3$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i4$, 
                    Blank[]]]], Editable -> False], ":=", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{"(", 
                    FractionBox["1", 
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False]], ")"}], 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`WeightOfIndicesList", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"xAct`xConf`Private`i1$", ",", 
                    "xAct`xConf`Private`i2$", ",", "xAct`xConf`Private`i3$", 
                    ",", "xAct`xConf`Private`i4$"}], "}"}], "]"}], "-", 
                    "2"}]], " ", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$", "xAct`xConf`Private`i3$", 
                    "xAct`xConf`Private`i4$"}, {" ", " ", " ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RiemannCD[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
                    xAct`xConf`Private`i3$, xAct`xConf`Private`i4$], Editable -> 
                    False]}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> GrayLevel[0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gs2]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`i1$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i2$\+_\)\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RicciCDgs2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ]], Editable -> False], 
                    StyleBox["]", FontColor -> GrayLevel[0]]}], AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`g][
                    $CellContext`RicciCDgs2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ]]], Editable -> False], 
                    ":=", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$"}, {" ", " "}}, RowSpacings -> 0, 
                    ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RicciCD[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], Editable -> 
                    False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> GrayLevel[0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gs2]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(xAct`xConf`Private`i1$\+_\)", 
                    "\!\(xAct`xConf`Private`i2$\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RicciCDgs2[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]]], Editable -> False], 
                    StyleBox["]", FontColor -> GrayLevel[0]]}], AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`g][
                    $CellContext`RicciCDgs2[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]]]], Editable -> False], ":=", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{"(", 
                    FractionBox["1", 
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False]], ")"}], 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`WeightOfIndicesList", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"xAct`xConf`Private`i1$", ",", 
                    "xAct`xConf`Private`i2$"}], "}"}], "]"}], "-", "2"}]], 
                    " ", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$"}, {" ", " "}}, RowSpacings -> 0, 
                    ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RicciCD[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], Editable -> 
                    False]}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"ConformalFrame[g]", "[", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    SuperscriptBox[
                    "\[Del]gs2", "\!\(xAct`xConf`Private`i1$\+_\)"], 
                    "xAct`xConf`Private`ex$_"}], AutoSpacing -> False, 
                    ShowAutoStyles -> False], 
                    $CellContext`CDgs2[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]]][
                    Pattern[xAct`xConf`Private`ex$, 
                    Blank[]]], Editable -> False], "]"}], AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`g][
                    $CellContext`CDgs2[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]]][
                    Pattern[xAct`xConf`Private`ex$, 
                    Blank[]]]], Editable -> False], ":=", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{"(", 
                    FractionBox["1", 
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False]], ")"}], 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`WeightOfIndicesList", "[", 
                    RowBox[{"{", "xAct`xConf`Private`i1$", "}"}], "]"}], "-", 
                    "1"}]], " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    SuperscriptBox["\[Del]", "xAct`xConf`Private`i1$"], 
                    "ConformalFrame[g]", "[", "xAct`xConf`Private`ex$", "]"}],
                     AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`CD[xAct`xConf`Private`i1$][
                    xAct`xConf`ConformalFrame[$CellContext`g][
                    xAct`xConf`Private`ex$]], Editable -> False]}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> GrayLevel[0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"\[Epsilon][g\!\(s\^2\)]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(xAct`xConf`Private`inds$\+_\)"}, {" "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`epsilongs2[
                    Pattern[xAct`xConf`Private`inds$, 
                    BlankSequence[]]], Editable -> False], 
                    StyleBox["]", FontColor -> GrayLevel[0]]}], AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`g][
                    $CellContext`epsilongs2[
                    Pattern[xAct`xConf`Private`inds$, 
                    BlankSequence[]]]], Editable -> False], ":=", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{"(", 
                    FractionBox["1", 
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False]], ")"}], 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`WeightOfIndicesList", "[", 
                    RowBox[{"{", "xAct`xConf`Private`inds$", "}"}], "]"}], 
                    "-", 
                    RowBox[{"Length", "[", 
                    RowBox[{"{", "xAct`xConf`Private`inds$", "}"}], "]"}]}]], 
                    " ", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"\[Epsilon]g", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`inds$"}, {" "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`epsilong[xAct`xConf`Private`inds$], Editable -> 
                    False]}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[0, 0, 1]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"[g\!\(S\^2\)]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`i1$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i2$\+_\)\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`gS2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gs2][
                    $CellContext`gS2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ]]], Editable -> False], 
                    ":=", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"[g\!\(s\^2\)]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$"}, {" ", " "}}, RowSpacings -> 0, 
                    ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`gs2[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], Editable -> 
                    False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[0, 0, 1]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"i[g\!\(S\^2\)]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`i1$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i2$\+_\)\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`InvgS2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`UpIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`UpIndexQ]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gs2][
                    $CellContext`InvgS2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`UpIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`UpIndexQ]]], Editable -> False], 
                    ":=", 
                    RowBox[{
                    RowBox[{"Inv", "[", "gs2", "]"}], "[", 
                    
                    RowBox[{
                    "xAct`xConf`Private`i1$", ",", "xAct`xConf`Private`i2$"}],
                     "]"}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[0, 0, 1]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gS2]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`i1$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i2$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i3$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i4$\+_\)\+_\)"}, {
                    " ", " ", " ", " "}}, RowSpacings -> 0, ColumnSpacings -> 
                    0.05, GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RiemannCDgS2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i3$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i4$, 
                    Blank[]], xAct`xTensor`UpIndexQ]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gs2][
                    $CellContext`RiemannCDgS2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i3$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i4$, 
                    Blank[]], xAct`xTensor`UpIndexQ]]], Editable -> False], 
                    ":=", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gs2]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$", "xAct`xConf`Private`i3$", 
                    "xAct`xConf`Private`i4$"}, {" ", " ", " ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RiemannCDgs2[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
                    xAct`xConf`Private`i3$, xAct`xConf`Private`i4$], Editable -> 
                    False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[0, 0, 1]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gS2]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(xAct`xConf`Private`i1$\+_\)", 
                    "\!\(xAct`xConf`Private`i2$\+_\)", 
                    "\!\(xAct`xConf`Private`i3$\+_\)", 
                    "\!\(xAct`xConf`Private`i4$\+_\)"}, {" ", " ", " ", " "}},
                     RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RiemannCDgS2[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i3$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i4$, 
                    Blank[]]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gs2][
                    $CellContext`RiemannCDgS2[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i3$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i4$, 
                    Blank[]]]], Editable -> False], ":=", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{"(", 
                    FractionBox[
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], 
                    InterpretationBox[
                    StyleBox[
                    "S", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`S[], Editable -> False]], ")"}], 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`WeightOfIndicesList", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"xAct`xConf`Private`i1$", ",", 
                    "xAct`xConf`Private`i2$", ",", "xAct`xConf`Private`i3$", 
                    ",", "xAct`xConf`Private`i4$"}], "}"}], "]"}], "-", 
                    "2"}]], " ", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gs2]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$", "xAct`xConf`Private`i3$", 
                    "xAct`xConf`Private`i4$"}, {" ", " ", " ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RiemannCDgs2[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
                    xAct`xConf`Private`i3$, xAct`xConf`Private`i4$], Editable -> 
                    False]}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[0, 0, 1]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gS2]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`i1$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i2$\+_\)\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RicciCDgS2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gs2][
                    $CellContext`RicciCDgS2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ]]], Editable -> False], 
                    ":=", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gs2]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$"}, {" ", " "}}, RowSpacings -> 0, 
                    ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RicciCDgs2[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], Editable -> 
                    False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[0, 0, 1]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gS2]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(xAct`xConf`Private`i1$\+_\)", 
                    "\!\(xAct`xConf`Private`i2$\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RicciCDgS2[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gs2][
                    $CellContext`RicciCDgS2[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]]]], Editable -> False], ":=", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{"(", 
                    FractionBox[
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], 
                    InterpretationBox[
                    StyleBox[
                    "S", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`S[], Editable -> False]], ")"}], 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`WeightOfIndicesList", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"xAct`xConf`Private`i1$", ",", 
                    "xAct`xConf`Private`i2$"}], "}"}], "]"}], "-", "2"}]], 
                    " ", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gs2]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$"}, {" ", " "}}, RowSpacings -> 0, 
                    ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RicciCDgs2[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], Editable -> 
                    False]}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"ConformalFrame[gs2]", "[", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    SuperscriptBox[
                    "\[Del]gS2", "\!\(xAct`xConf`Private`i1$\+_\)"], 
                    "xAct`xConf`Private`ex$_"}], AutoSpacing -> False, 
                    ShowAutoStyles -> False], 
                    $CellContext`CDgS2[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]]][
                    Pattern[xAct`xConf`Private`ex$, 
                    Blank[]]], Editable -> False], "]"}], AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gs2][
                    $CellContext`CDgS2[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]]][
                    Pattern[xAct`xConf`Private`ex$, 
                    Blank[]]]], Editable -> False], ":=", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{"(", 
                    FractionBox[
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], 
                    InterpretationBox[
                    StyleBox[
                    "S", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`S[], Editable -> False]], ")"}], 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`WeightOfIndicesList", "[", 
                    RowBox[{"{", "xAct`xConf`Private`i1$", "}"}], "]"}], "-", 
                    "1"}]], " ", 
                    RowBox[{"(", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    SuperscriptBox["\[Del]gs2", "xAct`xConf`Private`i1$"], 
                    "ConformalFrame[gs2]", "[", "xAct`xConf`Private`ex$", 
                    "]"}], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`CDgs2[xAct`xConf`Private`i1$][
                    xAct`xConf`ConformalFrame[$CellContext`gs2][
                    xAct`xConf`Private`ex$]], Editable -> False], 
                    ")"}]}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[0, 0, 1]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"\[Epsilon][g\!\(S\^2\)]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(xAct`xConf`Private`inds$\+_\)"}, {" "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`epsilongS2[
                    Pattern[xAct`xConf`Private`inds$, 
                    BlankSequence[]]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gs2][
                    $CellContext`epsilongS2[
                    Pattern[xAct`xConf`Private`inds$, 
                    BlankSequence[]]]], Editable -> False], ":=", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{"(", 
                    FractionBox[
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], 
                    InterpretationBox[
                    StyleBox[
                    "S", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`S[], Editable -> False]], ")"}], 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`WeightOfIndicesList", "[", 
                    RowBox[{"{", "xAct`xConf`Private`inds$", "}"}], "]"}], 
                    "-", 
                    RowBox[{"Length", "[", 
                    RowBox[{"{", "xAct`xConf`Private`inds$", "}"}], "]"}]}]], 
                    " ", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"\[Epsilon][g\!\(s\^2\)]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`inds$"}, {" "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`epsilongs2[xAct`xConf`Private`inds$], 
                    Editable -> False]}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[1, 0, 0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"[g\!\(s\^2\)]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`i1$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i2$\+_\)\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`gs2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[1, 0, 0]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gS2][
                    $CellContext`gs2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ]]], Editable -> False], 
                    ":=", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"[g\!\(S\^2\)]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$"}, {" ", " "}}, RowSpacings -> 0, 
                    ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`gS2[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], Editable -> 
                    False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[1, 0, 0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"i[g\!\(s\^2\)]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`i1$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i2$\+_\)\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`Invgs2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`UpIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`UpIndexQ]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[1, 0, 0]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gS2][
                    $CellContext`Invgs2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`UpIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`UpIndexQ]]], Editable -> False], 
                    ":=", 
                    RowBox[{
                    RowBox[{"Inv", "[", "gS2", "]"}], "[", 
                    
                    RowBox[{
                    "xAct`xConf`Private`i1$", ",", "xAct`xConf`Private`i2$"}],
                     "]"}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[1, 0, 0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gs2]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`i1$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i2$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i3$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i4$\+_\)\+_\)"}, {
                    " ", " ", " ", " "}}, RowSpacings -> 0, ColumnSpacings -> 
                    0.05, GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RiemannCDgs2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i3$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i4$, 
                    Blank[]], xAct`xTensor`UpIndexQ]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[1, 0, 0]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gS2][
                    $CellContext`RiemannCDgs2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i3$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i4$, 
                    Blank[]], xAct`xTensor`UpIndexQ]]], Editable -> False], 
                    ":=", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gS2]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$", "xAct`xConf`Private`i3$", 
                    "xAct`xConf`Private`i4$"}, {" ", " ", " ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RiemannCDgS2[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
                    xAct`xConf`Private`i3$, xAct`xConf`Private`i4$], Editable -> 
                    False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[1, 0, 0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gs2]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(xAct`xConf`Private`i1$\+_\)", 
                    "\!\(xAct`xConf`Private`i2$\+_\)", 
                    "\!\(xAct`xConf`Private`i3$\+_\)", 
                    "\!\(xAct`xConf`Private`i4$\+_\)"}, {" ", " ", " ", " "}},
                     RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RiemannCDgs2[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i3$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i4$, 
                    Blank[]]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[1, 0, 0]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gS2][
                    $CellContext`RiemannCDgs2[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i3$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i4$, 
                    Blank[]]]], Editable -> False], ":=", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{"(", 
                    FractionBox[
                    InterpretationBox[
                    StyleBox[
                    "S", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`S[], Editable -> False], 
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False]], ")"}], 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`WeightOfIndicesList", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"xAct`xConf`Private`i1$", ",", 
                    "xAct`xConf`Private`i2$", ",", "xAct`xConf`Private`i3$", 
                    ",", "xAct`xConf`Private`i4$"}], "}"}], "]"}], "-", 
                    "2"}]], " ", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gS2]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$", "xAct`xConf`Private`i3$", 
                    "xAct`xConf`Private`i4$"}, {" ", " ", " ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RiemannCDgS2[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
                    xAct`xConf`Private`i3$, xAct`xConf`Private`i4$], Editable -> 
                    False]}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[1, 0, 0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gs2]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`i1$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i2$\+_\)\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RicciCDgs2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[1, 0, 0]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gS2][
                    $CellContext`RicciCDgs2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ]]], Editable -> False], 
                    ":=", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gS2]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$"}, {" ", " "}}, RowSpacings -> 0, 
                    ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RicciCDgS2[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], Editable -> 
                    False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[1, 0, 0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gs2]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(xAct`xConf`Private`i1$\+_\)", 
                    "\!\(xAct`xConf`Private`i2$\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RicciCDgs2[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[1, 0, 0]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gS2][
                    $CellContext`RicciCDgs2[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]]]], Editable -> False], ":=", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{"(", 
                    FractionBox[
                    InterpretationBox[
                    StyleBox[
                    "S", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`S[], Editable -> False], 
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False]], ")"}], 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`WeightOfIndicesList", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"xAct`xConf`Private`i1$", ",", 
                    "xAct`xConf`Private`i2$"}], "}"}], "]"}], "-", "2"}]], 
                    " ", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gS2]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$"}, {" ", " "}}, RowSpacings -> 0, 
                    ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RicciCDgS2[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], Editable -> 
                    False]}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"ConformalFrame[gS2]", "[", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    SuperscriptBox[
                    "\[Del]gs2", "\!\(xAct`xConf`Private`i1$\+_\)"], 
                    "xAct`xConf`Private`ex$_"}], AutoSpacing -> False, 
                    ShowAutoStyles -> False], 
                    $CellContext`CDgs2[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]]][
                    Pattern[xAct`xConf`Private`ex$, 
                    Blank[]]], Editable -> False], "]"}], AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gS2][
                    $CellContext`CDgs2[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]]][
                    Pattern[xAct`xConf`Private`ex$, 
                    Blank[]]]], Editable -> False], ":=", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{"(", 
                    FractionBox[
                    InterpretationBox[
                    StyleBox[
                    "S", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`S[], Editable -> False], 
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False]], ")"}], 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`WeightOfIndicesList", "[", 
                    RowBox[{"{", "xAct`xConf`Private`i1$", "}"}], "]"}], "-", 
                    "1"}]], " ", 
                    RowBox[{"(", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    SuperscriptBox["\[Del]gS2", "xAct`xConf`Private`i1$"], 
                    "ConformalFrame[gS2]", "[", "xAct`xConf`Private`ex$", 
                    "]"}], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`CDgS2[xAct`xConf`Private`i1$][
                    xAct`xConf`ConformalFrame[$CellContext`gS2][
                    xAct`xConf`Private`ex$]], Editable -> False], 
                    ")"}]}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[1, 0, 0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"\[Epsilon][g\!\(s\^2\)]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(xAct`xConf`Private`inds$\+_\)"}, {" "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`epsilongs2[
                    Pattern[xAct`xConf`Private`inds$, 
                    BlankSequence[]]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[1, 0, 0]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gS2][
                    $CellContext`epsilongs2[
                    Pattern[xAct`xConf`Private`inds$, 
                    BlankSequence[]]]], Editable -> False], ":=", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{"(", 
                    FractionBox[
                    InterpretationBox[
                    StyleBox[
                    "S", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`S[], Editable -> False], 
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False]], ")"}], 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`WeightOfIndicesList", "[", 
                    RowBox[{"{", "xAct`xConf`Private`inds$", "}"}], "]"}], 
                    "-", 
                    RowBox[{"Length", "[", 
                    RowBox[{"{", "xAct`xConf`Private`inds$", "}"}], "]"}]}]], 
                    " ", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"\[Epsilon][g\!\(S\^2\)]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`inds$"}, {" "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`epsilongS2[xAct`xConf`Private`inds$], 
                    Editable -> False]}]}]}, {" "}}, 
                  GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                  DefaultBaseStyle -> "Column", 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                "RowDefault"]}
             },
             DefaultBaseStyle->"Column",
             GridBoxAlignment->{"Columns" -> {{Left}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
            "Column"],
           FrameMargins->{{6, 0}, {3, 6}}], "\<\"\"\>"},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xConf`ConformalFrame\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->{{6, 6}, {6, 3}}], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Formal scalar head ConformalFrame[metric][expr] \
which indicates that expr (which must be of the form tens[inds]) is in fact \
the transformation of that quantity from the ambient frame to the frame \
associated with metric. Hence if metric is the first metric \
ConformalFrame[firstmetric][expr] = expr. \"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "Formal scalar head ConformalFrame[metric][expr] which indicates that \
expr (which must be of the form tens[inds]) is in fact the transformation of \
that quantity from the ambient frame to the frame associated with metric. \
Hence if metric is the first metric ConformalFrame[firstmetric][expr] = expr. \
", "Documentation" -> None, "OwnValues" -> None, "UpValues" -> 
    Information`InformationValueForm[
     UpValues, xAct`xConf`ConformalFrame, {xAct`xTensor`ContractThroughQ[
         xAct`xConf`ConformalFrame[$CellContext`g], xAct`xTensor`delta] -> 
       True, xAct`xTensor`ContractThroughQ[
         xAct`xConf`ConformalFrame[$CellContext`gs2], xAct`xTensor`delta] -> 
       True, xAct`xTensor`ContractThroughQ[
         xAct`xConf`ConformalFrame[$CellContext`gS2], xAct`xTensor`delta] -> 
       True, xAct`xTensor`DefInfo[
         xAct`xConf`ConformalFrame[$CellContext`g]] -> {"inert head", ""}, 
       xAct`xTensor`DefInfo[
         xAct`xConf`ConformalFrame[$CellContext`gs2]] -> {"inert head", ""}, 
       xAct`xTensor`DefInfo[
         xAct`xConf`ConformalFrame[$CellContext`gS2]] -> {"inert head", ""}, 
       xAct`xTensor`InertHeadQ[
         xAct`xConf`ConformalFrame[$CellContext`g]] -> True, 
       xAct`xTensor`InertHeadQ[
         xAct`xConf`ConformalFrame[$CellContext`gs2]] -> True, 
       xAct`xTensor`InertHeadQ[
         xAct`xConf`ConformalFrame[$CellContext`gS2]] -> True, 
       xAct`xTensor`LinearQ[
         xAct`xConf`ConformalFrame[$CellContext`g]] -> False, 
       xAct`xTensor`LinearQ[
         xAct`xConf`ConformalFrame[$CellContext`gs2]] -> False, 
       xAct`xTensor`LinearQ[
         xAct`xConf`ConformalFrame[$CellContext`gS2]] -> False, 
       xAct`xTensor`PrintAs[
         xAct`xConf`ConformalFrame[$CellContext`g]] -> "ConformalFrame[g]", 
       xAct`xTensor`PrintAs[
         xAct`xConf`ConformalFrame[$CellContext`gs2]] -> 
       "ConformalFrame[gs2]", xAct`xTensor`PrintAs[
         xAct`xConf`ConformalFrame[$CellContext`gS2]] -> 
       "ConformalFrame[gS2]"}], "DownValues" -> None, "SubValues" -> 
    Information`InformationValueForm[
     SubValues, xAct`xConf`ConformalFrame, {
      xAct`xConf`ConformalFrame[$CellContext`g][
         $CellContext`Detgs2[]] :> $CellContext`Detg[], 
       xAct`xConf`ConformalFrame[$CellContext`g][
         $CellContext`DetgS2[]] :> $CellContext`Detg[], 
       xAct`xConf`ConformalFrame[$CellContext`g][
         $CellContext`RicciScalarCDgs2[]] :> $CellContext`RicciScalarCD[], 
       xAct`xConf`ConformalFrame[$CellContext`g][
         $CellContext`RicciScalarCDgS2[]] :> $CellContext`RicciScalarCD[], 
       xAct`xConf`ConformalFrame[$CellContext`gs2][
         $CellContext`Detg[]] :> $CellContext`Detgs2[], 
       xAct`xConf`ConformalFrame[$CellContext`gs2][
         $CellContext`DetgS2[]] :> $CellContext`Detgs2[], 
       xAct`xConf`ConformalFrame[$CellContext`gs2][
         $CellContext`RicciScalarCD[]] :> $CellContext`RicciScalarCDgs2[], 
       xAct`xConf`ConformalFrame[$CellContext`gs2][
         $CellContext`RicciScalarCDgS2[]] :> $CellContext`RicciScalarCDgs2[], 
       xAct`xConf`ConformalFrame[$CellContext`gS2][
         $CellContext`Detg[]] :> $CellContext`DetgS2[], 
       xAct`xConf`ConformalFrame[$CellContext`gS2][
         $CellContext`Detgs2[]] :> $CellContext`DetgS2[], 
       xAct`xConf`ConformalFrame[$CellContext`gS2][
         $CellContext`RicciScalarCD[]] :> $CellContext`RicciScalarCDgS2[], 
       xAct`xConf`ConformalFrame[$CellContext`gS2][
         $CellContext`RicciScalarCDgs2[]] :> $CellContext`RicciScalarCDgS2[], 
       xAct`xConf`ConformalFrame[
         Blank[]][
         xAct`xTensor`delta[
          Pattern[xAct`xConf`Private`\[Mu], 
           Blank[]], 
          Pattern[xAct`xConf`Private`\[Nu], 
           Blank[]]]] :> 
       xAct`xTensor`delta[xAct`xConf`Private`\[Mu], xAct`xConf`Private`\[Nu]],
        xAct`xConf`ConformalFrame[
         PatternTest[
          Pattern[xAct`xConf`Private`g1, 
           Blank[]], xAct`xTensor`MetricQ]][
         PatternTest[
          Pattern[xAct`xConf`Private`val, 
           Blank[]], NumberQ]] :> xAct`xConf`Private`val, 
       xAct`xConf`ConformalFrame[
         PatternTest[
          Pattern[xAct`xConf`Private`g1, 
           Blank[]], xAct`xTensor`MetricQ]][
         PatternTest[
          Pattern[xAct`xConf`Private`val, 
           Blank[]], xAct`xTensor`ConstantSymbolQ]] :> xAct`xConf`Private`val,
        xAct`xConf`ConformalFrame[
         PatternTest[
          Pattern[xAct`xConf`Private`g1, 
           Blank[]], xAct`xTensor`MetricQ]][PatternTest[
           Pattern[xAct`xConf`Private`S, 
            Blank[]], xAct`xTensor`ScalarQ]^Pattern[xAct`xConf`Private`n, 
           Blank[]]] :> 
       xAct`xConf`ConformalFrame[xAct`xConf`Private`g1][xAct`xConf`Private`S]^
        xAct`xConf`Private`n, xAct`xConf`ConformalFrame[
         PatternTest[
          Pattern[xAct`xConf`Private`g1, 
           Blank[]], xAct`xTensor`MetricQ]][
         Pattern[xAct`xConf`Private`product, 
          Blank[Times]]] :> 
       Map[xAct`xConf`ConformalFrame[xAct`xConf`Private`g1][#]& , 
         xAct`xConf`Private`product], xAct`xConf`ConformalFrame[
         PatternTest[
          Pattern[xAct`xConf`Private`g1, 
           Blank[]], xAct`xTensor`MetricQ]][
         Pattern[xAct`xConf`Private`sum, 
          Blank[Plus]]] :> 
       Map[xAct`xConf`ConformalFrame[xAct`xConf`Private`g1][#]& , 
         xAct`xConf`Private`sum], xAct`xConf`ConformalFrame[
         PatternTest[
          Pattern[xAct`xConf`Private`g1, 
           Blank[]], xAct`xTensor`MetricQ]][
         xAct`xTensor`Scalar[
          Pattern[xAct`xConf`Private`expr, 
           Blank[]]]] :> xAct`xTensor`Scalar[
         xAct`xConf`ConformalFrame[xAct`xConf`Private`g1][
         xAct`xConf`Private`expr]], xAct`xConf`ConformalFrame[
         PatternTest[
          Pattern[xAct`xConf`Private`g1, 
           Blank[]], xAct`xTensor`MetricQ]][
         PatternTest[
          Pattern[xAct`xConf`Private`f, 
           Blank[]], xAct`xTensor`ScalarFunctionQ][
          Pattern[xAct`xConf`Private`expr, 
           Blank[]]]] :> xAct`xConf`Private`f[
         xAct`xConf`ConformalFrame[xAct`xConf`Private`g1][
         xAct`xConf`Private`expr]], xAct`xConf`ConformalFrame[
         PatternTest[
          Pattern[xAct`xConf`Private`g1, 
           Blank[]], xAct`xTensor`MetricQ]][
         PatternTest[
          Pattern[xAct`xConf`Private`S, 
           Blank[]], And[
           xAct`xTensor`ScalarQ[#], xAct`xConf`ConformalWeight[#] === 
           0]& ][]] :> xAct`xConf`Private`S[], xAct`xConf`ConformalFrame[
         PatternTest[
          Pattern[xAct`xConf`Private`g1, 
           Blank[]], xAct`xTensor`MetricQ]][
         xAct`xConf`ConformalFrame[
          PatternTest[
           Pattern[xAct`xConf`Private`g2, 
            Blank[]], xAct`xTensor`MetricQ]][
          Pattern[xAct`xConf`Private`expr, 
           Blank[]]]] :> 
       xAct`xConf`ConformalFrame[xAct`xConf`Private`g1][
        xAct`xConf`Private`expr], xAct`xConf`ConformalFrame[
         Blank[]][
         $CellContext`S[]] :> $CellContext`S[], 
       xAct`xConf`ConformalFrame[$CellContext`gS2][
         $CellContext`g[
          PatternTest[
           Pattern[xAct`xConf`Private`i1$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i2$, 
            Blank[]], xAct`xTensor`DownIndexQ]]] :> $CellContext`gS2[
        xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], 
       xAct`xConf`ConformalFrame[$CellContext`gS2][
         $CellContext`g[
          PatternTest[
           Pattern[xAct`xConf`Private`i1$, 
            Blank[]], xAct`xTensor`UpIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i2$, 
            Blank[]], xAct`xTensor`UpIndexQ]]] :> 
       xAct`xTensor`Inv[$CellContext`gS2][
        xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], 
       xAct`xConf`ConformalFrame[$CellContext`gS2][
         $CellContext`RiemannCD[
          PatternTest[
           Pattern[xAct`xConf`Private`i1$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i2$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i3$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i4$, 
            Blank[]], xAct`xTensor`UpIndexQ]]] :> $CellContext`RiemannCDgS2[
        xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
         xAct`xConf`Private`i3$, xAct`xConf`Private`i4$], 
       xAct`xConf`ConformalFrame[$CellContext`gS2][
         $CellContext`RiemannCD[
          Pattern[xAct`xConf`Private`i1$, 
           Blank[]], 
          Pattern[xAct`xConf`Private`i2$, 
           Blank[]], 
          Pattern[xAct`xConf`Private`i3$, 
           Blank[]], 
          Pattern[xAct`xConf`Private`i4$, 
           Blank[]]]] :> $CellContext`S[]^(
          xAct`xConf`Private`WeightOfIndicesList[{
            xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
             xAct`xConf`Private`i3$, xAct`xConf`Private`i4$}] - 
          2) $CellContext`RiemannCDgS2[
         xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
          xAct`xConf`Private`i3$, xAct`xConf`Private`i4$], 
       xAct`xConf`ConformalFrame[$CellContext`gS2][
         $CellContext`RicciCD[
          PatternTest[
           Pattern[xAct`xConf`Private`i1$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i2$, 
            Blank[]], xAct`xTensor`DownIndexQ]]] :> $CellContext`RicciCDgS2[
        xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], 
       xAct`xConf`ConformalFrame[$CellContext`gS2][
         $CellContext`RicciCD[
          Pattern[xAct`xConf`Private`i1$, 
           Blank[]], 
          Pattern[xAct`xConf`Private`i2$, 
           Blank[]]]] :> $CellContext`S[]^(
          xAct`xConf`Private`WeightOfIndicesList[{
            xAct`xConf`Private`i1$, xAct`xConf`Private`i2$}] - 
          2) $CellContext`RicciCDgS2[
         xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], 
       xAct`xConf`ConformalFrame[$CellContext`gS2][
         $CellContext`CD[
          Pattern[xAct`xConf`Private`i1$, 
           Blank[]]][
          Pattern[xAct`xConf`Private`ex$, 
           Blank[]]]] :> $CellContext`S[]^(
          xAct`xConf`Private`WeightOfIndicesList[{xAct`xConf`Private`i1$}] - 
          1) $CellContext`CDgS2[xAct`xConf`Private`i1$][
          xAct`xConf`ConformalFrame[$CellContext`gS2][
          xAct`xConf`Private`ex$]], 
       xAct`xConf`ConformalFrame[$CellContext`gS2][
         $CellContext`epsilong[
          Pattern[xAct`xConf`Private`inds$, 
           BlankSequence[]]]] :> $CellContext`S[]^(
          xAct`xConf`Private`WeightOfIndicesList[{xAct`xConf`Private`inds$}] - 
          Length[{xAct`xConf`Private`inds$}]) $CellContext`epsilongS2[
         xAct`xConf`Private`inds$], 
       xAct`xConf`ConformalFrame[$CellContext`g][
         $CellContext`gS2[
          PatternTest[
           Pattern[xAct`xConf`Private`i1$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i2$, 
            Blank[]], xAct`xTensor`DownIndexQ]]] :> $CellContext`g[
        xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], 
       xAct`xConf`ConformalFrame[$CellContext`g][
         $CellContext`InvgS2[
          PatternTest[
           Pattern[xAct`xConf`Private`i1$, 
            Blank[]], xAct`xTensor`UpIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i2$, 
            Blank[]], xAct`xTensor`UpIndexQ]]] :> 
       xAct`xTensor`Inv[$CellContext`g][
        xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], 
       xAct`xConf`ConformalFrame[$CellContext`g][
         $CellContext`RiemannCDgS2[
          PatternTest[
           Pattern[xAct`xConf`Private`i1$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i2$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i3$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i4$, 
            Blank[]], xAct`xTensor`UpIndexQ]]] :> $CellContext`RiemannCD[
        xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
         xAct`xConf`Private`i3$, xAct`xConf`Private`i4$], 
       xAct`xConf`ConformalFrame[$CellContext`g][
         $CellContext`RiemannCDgS2[
          Pattern[xAct`xConf`Private`i1$, 
           Blank[]], 
          Pattern[xAct`xConf`Private`i2$, 
           Blank[]], 
          Pattern[xAct`xConf`Private`i3$, 
           Blank[]], 
          Pattern[xAct`xConf`Private`i4$, 
           Blank[]]]] :> ($CellContext`S[]^(-1))^(
          xAct`xConf`Private`WeightOfIndicesList[{
            xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
             xAct`xConf`Private`i3$, xAct`xConf`Private`i4$}] - 
          2) $CellContext`RiemannCD[
         xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
          xAct`xConf`Private`i3$, xAct`xConf`Private`i4$], 
       xAct`xConf`ConformalFrame[$CellContext`g][
         $CellContext`RicciCDgS2[
          PatternTest[
           Pattern[xAct`xConf`Private`i1$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i2$, 
            Blank[]], xAct`xTensor`DownIndexQ]]] :> $CellContext`RicciCD[
        xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], 
       xAct`xConf`ConformalFrame[$CellContext`g][
         $CellContext`RicciCDgS2[
          Pattern[xAct`xConf`Private`i1$, 
           Blank[]], 
          Pattern[xAct`xConf`Private`i2$, 
           Blank[]]]] :> ($CellContext`S[]^(-1))^(
          xAct`xConf`Private`WeightOfIndicesList[{
            xAct`xConf`Private`i1$, xAct`xConf`Private`i2$}] - 
          2) $CellContext`RicciCD[
         xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], 
       xAct`xConf`ConformalFrame[$CellContext`g][
         $CellContext`CDgS2[
          Pattern[xAct`xConf`Private`i1$, 
           Blank[]]][
          Pattern[xAct`xConf`Private`ex$, 
           Blank[]]]] :> ($CellContext`S[]^(-1))^(
          xAct`xConf`Private`WeightOfIndicesList[{xAct`xConf`Private`i1$}] - 
          1) $CellContext`CD[xAct`xConf`Private`i1$][
          xAct`xConf`ConformalFrame[$CellContext`g][xAct`xConf`Private`ex$]], 
       xAct`xConf`ConformalFrame[$CellContext`g][
         $CellContext`epsilongS2[
          Pattern[xAct`xConf`Private`inds$, 
           BlankSequence[]]]] :> ($CellContext`S[]^(-1))^(
          xAct`xConf`Private`WeightOfIndicesList[{xAct`xConf`Private`inds$}] - 
          Length[{xAct`xConf`Private`inds$}]) $CellContext`epsilong[
         xAct`xConf`Private`inds$], xAct`xConf`ConformalFrame[
         Blank[]][
         $CellContext`s[]] :> $CellContext`s[], 
       xAct`xConf`ConformalFrame[$CellContext`gs2][
         $CellContext`g[
          PatternTest[
           Pattern[xAct`xConf`Private`i1$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i2$, 
            Blank[]], xAct`xTensor`DownIndexQ]]] :> $CellContext`gs2[
        xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], 
       xAct`xConf`ConformalFrame[$CellContext`gs2][
         $CellContext`g[
          PatternTest[
           Pattern[xAct`xConf`Private`i1$, 
            Blank[]], xAct`xTensor`UpIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i2$, 
            Blank[]], xAct`xTensor`UpIndexQ]]] :> 
       xAct`xTensor`Inv[$CellContext`gs2][
        xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], 
       xAct`xConf`ConformalFrame[$CellContext`gs2][
         $CellContext`RiemannCD[
          PatternTest[
           Pattern[xAct`xConf`Private`i1$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i2$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i3$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i4$, 
            Blank[]], xAct`xTensor`UpIndexQ]]] :> $CellContext`RiemannCDgs2[
        xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
         xAct`xConf`Private`i3$, xAct`xConf`Private`i4$], 
       xAct`xConf`ConformalFrame[$CellContext`gs2][
         $CellContext`RiemannCD[
          Pattern[xAct`xConf`Private`i1$, 
           Blank[]], 
          Pattern[xAct`xConf`Private`i2$, 
           Blank[]], 
          Pattern[xAct`xConf`Private`i3$, 
           Blank[]], 
          Pattern[xAct`xConf`Private`i4$, 
           Blank[]]]] :> $CellContext`s[]^(
          xAct`xConf`Private`WeightOfIndicesList[{
            xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
             xAct`xConf`Private`i3$, xAct`xConf`Private`i4$}] - 
          2) $CellContext`RiemannCDgs2[
         xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
          xAct`xConf`Private`i3$, xAct`xConf`Private`i4$], 
       xAct`xConf`ConformalFrame[$CellContext`gs2][
         $CellContext`RicciCD[
          PatternTest[
           Pattern[xAct`xConf`Private`i1$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i2$, 
            Blank[]], xAct`xTensor`DownIndexQ]]] :> $CellContext`RicciCDgs2[
        xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], 
       xAct`xConf`ConformalFrame[$CellContext`gs2][
         $CellContext`RicciCD[
          Pattern[xAct`xConf`Private`i1$, 
           Blank[]], 
          Pattern[xAct`xConf`Private`i2$, 
           Blank[]]]] :> $CellContext`s[]^(
          xAct`xConf`Private`WeightOfIndicesList[{
            xAct`xConf`Private`i1$, xAct`xConf`Private`i2$}] - 
          2) $CellContext`RicciCDgs2[
         xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], 
       xAct`xConf`ConformalFrame[$CellContext`gs2][
         $CellContext`CD[
          Pattern[xAct`xConf`Private`i1$, 
           Blank[]]][
          Pattern[xAct`xConf`Private`ex$, 
           Blank[]]]] :> $CellContext`s[]^(
          xAct`xConf`Private`WeightOfIndicesList[{xAct`xConf`Private`i1$}] - 
          1) $CellContext`CDgs2[xAct`xConf`Private`i1$][
          xAct`xConf`ConformalFrame[$CellContext`gs2][
          xAct`xConf`Private`ex$]], 
       xAct`xConf`ConformalFrame[$CellContext`gs2][
         $CellContext`epsilong[
          Pattern[xAct`xConf`Private`inds$, 
           BlankSequence[]]]] :> $CellContext`s[]^(
          xAct`xConf`Private`WeightOfIndicesList[{xAct`xConf`Private`inds$}] - 
          Length[{xAct`xConf`Private`inds$}]) $CellContext`epsilongs2[
         xAct`xConf`Private`inds$], 
       xAct`xConf`ConformalFrame[$CellContext`g][
         $CellContext`gs2[
          PatternTest[
           Pattern[xAct`xConf`Private`i1$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i2$, 
            Blank[]], xAct`xTensor`DownIndexQ]]] :> $CellContext`g[
        xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], 
       xAct`xConf`ConformalFrame[$CellContext`g][
         $CellContext`Invgs2[
          PatternTest[
           Pattern[xAct`xConf`Private`i1$, 
            Blank[]], xAct`xTensor`UpIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i2$, 
            Blank[]], xAct`xTensor`UpIndexQ]]] :> 
       xAct`xTensor`Inv[$CellContext`g][
        xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], 
       xAct`xConf`ConformalFrame[$CellContext`g][
         $CellContext`RiemannCDgs2[
          PatternTest[
           Pattern[xAct`xConf`Private`i1$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i2$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i3$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i4$, 
            Blank[]], xAct`xTensor`UpIndexQ]]] :> $CellContext`RiemannCD[
        xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
         xAct`xConf`Private`i3$, xAct`xConf`Private`i4$], 
       xAct`xConf`ConformalFrame[$CellContext`g][
         $CellContext`RiemannCDgs2[
          Pattern[xAct`xConf`Private`i1$, 
           Blank[]], 
          Pattern[xAct`xConf`Private`i2$, 
           Blank[]], 
          Pattern[xAct`xConf`Private`i3$, 
           Blank[]], 
          Pattern[xAct`xConf`Private`i4$, 
           Blank[]]]] :> ($CellContext`s[]^(-1))^(
          xAct`xConf`Private`WeightOfIndicesList[{
            xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
             xAct`xConf`Private`i3$, xAct`xConf`Private`i4$}] - 
          2) $CellContext`RiemannCD[
         xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
          xAct`xConf`Private`i3$, xAct`xConf`Private`i4$], 
       xAct`xConf`ConformalFrame[$CellContext`g][
         $CellContext`RicciCDgs2[
          PatternTest[
           Pattern[xAct`xConf`Private`i1$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i2$, 
            Blank[]], xAct`xTensor`DownIndexQ]]] :> $CellContext`RicciCD[
        xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], 
       xAct`xConf`ConformalFrame[$CellContext`g][
         $CellContext`RicciCDgs2[
          Pattern[xAct`xConf`Private`i1$, 
           Blank[]], 
          Pattern[xAct`xConf`Private`i2$, 
           Blank[]]]] :> ($CellContext`s[]^(-1))^(
          xAct`xConf`Private`WeightOfIndicesList[{
            xAct`xConf`Private`i1$, xAct`xConf`Private`i2$}] - 
          2) $CellContext`RicciCD[
         xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], 
       xAct`xConf`ConformalFrame[$CellContext`g][
         $CellContext`CDgs2[
          Pattern[xAct`xConf`Private`i1$, 
           Blank[]]][
          Pattern[xAct`xConf`Private`ex$, 
           Blank[]]]] :> ($CellContext`s[]^(-1))^(
          xAct`xConf`Private`WeightOfIndicesList[{xAct`xConf`Private`i1$}] - 
          1) $CellContext`CD[xAct`xConf`Private`i1$][
          xAct`xConf`ConformalFrame[$CellContext`g][xAct`xConf`Private`ex$]], 
       xAct`xConf`ConformalFrame[$CellContext`g][
         $CellContext`epsilongs2[
          Pattern[xAct`xConf`Private`inds$, 
           BlankSequence[]]]] :> ($CellContext`s[]^(-1))^(
          xAct`xConf`Private`WeightOfIndicesList[{xAct`xConf`Private`inds$}] - 
          Length[{xAct`xConf`Private`inds$}]) $CellContext`epsilong[
         xAct`xConf`Private`inds$], 
       xAct`xConf`ConformalFrame[$CellContext`gs2][
         $CellContext`gS2[
          PatternTest[
           Pattern[xAct`xConf`Private`i1$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i2$, 
            Blank[]], xAct`xTensor`DownIndexQ]]] :> $CellContext`gs2[
        xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], 
       xAct`xConf`ConformalFrame[$CellContext`gs2][
         $CellContext`InvgS2[
          PatternTest[
           Pattern[xAct`xConf`Private`i1$, 
            Blank[]], xAct`xTensor`UpIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i2$, 
            Blank[]], xAct`xTensor`UpIndexQ]]] :> 
       xAct`xTensor`Inv[$CellContext`gs2][
        xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], 
       xAct`xConf`ConformalFrame[$CellContext`gs2][
         $CellContext`RiemannCDgS2[
          PatternTest[
           Pattern[xAct`xConf`Private`i1$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i2$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i3$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i4$, 
            Blank[]], xAct`xTensor`UpIndexQ]]] :> $CellContext`RiemannCDgs2[
        xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
         xAct`xConf`Private`i3$, xAct`xConf`Private`i4$], 
       xAct`xConf`ConformalFrame[$CellContext`gs2][
         $CellContext`RiemannCDgS2[
          Pattern[xAct`xConf`Private`i1$, 
           Blank[]], 
          Pattern[xAct`xConf`Private`i2$, 
           Blank[]], 
          Pattern[xAct`xConf`Private`i3$, 
           Blank[]], 
          Pattern[xAct`xConf`Private`i4$, 
           Blank[]]]] :> ($CellContext`s[]/$CellContext`S[])^(
          xAct`xConf`Private`WeightOfIndicesList[{
            xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
             xAct`xConf`Private`i3$, xAct`xConf`Private`i4$}] - 
          2) $CellContext`RiemannCDgs2[
         xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
          xAct`xConf`Private`i3$, xAct`xConf`Private`i4$], 
       xAct`xConf`ConformalFrame[$CellContext`gs2][
         $CellContext`RicciCDgS2[
          PatternTest[
           Pattern[xAct`xConf`Private`i1$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i2$, 
            Blank[]], xAct`xTensor`DownIndexQ]]] :> $CellContext`RicciCDgs2[
        xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], 
       xAct`xConf`ConformalFrame[$CellContext`gs2][
         $CellContext`RicciCDgS2[
          Pattern[xAct`xConf`Private`i1$, 
           Blank[]], 
          Pattern[xAct`xConf`Private`i2$, 
           Blank[]]]] :> ($CellContext`s[]/$CellContext`S[])^(
          xAct`xConf`Private`WeightOfIndicesList[{
            xAct`xConf`Private`i1$, xAct`xConf`Private`i2$}] - 
          2) $CellContext`RicciCDgs2[
         xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], 
       xAct`xConf`ConformalFrame[$CellContext`gs2][
         $CellContext`CDgS2[
          Pattern[xAct`xConf`Private`i1$, 
           Blank[]]][
          Pattern[xAct`xConf`Private`ex$, 
           Blank[]]]] :> ($CellContext`s[]/$CellContext`S[])^(
          xAct`xConf`Private`WeightOfIndicesList[{xAct`xConf`Private`i1$}] - 
          1) $CellContext`CDgs2[xAct`xConf`Private`i1$][
          xAct`xConf`ConformalFrame[$CellContext`gs2][
          xAct`xConf`Private`ex$]], 
       xAct`xConf`ConformalFrame[$CellContext`gs2][
         $CellContext`epsilongS2[
          Pattern[xAct`xConf`Private`inds$, 
           BlankSequence[]]]] :> ($CellContext`s[]/$CellContext`S[])^(
          xAct`xConf`Private`WeightOfIndicesList[{xAct`xConf`Private`inds$}] - 
          Length[{xAct`xConf`Private`inds$}]) $CellContext`epsilongs2[
         xAct`xConf`Private`inds$], 
       xAct`xConf`ConformalFrame[$CellContext`gS2][
         $CellContext`gs2[
          PatternTest[
           Pattern[xAct`xConf`Private`i1$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i2$, 
            Blank[]], xAct`xTensor`DownIndexQ]]] :> $CellContext`gS2[
        xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], 
       xAct`xConf`ConformalFrame[$CellContext`gS2][
         $CellContext`Invgs2[
          PatternTest[
           Pattern[xAct`xConf`Private`i1$, 
            Blank[]], xAct`xTensor`UpIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i2$, 
            Blank[]], xAct`xTensor`UpIndexQ]]] :> 
       xAct`xTensor`Inv[$CellContext`gS2][
        xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], 
       xAct`xConf`ConformalFrame[$CellContext`gS2][
         $CellContext`RiemannCDgs2[
          PatternTest[
           Pattern[xAct`xConf`Private`i1$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i2$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i3$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i4$, 
            Blank[]], xAct`xTensor`UpIndexQ]]] :> $CellContext`RiemannCDgS2[
        xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
         xAct`xConf`Private`i3$, xAct`xConf`Private`i4$], 
       xAct`xConf`ConformalFrame[$CellContext`gS2][
         $CellContext`RiemannCDgs2[
          Pattern[xAct`xConf`Private`i1$, 
           Blank[]], 
          Pattern[xAct`xConf`Private`i2$, 
           Blank[]], 
          Pattern[xAct`xConf`Private`i3$, 
           Blank[]], 
          Pattern[xAct`xConf`Private`i4$, 
           Blank[]]]] :> ($CellContext`s[]^(-1) $CellContext`S[])^(
          xAct`xConf`Private`WeightOfIndicesList[{
            xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
             xAct`xConf`Private`i3$, xAct`xConf`Private`i4$}] - 
          2) $CellContext`RiemannCDgS2[
         xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
          xAct`xConf`Private`i3$, xAct`xConf`Private`i4$], 
       xAct`xConf`ConformalFrame[$CellContext`gS2][
         $CellContext`RicciCDgs2[
          PatternTest[
           Pattern[xAct`xConf`Private`i1$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i2$, 
            Blank[]], xAct`xTensor`DownIndexQ]]] :> $CellContext`RicciCDgS2[
        xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], 
       xAct`xConf`ConformalFrame[$CellContext`gS2][
         $CellContext`RicciCDgs2[
          Pattern[xAct`xConf`Private`i1$, 
           Blank[]], 
          Pattern[xAct`xConf`Private`i2$, 
           Blank[]]]] :> ($CellContext`s[]^(-1) $CellContext`S[])^(
          xAct`xConf`Private`WeightOfIndicesList[{
            xAct`xConf`Private`i1$, xAct`xConf`Private`i2$}] - 
          2) $CellContext`RicciCDgS2[
         xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], 
       xAct`xConf`ConformalFrame[$CellContext`gS2][
         $CellContext`CDgs2[
          Pattern[xAct`xConf`Private`i1$, 
           Blank[]]][
          Pattern[xAct`xConf`Private`ex$, 
           Blank[]]]] :> ($CellContext`s[]^(-1) $CellContext`S[])^(
          xAct`xConf`Private`WeightOfIndicesList[{xAct`xConf`Private`i1$}] - 
          1) $CellContext`CDgS2[xAct`xConf`Private`i1$][
          xAct`xConf`ConformalFrame[$CellContext`gS2][
          xAct`xConf`Private`ex$]], 
       xAct`xConf`ConformalFrame[$CellContext`gS2][
         $CellContext`epsilongs2[
          Pattern[xAct`xConf`Private`inds$, 
           BlankSequence[]]]] :> ($CellContext`s[]^(-1) $CellContext`S[])^(
          xAct`xConf`Private`WeightOfIndicesList[{xAct`xConf`Private`inds$}] - 
          Length[{xAct`xConf`Private`inds$}]) $CellContext`epsilongS2[
         xAct`xConf`Private`inds$]}], "DefaultValues" -> None, "NValues" -> 
    None, "FormatValues" -> None, "Options" -> None, "Attributes" -> {}, 
    "FullName" -> "xAct`xConf`ConformalFrame"|>, False]]], "Output",
 CellLabel->
  "Out[25]=",ExpressionUUID->"ee1dbb9b-9feb-4354-9684-846085ee31bc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ConformalFrame", "[", "g", "]"}], "[", 
   RowBox[{"k", "[", 
    RowBox[{"-", "\[Mu]"}], "]"}], "]"}], 
  RowBox[{"(*", " ", 
   RowBox[{"This", " ", "is", " ", "identical", " ", "to", " ", 
    RowBox[{"k", "[", 
     RowBox[{"-", "\[Mu]"}], "]"}], " ", "since", " ", "g", " ", "is", " ", 
    "the", " ", 
    RowBox[{"base", "/", "ambient"}], " ", "metric"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ConformalFrame", "[", "gS2", "]"}], "[", 
  RowBox[{"k", "[", 
   RowBox[{"-", "\[Mu]"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ConformalFrame", "[", "gs2", "]"}], "[", 
  RowBox[{"k", "[", 
   RowBox[{"-", "\[Mu]"}], "]"}], "]"}]}], "Input",
 CellLabel->"In[26]:=",ExpressionUUID->"efdc4cc3-5dfb-49a5-9bc4-a9a595e4d294"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox["[",
     FontColor->GrayLevel[0]], 
    InterpretationBox[
     StyleBox[GridBox[{
        {"k", 
         StyleBox[GridBox[{
            {" "},
            {"\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`k[-$CellContext`\[Mu]],
     Editable->False], 
    StyleBox["]",
     FontColor->GrayLevel[0]]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xConf`ConformalFrame[$CellContext`g][
   $CellContext`k[-$CellContext`\[Mu]]],
  Editable->False]], "Output",
 CellLabel->"Out[26]=",ExpressionUUID->"ff8df79c-185a-4081-b5ab-a29abd936be4"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox["[",
     FontColor->RGBColor[1, 0, 0]], 
    InterpretationBox[
     StyleBox[GridBox[{
        {"k", 
         StyleBox[GridBox[{
            {" "},
            {"\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`k[-$CellContext`\[Mu]],
     Editable->False], 
    StyleBox["]",
     FontColor->RGBColor[1, 0, 0]]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xConf`ConformalFrame[$CellContext`gS2][
   $CellContext`k[-$CellContext`\[Mu]]],
  Editable->False]], "Output",
 CellLabel->"Out[27]=",ExpressionUUID->"dfdb665f-c2be-44e0-8150-e30220dbd365"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox["[",
     FontColor->RGBColor[0, 0, 1]], 
    InterpretationBox[
     StyleBox[GridBox[{
        {"k", 
         StyleBox[GridBox[{
            {" "},
            {"\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`k[-$CellContext`\[Mu]],
     Editable->False], 
    StyleBox["]",
     FontColor->RGBColor[0, 0, 1]]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xConf`ConformalFrame[$CellContext`gs2][
   $CellContext`k[-$CellContext`\[Mu]]],
  Editable->False]], "Output",
 CellLabel->
  "Out[28]=",ExpressionUUID->"4ce4ccc1-ad97-46ac-8b3c-ab462987700b"]
}, Open  ]],

Cell["We can stop the Color formatting of frames by setting", \
"Text",ExpressionUUID->"521011c5-51a2-475c-9972-fc490c6bcb29"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$FormatConformal", " ", "=", " ", "\"\<Default\>\""}], 
  ";"}]], "Input",
 CellLabel->"In[29]:=",ExpressionUUID->"adabeb95-1f82-47e6-ae77-af1a511afdd5"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ConformalFrame", "[", "g", "]"}], "[", 
   RowBox[{"k", "[", 
    RowBox[{"-", "\[Mu]"}], "]"}], "]"}], 
  RowBox[{"(*", " ", 
   RowBox[{"This", " ", "is", " ", "identical", " ", "to", " ", 
    RowBox[{"k", "[", 
     RowBox[{"-", "\[Mu]"}], "]"}], " ", "since", " ", "g", " ", "is", " ", 
    "the", " ", 
    RowBox[{"base", "/", "ambient"}], " ", "metric"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ConformalFrame", "[", "gS2", "]"}], "[", 
  RowBox[{"k", "[", 
   RowBox[{"-", "\[Mu]"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ConformalFrame", "[", "gs2", "]"}], "[", 
  RowBox[{"k", "[", 
   RowBox[{"-", "\[Mu]"}], "]"}], "]"}]}], "Input",
 CellLabel->"In[30]:=",ExpressionUUID->"4b26660f-2a03-48b9-93ff-567f29133352"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox[
     OverscriptBox["\[Null]", "g"],
     FontSize->8], "[", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"k", 
         StyleBox[GridBox[{
            {" "},
            {"\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`k[-$CellContext`\[Mu]],
     Editable->False], "]"}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xConf`ConformalFrame[$CellContext`g][
   $CellContext`k[-$CellContext`\[Mu]]],
  Editable->False]], "Output",
 CellLabel->"Out[30]=",ExpressionUUID->"974e207c-c18c-4e09-a9a0-4b5b7e128ff3"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox[
     OverscriptBox["\[Null]", 
      RowBox[{"[", 
       RowBox[{"g", 
        SuperscriptBox["S", "2"]}], "]"}]],
     FontSize->8], "[", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"k", 
         StyleBox[GridBox[{
            {" "},
            {"\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`k[-$CellContext`\[Mu]],
     Editable->False], "]"}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xConf`ConformalFrame[$CellContext`gS2][
   $CellContext`k[-$CellContext`\[Mu]]],
  Editable->False]], "Output",
 CellLabel->"Out[31]=",ExpressionUUID->"daf8ad56-f306-4860-8536-805b14ba8f0e"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox[
     OverscriptBox["\[Null]", 
      RowBox[{"[", 
       RowBox[{"g", 
        SuperscriptBox["s", "2"]}], "]"}]],
     FontSize->8], "[", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"k", 
         StyleBox[GridBox[{
            {" "},
            {"\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`k[-$CellContext`\[Mu]],
     Editable->False], "]"}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xConf`ConformalFrame[$CellContext`gs2][
   $CellContext`k[-$CellContext`\[Mu]]],
  Editable->False]], "Output",
 CellLabel->
  "Out[32]=",ExpressionUUID->"eb992813-5262-48e0-8375-e37f84c0f2c9"]
}, Open  ]],

Cell["Let us revert to the default color formatting", \
"Text",ExpressionUUID->"bb17021f-a626-4191-8a5d-002e4815dc04"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$FormatConformal", " ", "=", " ", "\"\<Color\>\""}], 
  ";"}]], "Input",
 CellLabel->
  "In[33]:=",ExpressionUUID->"28fc3c0c-5d38-4908-90cd-f5fd15db0c25"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Basic example", \
"Section",ExpressionUUID->"f446e965-57c7-4bf7-9584-fd3b310fd6cc"],

Cell[CellGroupData[{

Cell["Geodesic equation", \
"Subsubsection",ExpressionUUID->"53bbe4fe-82b9-40f9-8feb-3367b828a47f"],

Cell["Let us consider a null vector, hence we add the rule", \
"Text",ExpressionUUID->"53a5701a-ce69-4837-ab04-57c22c57a614"],

Cell[BoxData[
 RowBox[{"k", "/:", 
  RowBox[{
   RowBox[{"k", "[", 
    RowBox[{"-", "\[Alpha]_"}], "]"}], 
   RowBox[{"k", "[", "\[Alpha]_", "]"}]}], ":=", "0"}]], "Input",
 CellLabel->"In[34]:=",ExpressionUUID->"ca7dc363-7965-4652-8967-74feb1be49f4"],

Cell["\<\
The function which performs the conformal transformation is \
ConformalTransformation :\
\>", "Text",
 FontSize->14,ExpressionUUID->"99bac599-abc9-4c4c-96fd-cede678ce980"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "ConformalTransformation"}]], "Input",
 CellLabel->"In[35]:=",ExpressionUUID->"b3672da6-b2f2-4fdb-8be9-8cb05067b6de"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"ConformalTransformation[metric1,metric2][expr] \
performs a conformal transformation. More precisely it is a Weyl \
transformation, but we call it conformal transformation as in appendix D of \
Wald's book on General Relativity (1984)).\\n\\nThe expression 'expr' is \
transformed actively from the frame 'metric1' to the frame 'metric2'. \\nThe \
two metrics 'metric1' and 'metric2' have to be conformally related by \
DefConformalMetric. \\n\\nThe ConformalTransformationption FinalFrame is by \
default set to 'Automatic' and in that case all quantities in the result are \
expressed in the metric1 frame.\\nThe use can specifiy \
FinalFrame->targetframe, where targetframe is a metric name, to express the \
results in terms of quantities in the targetframe conformal frame. \\n\\nThe \
option ConformalTransformation->function allows to define the function used \
for simplification. By default it is set to 'SafeArrange' which is a custom \
function based on ToCanonical, but the user can decide to put Identity for \
instance to avoid loss of time in canonicalization.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[
           TagBox[GridBox[{
              {
               StyleBox[
                TagBox[
                 TooltipBox[
                  
                  StyleBox["\<\" SubValue Definitions\"\>", 
                   "InformationRowLabel",
                   StripOnInput->False],
                  "\"SubValues\"",
                  TooltipStyle->"TextStyling"],
                 Annotation[#, "SubValues", "Tooltip"]& ], "DialogStyle",
                StripOnInput->False]},
              {
               TemplateBox[{"\"\[ThinSpace]\"", 
                 GridBox[{{
                    RowBox[{
                    RowBox[{
                    RowBox[{"ConformalTransformation", "[", 
                    RowBox[{
                    
                    RowBox[{"xAct`xConf`Private`metricbase_", "?", 
                    "MetricQ"}], ",", 
                    
                    RowBox[{"xAct`xConf`Private`metrictarget_", "?", 
                    "MetricQ"}], ",", 
                    RowBox[{"xAct`xConf`Private`options", ":", 
                    RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], "[", 
                    "xAct`xConf`Private`expr_", "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"xAct`xConf`Private`Tometricinitialexpression", 
                    ",", "xAct`xConf`Private`transformedexpression", ",", 
                    "xAct`xConf`Private`finalframe", ",", 
                    "xAct`xConf`Private`simplification"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"xAct`xConf`Private`finalframe", ",", 
                    "xAct`xConf`Private`simplification"}], "}"}], "=", 
                    RowBox[{"OptionValue", "[", 
                    RowBox[{"{", 
                    RowBox[{"FinalFrame", ",", "SimplificationFunction"}], 
                    "}"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    
                    RowBox[{"xAct`xConf`Private`finalframe", "===", 
                    "Automatic"}], ",", 
                    RowBox[{
                    
                    RowBox[{"xAct`xConf`Private`finalframe", "=", 
                    "xAct`xConf`Private`metricbase"}], ";"}]}], "]"}], ";", 
                    RowBox[{"With", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"xAct`xConf`Private`firstmetric", "=", 
                    RowBox[{"First", "[", "$Metrics", "]"}]}], "}"}], ",", 
                    RowBox[{
                    
                    RowBox[{"xAct`xConf`Private`Tometricinitialexpression", 
                    "=", 
                    RowBox[{
                    RowBox[{"ToMetric", "[", 
                    RowBox[{"xAct`xConf`Private`metricbase", ",", 
                    
                    RowBox[{"SimplificationFunction", "\[Rule]", 
                    "xAct`xConf`Private`simplification"}]}], "]"}], "[", 
                    "xAct`xConf`Private`expr", "]"}]}], ";", 
                    RowBox[{"xAct`xConf`Private`transformedexpression", "=", 
                    RowBox[{
                    
                    RowBox[{"ConformalFrame", "[", 
                    "xAct`xConf`Private`metrictarget", "]"}], "[", 
                    "xAct`xConf`Private`Tometricinitialexpression", "]"}]}], 
                    ";", 
                    RowBox[{
                    RowBox[{"ToMetric", "[", 
                    RowBox[{"xAct`xConf`Private`finalframe", ",", 
                    
                    RowBox[{"SimplificationFunction", "\[Rule]", 
                    "xAct`xConf`Private`simplification"}]}], "]"}], "[", 
                    "xAct`xConf`Private`transformedexpression", "]"}]}]}], 
                    "]"}]}]}], "]"}]}]}, {" "}, {
                    RowBox[{
                    RowBox[{
                    RowBox[{"ConformalTransformation", "[", 
                    
                    RowBox[{
                    "xAct`xConf`Private`metrictarget_", "?", "MetricQ"}], 
                    "]"}], "[", "xAct`xConf`Private`expr_", "]"}], ":=", 
                    RowBox[{
                    RowBox[{"ConformalTransformation", "[", 
                    RowBox[{
                    RowBox[{"First", "[", "$Metrics", "]"}], ",", 
                    "xAct`xConf`Private`metrictarget"}], "]"}], "[", 
                    "xAct`xConf`Private`expr", "]"}]}]}, {" "}}, 
                  GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                  DefaultBaseStyle -> "Column", 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                "RowDefault"]}
             },
             DefaultBaseStyle->"Column",
             GridBoxAlignment->{"Columns" -> {{Left}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
            "Column"],
           FrameMargins->{{6, 0}, {3, 6}}], "\<\"\"\>"},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Options\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Options\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Options", "Tooltip"]& ], 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"FinalFrame", "\[Rule]", "Automatic"}], ",", 
                    RowBox[{
                    "SimplificationFunction", "\[Rule]", "SafeArrange"}]}], 
                    "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], \
"\<\"xAct`xConf`ConformalTransformation\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->{{6, 6}, {6, 3}}], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"ConformalTransformation[metric1,metric2][expr] \
performs a conformal transformation. More precisely it is a Weyl \
transformation, but we call it conformal transformation as in appendix D of \
Wald's book on General Relativity (1984)).\\n\\nThe expression 'expr' is \
transformed actively from the frame 'metric1' to the frame 'metric2'. \\nThe \
two metrics 'metric1' and 'metric2' have to be conformally related by \
DefConformalMetric. \\n\\nThe ConformalTransformationption FinalFrame is by \
default set to 'Automatic' and in that case all quantities in the result are \
expressed in the metric1 frame.\\nThe use can specifiy \
FinalFrame->targetframe, where targetframe is a metric name, to express the \
results in terms of quantities in the targetframe conformal frame. \\n\\nThe \
option ConformalTransformation->function allows to define the function used \
for simplification. By default it is set to 'SafeArrange' which is a custom \
function based on ToCanonical, but the user can decide to put Identity for \
instance to avoid loss of time in canonicalization.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "ConformalTransformation[metric1,metric2][expr] performs a conformal \
transformation. More precisely it is a Weyl transformation, but we call it \
conformal transformation as in appendix D of Wald's book on General \
Relativity (1984)).\n\nThe expression 'expr' is transformed actively from the \
frame 'metric1' to the frame 'metric2'. \nThe two metrics 'metric1' and \
'metric2' have to be conformally related by DefConformalMetric. \n\nThe \
ConformalTransformationption FinalFrame is by default set to 'Automatic' and \
in that case all quantities in the result are expressed in the metric1 frame.\
\nThe use can specifiy FinalFrame->targetframe, where targetframe is a metric \
name, to express the results in terms of quantities in the targetframe \
conformal frame. \n\nThe option ConformalTransformation->function allows to \
define the function used for simplification. By default it is set to \
'SafeArrange' which is a custom function based on ToCanonical, but the user \
can decide to put Identity for instance to avoid loss of time in \
canonicalization.", "Documentation" -> None, "OwnValues" -> None, "UpValues" -> 
    None, "DownValues" -> None, "SubValues" -> 
    Information`InformationValueForm[
     SubValues, xAct`xConf`ConformalTransformation, {
      xAct`xConf`ConformalTransformation[
         PatternTest[
          Pattern[xAct`xConf`Private`metricbase, 
           Blank[]], xAct`xTensor`MetricQ], 
         PatternTest[
          Pattern[xAct`xConf`Private`metrictarget, 
           Blank[]], xAct`xTensor`MetricQ], 
         Pattern[xAct`xConf`Private`options, 
          OptionsPattern[]]][
         Pattern[xAct`xConf`Private`expr, 
          Blank[]]] :> 
       Module[{xAct`xConf`Private`Tometricinitialexpression, 
          xAct`xConf`Private`transformedexpression, 
          xAct`xConf`Private`finalframe, 
          xAct`xConf`Private`simplification}, {
           xAct`xConf`Private`finalframe, xAct`xConf`Private`simplification} = 
          OptionValue[{
            xAct`xConf`FinalFrame, xAct`xConf`SimplificationFunction}]; 
         If[xAct`xConf`Private`finalframe === Automatic, 
           xAct`xConf`Private`finalframe = xAct`xConf`Private`metricbase; 
           Null]; With[{
           xAct`xConf`Private`firstmetric = First[xAct`xTensor`$Metrics]}, 
           xAct`xConf`Private`Tometricinitialexpression = 
            xAct`xConf`ToMetric[
             xAct`xConf`Private`metricbase, xAct`xConf`SimplificationFunction -> 
              xAct`xConf`Private`simplification][xAct`xConf`Private`expr]; 
           xAct`xConf`Private`transformedexpression = 
            xAct`xConf`ConformalFrame[xAct`xConf`Private`metrictarget][
             xAct`xConf`Private`Tometricinitialexpression]; 
           xAct`xConf`ToMetric[
            xAct`xConf`Private`finalframe, xAct`xConf`SimplificationFunction -> 
             xAct`xConf`Private`simplification][
            xAct`xConf`Private`transformedexpression]]], 
       xAct`xConf`ConformalTransformation[
         PatternTest[
          Pattern[xAct`xConf`Private`metrictarget, 
           Blank[]], xAct`xTensor`MetricQ]][
         Pattern[xAct`xConf`Private`expr, 
          Blank[]]] :> xAct`xConf`ConformalTransformation[
         First[xAct`xTensor`$Metrics], xAct`xConf`Private`metrictarget][
        xAct`xConf`Private`expr]}], "DefaultValues" -> None, "NValues" -> 
    None, "FormatValues" -> None, 
    "Options" -> {
     xAct`xConf`FinalFrame -> Automatic, xAct`xConf`SimplificationFunction -> 
      xAct`xConf`SafeArrange}, "Attributes" -> {}, "FullName" -> 
    "xAct`xConf`ConformalTransformation"|>, False]]], "Output",
 CellLabel->
  "Out[35]=",ExpressionUUID->"8e5e3dbc-96c6-43c6-a8a6-a2764faabf77"]
}, Open  ]],

Cell["\<\
So let us consider the conformal transformation from frame g to frame gS2 of \
the null geodesic equation. And check that it is conformally invariant.\
\>", "Text",ExpressionUUID->"5c05d5e9-294f-46bc-96e6-023868e0e8db"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ConformalTransformation", "[", 
   RowBox[{"g", ",", "gS2"}], "]"}], "[", 
  RowBox[{
   RowBox[{"k", "[", "\[Nu]", "]"}], 
   RowBox[{
    RowBox[{"CD", "[", 
     RowBox[{"-", "\[Nu]"}], "]"}], "[", 
    RowBox[{"k", "[", "\[Mu]", "]"}], "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"%", "//", "NoScalar"}], "//", "ContractMetric"}], "//", 
  "ToCanonical"}]}], "Input",
 CellLabel->"In[36]:=",ExpressionUUID->"461c0491-3d58-4da0-9a23-89276316c225"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCDCDgS2", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`ChristoffelCDCDgS2[$CellContext`\[Alpha], -$CellContext`\
\[Beta], -$CellContext`\[Gamma]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[36]:=",ExpressionUUID->"060d9eb6-959d-4ad8-a5b2-bf9fb3e175db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCDCDgs2", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`ChristoffelCDCDgs2[$CellContext`\[Alpha], -$CellContext`\
\[Beta], -$CellContext`\[Gamma]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[36]:=",ExpressionUUID->"e32d64c7-89fe-4912-b03d-2407f20487e4"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {"\[Mu]", "\[Nu]"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[$CellContext`\[Mu], $CellContext`\[Nu]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"g", 
              StyleBox[GridBox[{
                 {"\[Alpha]", "\[Beta]"},
                 {" ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->Rational[39, 4]]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"k", 
              StyleBox[GridBox[{
                 {" "},
                 {"\[Alpha]"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->Rational[39, 4]]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`k[-$CellContext`\[Alpha]],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"k", 
              StyleBox[GridBox[{
                 {" "},
                 {"\[Beta]"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->Rational[39, 4]]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`k[-$CellContext`\[Beta]],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`k[-$CellContext`\[Alpha]] $CellContext`k[-$CellContext`\
\[Beta]]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[Del]", "\[Nu]"], "S"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CD[-$CellContext`\[Nu]][
       $CellContext`S[]],
      Editable->False]}], 
    SuperscriptBox[
     InterpretationBox[
      StyleBox["S",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`S[],
      Editable->False], "5"]]}], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Mu]", "\[Sigma]$10237"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Mu], $CellContext`\[Sigma]$10237],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Sigma]$10238"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Sigma]$10238],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"k", 
         StyleBox[GridBox[{
            {" "},
            {"\[Nu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`k[-$CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Sigma]$10238"], GridBox[{
         {"k", 
          StyleBox[GridBox[{
             {" "},
             {"\[Sigma]$10237"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Sigma]$10238][
      $CellContext`k[-$CellContext`\[Sigma]$10237]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "4"]]}]], "Output",
 CellLabel->"Out[36]=",ExpressionUUID->"e91894fa-b3fa-4ecb-a74e-fc5a089f47a7"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"k", 
        StyleBox[GridBox[{
           {" "},
           {"\[Nu]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`k[-$CellContext`\[Nu]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[Del]", "\[Nu]"], GridBox[{
        {"k", 
         StyleBox[GridBox[{
            {"\[Mu]"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[$CellContext`\[Nu]][
     $CellContext`k[$CellContext`\[Mu]]],
    Editable->False]}], 
  SuperscriptBox[
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False], "4"]]], "Output",
 CellLabel->
  "Out[37]=",ExpressionUUID->"225dedbc-2b9c-469d-9851-678a74b5c7b1"]
}, Open  ]],

Cell["\<\
The option FinalFrame->value, where value is a metruc allows to specify in \
which frame (that is with variables in a given frame) we want to express the \
result. 
See more details below. In this following examples we express everything in \
terms of the first metric frame.\
\>", "Text",ExpressionUUID->"8d46040b-6cf5-4078-9ce1-3eb1ca7e12b7"],

Cell["\<\
What is more interesting is to transform from frame1 to frame2 and to express \
the result in frame1, which is the default behaviour when the frame of the \
result is not specified.
Contraction of the metric is not automatic so that the result is seen with \
all indices in their natural position.\
\>", "Text",ExpressionUUID->"6611d95d-8b10-4203-8ef4-975f771f6bcf"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ConformalTransformation", "[", 
   RowBox[{"g", ",", "gS2"}], "]"}], "[", 
  RowBox[{
   RowBox[{"CD", "[", 
    RowBox[{"-", "\[Nu]"}], "]"}], "[", 
   RowBox[{"k", "[", 
    RowBox[{"-", "\[Mu]"}], "]"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"%", "//", "NoScalar"}], "//", "ContractMetric"}], "//", 
  "ToCanonical"}]}], "Input",
 CellLabel->"In[38]:=",ExpressionUUID->"b04251ba-0657-406b-9d64-4c25408d70a0"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Mu]", "\[Nu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Mu], -$CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"k", 
             StyleBox[GridBox[{
                {" "},
                {"\[Alpha]"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`k[-$CellContext`\[Alpha]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Beta]"], "S"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Beta]][
          $CellContext`S[]],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`k[-$CellContext`\[Alpha]] \
$CellContext`CD[-$CellContext`\[Beta]][
        $CellContext`S[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"k", 
         StyleBox[GridBox[{
            {" "},
            {"\[Nu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`k[-$CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S[]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False]], "+", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[Del]", "\[Nu]"], GridBox[{
       {"k", 
        StyleBox[GridBox[{
           {" "},
           {"\[Mu]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`CD[-$CellContext`\[Nu]][
    $CellContext`k[-$CellContext`\[Mu]]],
   Editable->False], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"k", 
         StyleBox[GridBox[{
            {" "},
            {"\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`k[-$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Nu]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Nu]][
      $CellContext`S[]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False]]}]], "Output",
 CellLabel->"Out[38]=",ExpressionUUID->"8bca3195-51a5-4433-b542-98a1157ae8c5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"k", 
          StyleBox[GridBox[{
             {" "},
             {"\[Nu]"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`k[-$CellContext`\[Nu]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[Del]", "\[Mu]"], "S"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CD[-$CellContext`\[Mu]][
       $CellContext`S[]],
      Editable->False]}], 
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False]]}], "+", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[Del]", "\[Nu]"], GridBox[{
       {"k", 
        StyleBox[GridBox[{
           {" "},
           {"\[Mu]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`CD[-$CellContext`\[Nu]][
    $CellContext`k[-$CellContext`\[Mu]]],
   Editable->False], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"k", 
         StyleBox[GridBox[{
            {" "},
            {"\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`k[-$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Nu]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Nu]][
      $CellContext`S[]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Mu]", "\[Nu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Mu], -$CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"k", 
         StyleBox[GridBox[{
            {" "},
            {"\[Sigma]$10488"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`k[-$CellContext`\[Sigma]$10488],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Sigma]$10488"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Sigma]$10488][
      $CellContext`S[]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False]]}]], "Output",
 CellLabel->
  "Out[39]=",ExpressionUUID->"05116269-fcb2-465d-b314-06423b3a90b2"]
}, Open  ]],

Cell[TextData[StyleBox["The conformal transformation works in both directions \
and when we revert to the initial frame we recover the initial expression.",
 FontSize->16]], "Text",
 FontSize->7,ExpressionUUID->"3d7e62e5-2b5e-4d6d-896d-cdaad8de1ddc"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ConformalTransformation", "[", 
   RowBox[{"g", ",", "gS2", ",", 
    RowBox[{"FinalFrame", "->", "g"}]}], "]"}], "[", 
  RowBox[{
   RowBox[{"CD", "[", 
    RowBox[{"-", "\[Nu]"}], "]"}], "[", 
   RowBox[{"k", "[", 
    RowBox[{"-", "\[Mu]"}], "]"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ConformalTransformation", "[", 
    RowBox[{"gS2", ",", "g", ",", 
     RowBox[{"FinalFrame", "->", "g"}]}], "]"}], "[", "%", "]"}], "//", 
  "ToCanonical"}]}], "Input",
 CellLabel->"In[40]:=",ExpressionUUID->"7aee1189-b9c2-438b-a29d-f77469f34154"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Mu]", "\[Nu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Mu], -$CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"k", 
             StyleBox[GridBox[{
                {" "},
                {"\[Alpha]"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`k[-$CellContext`\[Alpha]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Beta]"], "S"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Beta]][
          $CellContext`S[]],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`k[-$CellContext`\[Alpha]] \
$CellContext`CD[-$CellContext`\[Beta]][
        $CellContext`S[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"k", 
         StyleBox[GridBox[{
            {" "},
            {"\[Nu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`k[-$CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S[]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False]], "+", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[Del]", "\[Nu]"], GridBox[{
       {"k", 
        StyleBox[GridBox[{
           {" "},
           {"\[Mu]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`CD[-$CellContext`\[Nu]][
    $CellContext`k[-$CellContext`\[Mu]]],
   Editable->False], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"k", 
         StyleBox[GridBox[{
            {" "},
            {"\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`k[-$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Nu]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Nu]][
      $CellContext`S[]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False]]}]], "Output",
 CellLabel->"Out[40]=",ExpressionUUID->"1c9ddb3c-4315-41c2-94b6-76a6fcde222d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCDgs2CDgS2", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`ChristoffelCDgs2CDgS2[$CellContext`\[Alpha], -$CellContext`\
\[Beta], -$CellContext`\[Gamma]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[40]:=",ExpressionUUID->"17b90384-4a1a-495c-a377-3d1911042f9b"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubscriptBox["\[Del]", "\[Nu]"], GridBox[{
      {"k", 
       StyleBox[GridBox[{
          {" "},
          {"\[Mu]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`CD[-$CellContext`\[Nu]][
   $CellContext`k[-$CellContext`\[Mu]]],
  Editable->False]], "Output",
 CellLabel->
  "Out[41]=",ExpressionUUID->"0fba29fd-8369-4bef-99bd-37ff4dc5d7ea"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ConformalTransformation", "[", 
   RowBox[{"g", ",", "gS2", ",", 
    RowBox[{"FinalFrame", "->", "g"}]}], "]"}], "[", 
  RowBox[{
   RowBox[{"CD", "[", "\[Nu]", "]"}], "[", 
   RowBox[{"k", "[", "\[Mu]", "]"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ConformalTransformation", "[", 
    RowBox[{"gS2", ",", "gs2", ",", 
     RowBox[{"FinalFrame", "->", "g"}]}], "]"}], "[", "%", "]"}], "//", 
  "ToCanonical"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ConformalTransformation", "[", 
     RowBox[{"gs2", ",", "g", ",", 
      RowBox[{"FinalFrame", "->", "g"}]}], "]"}], "[", "%", "]"}], "//", 
   "ContractMetric"}], "//", "ToCanonical"}]}], "Input",
 CellLabel->"In[42]:=",ExpressionUUID->"f1fcb493-0d0f-47ed-9d53-c132c5ef15d7"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Mu]", "\[Nu]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Mu], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"k", 
             StyleBox[GridBox[{
                {" "},
                {"\[Alpha]"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`k[-$CellContext`\[Alpha]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Beta]"], "S"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Beta]][
          $CellContext`S[]],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`k[-$CellContext`\[Alpha]] \
$CellContext`CD[-$CellContext`\[Beta]][
        $CellContext`S[]]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "5"]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Mu]", "\[Sigma]$10743"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Mu], $CellContext`\[Sigma]$10743],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Sigma]$10747"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Sigma]$10747],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Sigma]$10747"], GridBox[{
         {"k", 
          StyleBox[GridBox[{
             {" "},
             {"\[Sigma]$10743"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Sigma]$10747][
      $CellContext`k[-$CellContext`\[Sigma]$10743]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "4"]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Mu]", "\[Sigma]$10747"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Mu], $CellContext`\[Sigma]$10747],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Sigma]$10743"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Sigma]$10743],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"k", 
         StyleBox[GridBox[{
            {" "},
            {"\[Sigma]$10743"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`k[-$CellContext`\[Sigma]$10743],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Sigma]$10747"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Sigma]$10747][
      $CellContext`S[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "5"]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Mu]", "\[Sigma]$10743"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Mu], $CellContext`\[Sigma]$10743],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Sigma]$10747"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Sigma]$10747],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"k", 
         StyleBox[GridBox[{
            {" "},
            {"\[Sigma]$10743"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`k[-$CellContext`\[Sigma]$10743],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Sigma]$10747"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Sigma]$10747][
      $CellContext`S[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "5"]]}]], "Output",
 CellLabel->"Out[42]=",ExpressionUUID->"019b544f-f833-4955-9cd4-f69cf0a50a6c"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Mu]", "\[Nu]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Mu], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"k", 
             StyleBox[GridBox[{
                {" "},
                {"\[Alpha]"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`k[-$CellContext`\[Alpha]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Beta]"], "s"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Beta]][
          $CellContext`s[]],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`k[-$CellContext`\[Alpha]] \
$CellContext`CD[-$CellContext`\[Beta]][
        $CellContext`s[]]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["s",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`s[],
     Editable->False], "5"]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Mu]", "\[Sigma]$10743"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Mu], $CellContext`\[Sigma]$10743],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Sigma]$10747"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Sigma]$10747],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Sigma]$10747"], GridBox[{
         {"k", 
          StyleBox[GridBox[{
             {" "},
             {"\[Sigma]$10743"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Sigma]$10747][
      $CellContext`k[-$CellContext`\[Sigma]$10743]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["s",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`s[],
     Editable->False], "4"]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Mu]", "\[Sigma]$10747"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Mu], $CellContext`\[Sigma]$10747],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Sigma]$10743"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Sigma]$10743],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"k", 
         StyleBox[GridBox[{
            {" "},
            {"\[Sigma]$10743"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`k[-$CellContext`\[Sigma]$10743],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Sigma]$10747"], "s"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Sigma]$10747][
      $CellContext`s[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["s",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`s[],
     Editable->False], "5"]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Mu]", "\[Sigma]$10743"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Mu], $CellContext`\[Sigma]$10743],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Sigma]$10747"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Sigma]$10747],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"k", 
         StyleBox[GridBox[{
            {" "},
            {"\[Sigma]$10743"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`k[-$CellContext`\[Sigma]$10743],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Sigma]$10747"], "s"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Sigma]$10747][
      $CellContext`s[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["s",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`s[],
     Editable->False], "5"]]}]], "Output",
 CellLabel->"Out[43]=",ExpressionUUID->"20197058-9e1d-49bf-808b-b553b93ac84d"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SuperscriptBox["\[Del]", "\[Nu]"], GridBox[{
      {"k", 
       StyleBox[GridBox[{
          {"\[Mu]"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`CD[$CellContext`\[Nu]][
   $CellContext`k[$CellContext`\[Mu]]],
  Editable->False]], "Output",
 CellLabel->
  "Out[44]=",ExpressionUUID->"07b1d452-c484-482a-831b-97ac1416d7b0"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Riemann tensor transformation (and Ricci tensor)", \
"Section",ExpressionUUID->"8c797f10-f3ce-4560-8a35-0fe8656fc95c"],

Cell["\<\
This reproduces expressions D7 D8 and D9 in Walds\[CloseCurlyQuote] book \
(1984) on General Relativity.
See dedicated example notebook to have it expressed exactly like in the book, \
and in any dimension.\
\>", "Text",ExpressionUUID->"9d1d8071-931e-46aa-9276-1e2ab506b262"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ConformalTransformation", "[", 
   RowBox[{"g", ",", "gS2"}], "]"}], "[", 
  RowBox[{"RiemannCD", "[", 
   RowBox[{
    RowBox[{"-", "\[Mu]"}], ",", 
    RowBox[{"-", "\[Nu]"}], ",", 
    RowBox[{"-", "\[Alpha]"}], ",", "\[Beta]"}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"%", "//", "NoScalar"}], "//", "ContractMetric"}], "//", 
  "ToCanonical"}]}], "Input",
 CellLabel->"In[45]:=",ExpressionUUID->"5e037108-5b78-4b82-9c16-5674bad482e1"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"\[Beta]", "\[Sigma]$11212"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[$CellContext`\[Beta], $CellContext`\[Sigma]$11212],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"\[Nu]", "\[Sigma]$11250"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`\[Nu], -$CellContext`\[Sigma]$11250],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"R", "[", "\[Del]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", "\[Sigma]$11250"},
           {"\[Alpha]", "\[Sigma]$11212", "\[Mu]", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RiemannCD[-$CellContext`\[Alpha], \
-$CellContext`\[Sigma]$11212, -$CellContext`\[Mu], \
$CellContext`\[Sigma]$11250],
    Editable->False]}], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {"\[Beta]", " "},
            {" ", "\[Nu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[$CellContext`\[Beta], -$CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Alpha]][
          $CellContext`S[]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Beta]"], "S"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Beta]][
          $CellContext`S[]],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
        $CellContext`S[]] $CellContext`CD[-$CellContext`\[Beta]][
        $CellContext`S[]]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {"\[Beta]", " "},
            {" ", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Nu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Alpha]][
          $CellContext`S[]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Beta]"], "S"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Beta]][
          $CellContext`S[]],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
        $CellContext`S[]] $CellContext`CD[-$CellContext`\[Beta]][
        $CellContext`S[]]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {"\[Beta]", " "},
            {" ", "\[Nu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[$CellContext`\[Beta], -$CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "2"]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {"\[Beta]", " "},
            {" ", "\[Nu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[$CellContext`\[Beta], -$CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], 
       SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`CD[-$CellContext`\[Alpha]][
       $CellContext`S[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {"\[Beta]", " "},
            {" ", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Nu]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Nu]][
      $CellContext`S[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {"\[Beta]", " "},
            {" ", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Nu]"], 
       SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Nu]][
      $CellContext`CD[-$CellContext`\[Alpha]][
       $CellContext`S[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Nu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Beta]", "\[Sigma]$11212"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Beta], $CellContext`\[Sigma]$11212],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Sigma]$11212"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Sigma]$11212][
      $CellContext`S[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Beta]", "\[Sigma]$11212"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Beta], $CellContext`\[Sigma]$11212],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Nu]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Nu]][
      $CellContext`S[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Sigma]$11212"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Sigma]$11212][
      $CellContext`S[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Nu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Beta]", "\[Sigma]$11212"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Beta], $CellContext`\[Sigma]$11212],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Sigma]$11212"], 
       SubscriptBox["\[Del]", "\[Mu]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Sigma]$11212][
      $CellContext`CD[-$CellContext`\[Mu]][
       $CellContext`S[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Beta]", "\[Sigma]$11212"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Beta], $CellContext`\[Sigma]$11212],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Sigma]$11212"], 
       SubscriptBox["\[Del]", "\[Nu]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Sigma]$11212][
      $CellContext`CD[-$CellContext`\[Nu]][
       $CellContext`S[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False]]}]], "Output",
 CellLabel->"Out[45]=",ExpressionUUID->"42d84c11-2e53-45b2-9f02-8f37ac74b05a"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"R", "[", "\[Del]", "]"}], 
       StyleBox[GridBox[{
          {" ", "\[Beta]", " ", " "},
          {"\[Alpha]", " ", "\[Mu]", "\[Nu]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`RiemannCD[-$CellContext`\[Alpha], $CellContext`\[Beta], \
-$CellContext`\[Mu], -$CellContext`\[Nu]],
   Editable->False], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {"\[Beta]", " "},
            {" ", "\[Nu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[$CellContext`\[Beta], -$CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "2"]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Nu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Beta]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Beta]][
      $CellContext`S[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "2"]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {"\[Beta]", " "},
            {" ", "\[Nu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[$CellContext`\[Beta], -$CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], 
       SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`CD[-$CellContext`\[Alpha]][
       $CellContext`S[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Nu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], 
       SuperscriptBox["\[Del]", "\[Beta]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`CD[$CellContext`\[Beta]][
       $CellContext`S[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {"\[Beta]", " "},
            {" ", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Nu]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Nu]][
      $CellContext`S[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Beta]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Beta]][
      $CellContext`S[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Nu]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Nu]][
      $CellContext`S[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {"\[Beta]", " "},
            {" ", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Nu]"], 
       SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Nu]][
      $CellContext`CD[-$CellContext`\[Alpha]][
       $CellContext`S[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Nu]"], 
       SuperscriptBox["\[Del]", "\[Beta]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Nu]][
      $CellContext`CD[$CellContext`\[Beta]][
       $CellContext`S[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {"\[Beta]", " "},
            {" ", "\[Nu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[$CellContext`\[Beta], -$CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Sigma]$11409"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Sigma]$11409][
      $CellContext`S[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Sigma]$11409"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Sigma]$11409][
      $CellContext`S[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {"\[Beta]", " "},
            {" ", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Nu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Sigma]$11409"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Sigma]$11409][
      $CellContext`S[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Sigma]$11409"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Sigma]$11409][
      $CellContext`S[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "2"]]}]], "Output",
 CellLabel->
  "Out[46]=",ExpressionUUID->"7b0de63d-e863-4120-9fe1-ef1f2fa3f890"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"ConformalTransformation", "[", 
      RowBox[{"g", ",", "gS2"}], "]"}], "[", 
     RowBox[{"RicciCD", "[", 
      RowBox[{
       RowBox[{"-", "\[Mu]"}], ",", 
       RowBox[{"-", "\[Nu]"}]}], "]"}], "]"}], "//", "NoScalar"}], "//", 
   "ContractMetric"}], "//", "ToCanonical"}]], "Input",
 CellLabel->"In[47]:=",ExpressionUUID->"822e6f8f-6f1d-4dab-90b2-013a11b7ad4d"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"R", "[", "\[Del]", "]"}], 
       StyleBox[GridBox[{
          {" ", " "},
          {"\[Mu]", "\[Nu]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`RicciCD[-$CellContext`\[Mu], -$CellContext`\[Nu]],
   Editable->False], "+", 
  FractionBox[
   RowBox[{"4", " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Nu]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Nu]][
      $CellContext`S[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "2"]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Nu]"], 
       SubscriptBox["\[Del]", "\[Mu]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Nu]][
      $CellContext`CD[-$CellContext`\[Mu]][
       $CellContext`S[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Mu]", "\[Nu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Mu], -$CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Sigma]$11669"], 
       SuperscriptBox["\[Del]", "\[Sigma]$11669"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Sigma]$11669][
      $CellContext`CD[$CellContext`\[Sigma]$11669][
       $CellContext`S[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Mu]", "\[Nu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Mu], -$CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Sigma]$11669"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Sigma]$11669][
      $CellContext`S[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Sigma]$11669"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Sigma]$11669][
      $CellContext`S[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "2"]]}]], "Output",
 CellLabel->
  "Out[47]=",ExpressionUUID->"adc43865-67d5-447c-8165-845ae9535641"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"ConformalTransformation", "[", 
      RowBox[{"g", ",", "gS2"}], "]"}], "[", 
     RowBox[{"RicciScalarCD", "[", "]"}], "]"}], "//", "NoScalar"}], "//", 
   "ContractMetric"}], "//", "ToCanonical"}]], "Input",
 CellLabel->"In[48]:=",ExpressionUUID->"081287e0-67d7-40da-baa5-75d4575d8653"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   InterpretationBox[
    StyleBox[
     RowBox[{"R", "[", "\[Del]", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciScalarCD[],
    Editable->False], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "2"]], "-", 
  FractionBox[
   RowBox[{"6", " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Sigma]$11922"], 
       SuperscriptBox["\[Del]", "\[Sigma]$11922"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Sigma]$11922][
      $CellContext`CD[$CellContext`\[Sigma]$11922][
       $CellContext`S[]]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "3"]]}]], "Output",
 CellLabel->
  "Out[48]=",ExpressionUUID->"3979b853-3df5-4f62-8aac-8cb39306bc0d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Weyl tensor transformation", \
"Section",ExpressionUUID->"d065d43d-18e6-4c92-b697-9a1c700245ca"],

Cell["\<\
Finally we check that the behaviour makes sense for the Weyl tensor (it must \
be invariant):\
\>", "Text",ExpressionUUID->"841ee135-cdd5-4ea6-a778-7c0aeaf73686"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ConformalTransformation", "[", 
   RowBox[{"g", ",", "gS2"}], "]"}], "[", 
  RowBox[{"WeylCD", "[", 
   RowBox[{
    RowBox[{"-", "\[Mu]"}], ",", 
    RowBox[{"-", "\[Nu]"}], ",", 
    RowBox[{"-", "\[Alpha]"}], ",", "\[Beta]"}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"%", "//", "RiemannToWeyl"}], "//", "ToCanonical"}]}], "Input",
 CellLabel->"In[49]:=",ExpressionUUID->"4c5a3617-7874-4279-9d00-451bf7299c48"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Delta]", 
        StyleBox[GridBox[{
           {"\[Beta]", " "},
           {" ", "\[Nu]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`delta[$CellContext`\[Beta], -$CellContext`\[Nu]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"R", "[", "\[Del]", "]"}], 
        StyleBox[GridBox[{
           {" ", " "},
           {"\[Alpha]", "\[Mu]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Delta]", 
        StyleBox[GridBox[{
           {"\[Beta]", " "},
           {" ", "\[Mu]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`delta[$CellContext`\[Beta], -$CellContext`\[Mu]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"R", "[", "\[Del]", "]"}], 
        StyleBox[GridBox[{
           {" ", " "},
           {"\[Alpha]", "\[Nu]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`\[Alpha], -$CellContext`\[Nu]],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"\[Alpha]", "\[Nu]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Nu]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"\[Beta]", "\[Sigma]$11938"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[$CellContext`\[Beta], $CellContext`\[Sigma]$11938],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"R", "[", "\[Del]", "]"}], 
        StyleBox[GridBox[{
           {" ", " "},
           {"\[Mu]", "\[Sigma]$11938"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`\[Mu], -$CellContext`\[Sigma]$11938],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"\[Alpha]", "\[Mu]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"\[Beta]", "\[Sigma]$11938"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[$CellContext`\[Beta], $CellContext`\[Sigma]$11938],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"R", "[", "\[Del]", "]"}], 
        StyleBox[GridBox[{
           {" ", " "},
           {"\[Nu]", "\[Sigma]$11938"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`\[Nu], -$CellContext`\[Sigma]$11938],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "6"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Delta]", 
        StyleBox[GridBox[{
           {"\[Beta]", " "},
           {" ", "\[Nu]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`delta[$CellContext`\[Beta], -$CellContext`\[Nu]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"\[Alpha]", "\[Mu]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"R", "[", "\[Del]", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciScalarCD[],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "6"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Delta]", 
        StyleBox[GridBox[{
           {"\[Beta]", " "},
           {" ", "\[Mu]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`delta[$CellContext`\[Beta], -$CellContext`\[Mu]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"\[Alpha]", "\[Nu]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Nu]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"R", "[", "\[Del]", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciScalarCD[],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"\[Beta]", "\[Sigma]$11938"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[$CellContext`\[Beta], $CellContext`\[Sigma]$11938],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"\[Nu]", "\[Sigma]$12002"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`\[Nu], -$CellContext`\[Sigma]$12002],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"R", "[", "\[Del]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", "\[Sigma]$12002"},
           {"\[Alpha]", "\[Sigma]$11938", "\[Mu]", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RiemannCD[-$CellContext`\[Alpha], \
-$CellContext`\[Sigma]$11938, -$CellContext`\[Mu], \
$CellContext`\[Sigma]$12002],
    Editable->False]}]}]], "Output",
 CellLabel->"Out[49]=",ExpressionUUID->"d9fd95f8-92d0-458f-8205-037a43a66c25"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Delta]", 
        StyleBox[GridBox[{
           {"\[Beta]", " "},
           {" ", "\[Mu]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`delta[$CellContext`\[Beta], -$CellContext`\[Mu]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"R", "[", "\[Del]", "]"}], 
        StyleBox[GridBox[{
           {" ", " "},
           {"\[Alpha]", "\[Nu]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`\[Alpha], -$CellContext`\[Nu]],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Delta]", 
        StyleBox[GridBox[{
           {"\[Beta]", " "},
           {" ", "\[Mu]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`delta[$CellContext`\[Beta], -$CellContext`\[Mu]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"\[Nu]", "\[Sigma]$11938"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`\[Nu], -$CellContext`\[Sigma]$11938],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"R", "[", "\[Del]", "]"}], 
        StyleBox[GridBox[{
           {" ", "\[Sigma]$11938"},
           {"\[Alpha]", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`\[Alpha], $CellContext`\[Sigma]$11938],
    
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"\[Alpha]", "\[Mu]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"\[Beta]", "\[Sigma]$11938"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[$CellContext`\[Beta], $CellContext`\[Sigma]$11938],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"R", "[", "\[Del]", "]"}], 
        StyleBox[GridBox[{
           {" ", " "},
           {"\[Nu]", "\[Sigma]$11938"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`\[Nu], -$CellContext`\[Sigma]$11938],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"\[Alpha]", "\[Mu]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"\[Beta]", "\[Sigma]$11938"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[$CellContext`\[Beta], $CellContext`\[Sigma]$11938],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"\[Nu]", "\[Sigma]$12002"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`\[Nu], -$CellContext`\[Sigma]$12002],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"R", "[", "\[Del]", "]"}], 
        StyleBox[GridBox[{
           {" ", "\[Sigma]$12002"},
           {"\[Sigma]$11938", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`\[Sigma]$11938, \
$CellContext`\[Sigma]$12002],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"\[Beta]", "\[Sigma]$11938"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[$CellContext`\[Beta], $CellContext`\[Sigma]$11938],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"\[Nu]", "\[Sigma]$12002"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`\[Nu], -$CellContext`\[Sigma]$12002],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"W", "[", "\[Del]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", "\[Sigma]$12002"},
           {"\[Alpha]", "\[Sigma]$11938", "\[Mu]", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`WeylCD[-$CellContext`\[Alpha], -$CellContext`\[Sigma]$11938, \
-$CellContext`\[Mu], $CellContext`\[Sigma]$12002],
    Editable->False]}]}]], "Output",
 CellLabel->
  "Out[50]=",ExpressionUUID->"7a4fab16-b40d-4d0c-9c58-25e4811c3bf9"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Determinant and Levi-Civita tensor", \
"Section",ExpressionUUID->"cfdaa2d4-2cef-458e-9834-195d07e79b2a"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ConformalTransformation", "[", 
   RowBox[{"g", ",", "gS2"}], "]"}], "[", 
  RowBox[{
   RowBox[{"Determinant", "[", "g", "]"}], "[", "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ConformalTransformation", "[", 
   RowBox[{"gS2", ",", "g"}], "]"}], "[", 
  RowBox[{
   RowBox[{"Determinant", "[", "gS2", "]"}], "[", "]"}], "]"}]}], "Input",
 CellLabel->"In[51]:=",ExpressionUUID->"1eb8a395-b0ae-4ba0-9d56-66bd74b4cfd8"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    OverscriptBox["g", 
     OverscriptBox[
      StyleBox["~",
       FontColor->RGBColor[0, 0, 0]], 
      StyleBox["~",
       FontColor->RGBColor[0, 0, 0]]]],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`Detg[],
   Editable->False], " ", 
  SuperscriptBox[
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False], "8"]}]], "Output",
 CellLabel->"Out[51]=",ExpressionUUID->"1c881799-ed2f-43a0-b1d4-23577242b9fc"],

Cell[BoxData[
 FractionBox[
  InterpretationBox[
   StyleBox[
    OverscriptBox[
     RowBox[{"[", 
      RowBox[{"g", 
       SuperscriptBox["S", "2"]}], "]"}], 
     OverscriptBox[
      StyleBox["~",
       FontColor->RGBColor[0, 0, 0]], 
      StyleBox["~",
       FontColor->RGBColor[0, 0, 0]]]],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`DetgS2[],
   Editable->False], 
  SuperscriptBox[
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False], "8"]]], "Output",
 CellLabel->
  "Out[52]=",ExpressionUUID->"bec95bb7-585c-4521-a78e-0aecb11374e5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ConformalTransformation", "[", 
    RowBox[{"g", ",", "gS2"}], "]"}], "[", 
   RowBox[{"epsilong", "[", 
    RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Mu]", ",", "\[Nu]"}], "]"}], 
   "]"}], "//", "ContractMetric"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ConformalTransformation", "[", 
    RowBox[{"g", ",", "gS2"}], "]"}], "[", 
   RowBox[{"epsilong", "[", 
    RowBox[{"\[Alpha]", ",", "\[Beta]", ",", 
     RowBox[{"-", "\[Mu]"}], ",", 
     RowBox[{"-", "\[Nu]"}]}], "]"}], "]"}], "//", 
  "ContractMetric"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ConformalTransformation", "[", 
    RowBox[{"g", ",", "gS2"}], "]"}], "[", 
   RowBox[{"epsilong", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Mu]"}], ",", 
     RowBox[{"-", "\[Nu]"}]}], "]"}], "]"}], "//", 
  "ContractMetric"}]}], "Input",
 CellLabel->"In[53]:=",ExpressionUUID->"2790928b-b40e-4253-8325-ba66abf111e7"],

Cell[BoxData[
 FractionBox[
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Epsilon]g", 
       StyleBox[GridBox[{
          {"\[Alpha]", "\[Beta]", "\[Mu]", "\[Nu]"},
          {" ", " ", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`epsilong[$CellContext`\[Alpha], $CellContext`\[Beta], \
$CellContext`\[Mu], $CellContext`\[Nu]],
   Editable->False], 
  SuperscriptBox[
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False], "4"]]], "Output",
 CellLabel->"Out[53]=",ExpressionUUID->"48fb26ef-8fb2-4ecb-bf6e-ae3a7ba0fc5d"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"\[Epsilon]g", 
      StyleBox[GridBox[{
         {" ", " ", "\[Alpha]", "\[Beta]"},
         {"\[Mu]", "\[Nu]", " ", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`epsilong[-$CellContext`\[Mu], -$CellContext`\[Nu], \
$CellContext`\[Alpha], $CellContext`\[Beta]],
  Editable->False]], "Output",
 CellLabel->"Out[54]=",ExpressionUUID->"496a34f1-16c7-4610-b503-79845e3197f5"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Epsilon]g", 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"\[Alpha]", "\[Beta]", "\[Mu]", "\[Nu]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`epsilong[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Mu], -$CellContext`\[Nu]],
   Editable->False], " ", 
  SuperscriptBox[
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False], "4"]}]], "Output",
 CellLabel->
  "Out[55]=",ExpressionUUID->"d1d913d9-a3bc-430c-beeb-b04bbc625a1b"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Details on xConf", \
"Chapter",ExpressionUUID->"ff2b4d67-2c37-4f02-87c5-2c1be19ebcb4"],

Cell[CellGroupData[{

Cell["Passive transformations", \
"Section",ExpressionUUID->"57e31211-1323-41e9-a68b-91ac1144e1b7"],

Cell["\<\
We now detail of ConformalTransformation works internally. 
It relies on the use of ToMetric[metric][expr], which expresses a given \
expression (of the form tensor[inds]) in terms of conformally transformed \
tensors.
This is a passive conformal transformation point of view. ToMetric[frame] is \
equivalent to ConformalTransformation[frame][g, g]\
\>", "Text",ExpressionUUID->"d399d484-bbaa-4e43-aa6f-e9ffa1e1e0a3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "ToMetric"}]], "Input",
 CellLabel->"In[56]:=",ExpressionUUID->"dfac5fb6-38c4-42d7-98f3-35451faf9bd1"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"ToMetric[metric,SimplificationFunction->function][\
expr] formulates 'expr' in terms of conformal frame 'metric', and its \
associated covariant derivative and curvature tensors. It is a passive \
transformation. The optional SimplificationFunction option sets the function \
which simpmlifies the final result. \\n\\n The option \
ConformalTransformation->function allows to define the function used for \
simplification. By default it is set to 'SafeArrange' which is a custom \
function based on ToCanonical, but the user can decide to put Identity for \
instance to avoid loss of time in canonicalization.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[
           TagBox[GridBox[{
              {
               StyleBox[
                TagBox[
                 TooltipBox[
                  
                  StyleBox["\<\" SubValue Definitions\"\>", 
                   "InformationRowLabel",
                   StripOnInput->False],
                  "\"SubValues\"",
                  TooltipStyle->"TextStyling"],
                 Annotation[#, "SubValues", "Tooltip"]& ], "DialogStyle",
                StripOnInput->False]},
              {
               TemplateBox[{"\"\[ThinSpace]\"", 
                 GridBox[{{
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToMetric", "[", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`metric1_", "?", "MetricQ"}], 
                    ",", 
                    RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], "[", 
                    "xAct`xConf`Private`expr_", "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"xAct`xConf`Private`res1", ",", 
                    "xAct`xConf`Private`res2", ",", "xAct`xConf`Private`res3",
                     ",", "xAct`xConf`Private`res4", ",", 
                    "xAct`xConf`Private`res5", ",", "xAct`xConf`Private`res6",
                     ",", "xAct`xConf`Private`res7", ",", 
                    "xAct`xConf`Private`res8", ",", "xAct`xConf`Private`res9",
                     ",", "xAct`xConf`Private`res10", ",", 
                    "xAct`xConf`Private`res11", ",", 
                    "xAct`xConf`Private`$CovDsRelatedTocd1"}], "}"}], ",", 
                    RowBox[{"With", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`cd1", "=", 
                    
                    RowBox[{"CovDOfMetric", "[", "xAct`xConf`Private`metric1",
                     "]"}]}], ",", 
                    RowBox[{"xAct`xConf`Private`M", "=", 
                    RowBox[{"ManifoldOfCovD", "[", 
                    
                    RowBox[{"CovDOfMetric", "[", "xAct`xConf`Private`metric1",
                     "]"}], "]"}]}], ",", 
                    RowBox[{"xAct`xConf`Private`metricsrelatedtocd1", "=", 
                    RowBox[{"Select", "[", 
                    RowBox[{"$Metrics", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ConformalRules", "[", 
                    RowBox[{"xAct`xConf`Private`metric1", ",", "#1"}], "]"}], 
                    "=!=", 
                    RowBox[{"{", "}"}]}], "&"}]}], "]"}]}], ",", 
                    RowBox[{"xAct`xConf`Private`firstmetric", "=", 
                    RowBox[{"First", "[", "$Metrics", "]"}]}]}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`$CovDsRelatedTocd1", "=", 
                    
                    RowBox[{"CovDOfMetric", "/@", 
                    "xAct`xConf`Private`metricsrelatedtocd1"}]}], ";", 
                    RowBox[{"xAct`xConf`Private`res1", "=", 
                    RowBox[{
                    RowBox[{"SeparateMetric", "[", "]"}], "[", 
                    RowBox[{"WeylToRiemann", "[", 
                    
                    RowBox[{"EinsteinToRicci", "[", "xAct`xConf`Private`expr",
                     "]"}], "]"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"$Debug", ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    RowBox[{"\"res1 = \"", ",", "xAct`xConf`Private`res1"}], 
                    "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"xAct`xConf`Private`res2", "=", 
                    
                    RowBox[{"xAct`xConf`Private`res1", "/.", 
                    "\[VeryThinSpace]", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"xAct`xConf`Private`tens_", "?", 
                    "TensorNotMetricRelated"}], "[", 
                    "xAct`xConf`Private`inds___", "]"}], "\[RuleDelayed]", 
                    RowBox[{
                    
                    RowBox[{"ConformalFrame", "[", 
                    "xAct`xConf`Private`firstmetric", "]"}], "[", 
                    
                    RowBox[{"xAct`xConf`Private`tens", "[", 
                    "xAct`xConf`Private`inds", "]"}], "]"}]}]}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"$Debug", ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    RowBox[{"\"res2  = \"", ",", "xAct`xConf`Private`res2"}], 
                    "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"xAct`xConf`Private`res3", "=", 
                    
                    RowBox[{"xAct`xConf`Private`res2", "/.", 
                    "\[VeryThinSpace]", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ConformalFrame", "[", 
                    RowBox[{"xAct`xConf`Private`frame_", "?", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"#1", "=!=", "xAct`xConf`Private`metric1"}], "&&", 
                    RowBox[{"MetricQ", "[", "#1", "]"}]}], "&"}], ")"}]}], 
                    "]"}], "[", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`tens_", "?", "xTensorQ"}], 
                    "[", "xAct`xConf`Private`inds___", "]"}], "]"}], 
                    "\[RuleDelayed]", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{"SqrtConformalFactor", "[", 
                    
                    RowBox[{"xAct`xConf`Private`frame", ",", 
                    "xAct`xConf`Private`metric1"}], "]"}], 
                    RowBox[{"ConformalWeight", "[", 
                    
                    RowBox[{"xAct`xConf`Private`tens", "[", 
                    "xAct`xConf`Private`inds", "]"}], "]"}]], " ", 
                    RowBox[{
                    
                    RowBox[{"ConformalFrame", "[", 
                    "xAct`xConf`Private`metric1", "]"}], "[", 
                    
                    RowBox[{"xAct`xConf`Private`tens", "[", 
                    "xAct`xConf`Private`inds", "]"}], "]"}]}]}]}]}], ";", 
                    RowBox[{"xAct`xConf`Private`res4", "=", 
                    
                    RowBox[{"xAct`xConf`Private`res3", "/.", 
                    "\[VeryThinSpace]", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"ConformalFrame", "[", 
                    "xAct`xConf`Private`firstmetric", "]"}], "[", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`tens_", "?", "xTensorQ"}], 
                    "[", "xAct`xConf`Private`inds___", "]"}], "]"}], 
                    "\[RuleDelayed]", 
                    
                    RowBox[{"xAct`xConf`Private`tens", "[", 
                    "xAct`xConf`Private`inds", "]"}]}]}]}], ";", 
                    RowBox[{"xAct`xConf`Private`res5", "=", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ChangeCurvature", "[", 
                    
                    RowBox[{"#1", ",", "$CovDs", ",", 
                    "xAct`xConf`Private`cd1"}], "]"}], "&"}], ")"}], "[", 
                    "xAct`xConf`Private`res4", "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"$Debug", ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    RowBox[{"\"res5 = \"", ",", "xAct`xConf`Private`res5"}], 
                    "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"xAct`xConf`Private`res6", "=", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ChangeCovD", "[", 
                    
                    RowBox[{"#1", ",", "$CovDs", ",", 
                    "xAct`xConf`Private`cd1"}], "]"}], "&"}], ")"}], "[", 
                    "xAct`xConf`Private`res5", "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"$Debug", ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    RowBox[{"\"res6 = \"", ",", "xAct`xConf`Private`res6"}], 
                    "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"xAct`xConf`Private`res7", "=", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`ChangeChristoffel", "[", 
                    
                    RowBox[{"#1", ",", 
                    "xAct`xConf`Private`$CovDsRelatedTocd1", ",", 
                    "xAct`xConf`Private`cd1"}], "]"}], "&"}], ")"}], "[", 
                    "xAct`xConf`Private`res6", "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"$Debug", ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    RowBox[{"\"res7 = \"", ",", "xAct`xConf`Private`res7"}], 
                    "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"xAct`xConf`Private`res8", "=", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ChristoffelToGradConformal", "[", 
                    
                    RowBox[{"#1", ",", 
                    "xAct`xConf`Private`$CovDsRelatedTocd1", ",", 
                    "xAct`xConf`Private`cd1"}], "]"}], "&"}], ")"}], "[", 
                    "xAct`xConf`Private`res7", "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"$Debug", ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    RowBox[{"\"res8 = \"", ",", "xAct`xConf`Private`res8"}], 
                    "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"xAct`xConf`Private`res9", "=", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ChangeCovD", "[", 
                    
                    RowBox[{"#1", ",", "$CovDs", ",", 
                    "xAct`xConf`Private`cd1"}], "]"}], "&"}], ")"}], "[", 
                    "xAct`xConf`Private`res8", "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"$Debug", ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    RowBox[{"\"res9 = \"", ",", "xAct`xConf`Private`res9"}], 
                    "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"xAct`xConf`Private`res10", "=", 
                    RowBox[{"Fold", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"#1", "/.", "\[VeryThinSpace]", 
                    RowBox[{"ConformalRules", "[", 
                    RowBox[{"#2", ",", "xAct`xConf`Private`metric1"}], 
                    "]"}]}], "&"}], ",", "xAct`xConf`Private`res9", ",", 
                    "xAct`xConf`Private`metricsrelatedtocd1"}], "]"}]}], ";", 
                    
                    RowBox[{"xAct`xConf`Private`res11", "=", 
                    RowBox[{"Fold", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"#1", "/.", "\[VeryThinSpace]", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"epsilon", "[", "#2", "]"}], "[", 
                    "xAct`xConf`Private`inds__", "]"}], "\[RuleDelayed]", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{"SqrtConformalFactor", "[", 
                    RowBox[{"#2", ",", "xAct`xConf`Private`metric1"}], "]"}], 
                    
                    RowBox[{"xAct`xConf`Private`WeightOfIndicesList", "[", 
                    RowBox[{"{", "xAct`xConf`Private`inds", "}"}], "]"}]], 
                    " ", 
                    RowBox[{
                    RowBox[{"epsilon", "[", "xAct`xConf`Private`metric1", 
                    "]"}], "[", "xAct`xConf`Private`inds", "]"}]}]}]}], "&"}],
                     ",", "xAct`xConf`Private`res10", ",", 
                    "xAct`xConf`Private`metricsrelatedtocd1"}], "]"}]}], ";", 
                    
                    RowBox[{
                    
                    RowBox[{"OptionValue", "[", "SimplificationFunction", 
                    "]"}], "[", "xAct`xConf`Private`res11", "]"}]}]}], 
                    "]"}]}], "]"}]}]}, {" "}, {
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToMetric", "[", "]"}], "[", 
                    "xAct`xConf`Private`expr_", "]"}], ":=", 
                    RowBox[{
                    RowBox[{"ToMetric", "[", 
                    RowBox[{"First", "[", "$Metrics", "]"}], "]"}], "[", 
                    "xAct`xConf`Private`expr", "]"}]}]}, {" "}}, 
                  GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                  DefaultBaseStyle -> "Column", 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                "RowDefault"]}
             },
             DefaultBaseStyle->"Column",
             GridBoxAlignment->{"Columns" -> {{Left}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
            "Column"],
           FrameMargins->{{6, 0}, {3, 6}}], "\<\"\"\>"},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Options\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Options\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Options", "Tooltip"]& ], 
                   RowBox[{
                   "SimplificationFunction", "\[Rule]", "SafeArrange"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xConf`ToMetric\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->{{6, 6}, {6, 3}}], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"ToMetric[metric,SimplificationFunction->function][\
expr] formulates 'expr' in terms of conformal frame 'metric', and its \
associated covariant derivative and curvature tensors. It is a passive \
transformation. The optional SimplificationFunction option sets the function \
which simpmlifies the final result. \\n\\n The option \
ConformalTransformation->function allows to define the function used for \
simplification. By default it is set to 'SafeArrange' which is a custom \
function based on ToCanonical, but the user can decide to put Identity for \
instance to avoid loss of time in canonicalization.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "ToMetric[metric,SimplificationFunction->function][expr] formulates \
'expr' in terms of conformal frame 'metric', and its associated covariant \
derivative and curvature tensors. It is a passive transformation. The \
optional SimplificationFunction option sets the function which simpmlifies \
the final result. \n\n The option ConformalTransformation->function allows to \
define the function used for simplification. By default it is set to \
'SafeArrange' which is a custom function based on ToCanonical, but the user \
can decide to put Identity for instance to avoid loss of time in \
canonicalization.", "Documentation" -> None, "OwnValues" -> None, "UpValues" -> 
    None, "DownValues" -> None, "SubValues" -> 
    Information`InformationValueForm[
     SubValues, xAct`xConf`ToMetric, {xAct`xConf`ToMetric[
         PatternTest[
          Pattern[xAct`xConf`Private`metric1, 
           Blank[]], xAct`xTensor`MetricQ], 
         OptionsPattern[]][
         Pattern[xAct`xConf`Private`expr, 
          Blank[]]] :> 
       Module[{xAct`xConf`Private`res1, xAct`xConf`Private`res2, 
          xAct`xConf`Private`res3, xAct`xConf`Private`res4, 
          xAct`xConf`Private`res5, xAct`xConf`Private`res6, 
          xAct`xConf`Private`res7, xAct`xConf`Private`res8, 
          xAct`xConf`Private`res9, xAct`xConf`Private`res10, 
          xAct`xConf`Private`res11, xAct`xConf`Private`$CovDsRelatedTocd1}, 
         With[{
          xAct`xConf`Private`cd1 = 
           xAct`xTensor`CovDOfMetric[xAct`xConf`Private`metric1], 
           xAct`xConf`Private`M = xAct`xTensor`ManifoldOfCovD[
             xAct`xTensor`CovDOfMetric[xAct`xConf`Private`metric1]], 
           xAct`xConf`Private`metricsrelatedtocd1 = 
           Select[xAct`xTensor`$Metrics, 
             xAct`xTensor`ConformalRules[
              xAct`xConf`Private`metric1, #] =!= {}& ], 
           xAct`xConf`Private`firstmetric = First[xAct`xTensor`$Metrics]}, 
          xAct`xConf`Private`$CovDsRelatedTocd1 = 
           Map[xAct`xTensor`CovDOfMetric, 
             xAct`xConf`Private`metricsrelatedtocd1]; 
          xAct`xConf`Private`res1 = xAct`xTensor`SeparateMetric[][
             xAct`xTensor`WeylToRiemann[
              xAct`xTensor`EinsteinToRicci[xAct`xConf`Private`expr]]]; 
          If[xAct`xConf`$Debug, Print["res1 = ", xAct`xConf`Private`res1]; 
            Null]; xAct`xConf`Private`res2 = 
           ReplaceAll[xAct`xConf`Private`res1, PatternTest[
               Pattern[xAct`xConf`Private`tens, 
                Blank[]], xAct`xConf`TensorNotMetricRelated][
               Pattern[xAct`xConf`Private`inds, 
                BlankNullSequence[]]] :> 
             xAct`xConf`ConformalFrame[xAct`xConf`Private`firstmetric][
               xAct`xConf`Private`tens[xAct`xConf`Private`inds]]]; 
          If[xAct`xConf`$Debug, Print["res2  = ", xAct`xConf`Private`res2]; 
            Null]; xAct`xConf`Private`res3 = 
           ReplaceAll[xAct`xConf`Private`res2, xAct`xConf`ConformalFrame[
               PatternTest[
                Pattern[xAct`xConf`Private`frame, 
                 Blank[]], And[# =!= xAct`xConf`Private`metric1, 
                 xAct`xTensor`MetricQ[#]]& ]][
               PatternTest[
                Pattern[xAct`xConf`Private`tens, 
                 Blank[]], xAct`xTensor`xTensorQ][
                Pattern[xAct`xConf`Private`inds, 
                 BlankNullSequence[]]]] :> 
             xAct`xConf`SqrtConformalFactor[
                xAct`xConf`Private`frame, xAct`xConf`Private`metric1]^
               xAct`xConf`ConformalWeight[
                 xAct`xConf`Private`tens[xAct`xConf`Private`inds]] 
              xAct`xConf`ConformalFrame[xAct`xConf`Private`metric1][
                xAct`xConf`Private`tens[xAct`xConf`Private`inds]]]; 
          xAct`xConf`Private`res4 = 
           ReplaceAll[
            xAct`xConf`Private`res3, 
             xAct`xConf`ConformalFrame[xAct`xConf`Private`firstmetric][
               PatternTest[
                Pattern[xAct`xConf`Private`tens, 
                 Blank[]], xAct`xTensor`xTensorQ][
                Pattern[xAct`xConf`Private`inds, 
                 BlankNullSequence[]]]] :> 
             xAct`xConf`Private`tens[xAct`xConf`Private`inds]]; 
          xAct`xConf`Private`res5 = (
            xAct`xTensor`ChangeCurvature[#, xAct`xTensor`$CovDs, 
             xAct`xConf`Private`cd1]& )[xAct`xConf`Private`res4]; 
          If[xAct`xConf`$Debug, Print["res5 = ", xAct`xConf`Private`res5]; 
            Null]; xAct`xConf`Private`res6 = (
            xAct`xTensor`ChangeCovD[#, xAct`xTensor`$CovDs, 
             xAct`xConf`Private`cd1]& )[xAct`xConf`Private`res5]; 
          If[xAct`xConf`$Debug, Print["res6 = ", xAct`xConf`Private`res6]; 
            Null]; xAct`xConf`Private`res7 = (
            xAct`xConf`Private`ChangeChristoffel[#, 
             xAct`xConf`Private`$CovDsRelatedTocd1, 
             xAct`xConf`Private`cd1]& )[xAct`xConf`Private`res6]; 
          If[xAct`xConf`$Debug, Print["res7 = ", xAct`xConf`Private`res7]; 
            Null]; xAct`xConf`Private`res8 = (
            xAct`xTensor`ChristoffelToGradConformal[#, 
             xAct`xConf`Private`$CovDsRelatedTocd1, 
             xAct`xConf`Private`cd1]& )[xAct`xConf`Private`res7]; 
          If[xAct`xConf`$Debug, Print["res8 = ", xAct`xConf`Private`res8]; 
            Null]; xAct`xConf`Private`res9 = (
            xAct`xTensor`ChangeCovD[#, xAct`xTensor`$CovDs, 
             xAct`xConf`Private`cd1]& )[xAct`xConf`Private`res8]; 
          If[xAct`xConf`$Debug, Print["res9 = ", xAct`xConf`Private`res9]; 
            Null]; xAct`xConf`Private`res10 = Fold[ReplaceAll[#, 
              xAct`xTensor`ConformalRules[#2, xAct`xConf`Private`metric1]]& , 
             xAct`xConf`Private`res9, xAct`xConf`Private`metricsrelatedtocd1]; 
          xAct`xConf`Private`res11 = 
           Fold[ReplaceAll[#, xAct`xTensor`epsilon[#2][
                Pattern[xAct`xConf`Private`inds, 
                 BlankSequence[]]] :> 
              xAct`xConf`SqrtConformalFactor[#2, xAct`xConf`Private`metric1]^
                xAct`xConf`Private`WeightOfIndicesList[{
                  xAct`xConf`Private`inds}] 
               xAct`xTensor`epsilon[xAct`xConf`Private`metric1][
                xAct`xConf`Private`inds]]& , xAct`xConf`Private`res10, 
             xAct`xConf`Private`metricsrelatedtocd1]; 
          OptionValue[xAct`xConf`SimplificationFunction][
           xAct`xConf`Private`res11]]], xAct`xConf`ToMetric[][
         Pattern[xAct`xConf`Private`expr, 
          Blank[]]] :> xAct`xConf`ToMetric[
         First[xAct`xTensor`$Metrics]][xAct`xConf`Private`expr]}], 
    "DefaultValues" -> None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> {
     xAct`xConf`SimplificationFunction -> xAct`xConf`SafeArrange}, 
    "Attributes" -> {Protected}, "FullName" -> "xAct`xConf`ToMetric"|>, 
   False]]], "Output",
 CellLabel->
  "Out[56]=",ExpressionUUID->"71ac4bfa-a68b-421a-9c8e-6c4f174450b5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ToMetric", "[", "gS2", "]"}], "[", 
  RowBox[{"g", "[", 
   RowBox[{
    RowBox[{"-", "\[Mu]"}], ",", 
    RowBox[{"-", "\[Nu]"}]}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ToMetric", "[", "g", "]"}], "[", "%", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ToMetric", "[", "gS2", "]"}], "[", 
  RowBox[{"g", "[", 
   RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ToMetric", "[", "g", "]"}], "[", "%", "]"}]}], "Input",
 CellLabel->"In[57]:=",ExpressionUUID->"772e1428-d889-4d2d-9767-8becdbec3cba"],

Cell[BoxData[
 FractionBox[
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"[", 
        RowBox[{"g", 
         SuperscriptBox["S", "2"]}], "]"}], 
       StyleBox[GridBox[{
          {" ", " "},
          {"\[Mu]", "\[Nu]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`gS2[-$CellContext`\[Mu], -$CellContext`\[Nu]],
   Editable->False], 
  SuperscriptBox[
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False], "2"]]], "Output",
 CellLabel->"Out[57]=",ExpressionUUID->"26415f02-b2af-4fa1-b4b3-c96129226fd2"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"g", 
      StyleBox[GridBox[{
         {" ", " "},
         {"\[Mu]", "\[Nu]"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`g[-$CellContext`\[Mu], -$CellContext`\[Nu]],
  Editable->False]], "Output",
 CellLabel->"Out[58]=",ExpressionUUID->"002b1cdc-e47e-4313-bb30-cd5ea6b3807d"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"i", "[", 
        RowBox[{"g", 
         SuperscriptBox["S", "2"]}], "]"}], 
       StyleBox[GridBox[{
          {"\[Mu]", "\[Nu]"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`InvgS2[$CellContext`\[Mu], $CellContext`\[Nu]],
   Editable->False], " ", 
  SuperscriptBox[
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False], "2"]}]], "Output",
 CellLabel->"Out[59]=",ExpressionUUID->"193088e5-de65-428e-a13b-2c4932bbb436"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"g", 
      StyleBox[GridBox[{
         {"\[Mu]", "\[Nu]"},
         {" ", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`g[$CellContext`\[Mu], $CellContext`\[Nu]],
  Editable->False]], "Output",
 CellLabel->
  "Out[60]=",ExpressionUUID->"caa88711-5e4a-4e9f-83fd-d23c54f7222a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ToMetric", "[", "gS2", "]"}], "[", 
   RowBox[{"k", "[", 
    RowBox[{"-", "\[Nu]"}], "]"}], "]"}], "//", 
  "NoScalar"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ToMetric", "[", "g", "]"}], "[", "%", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ToMetric", "[", "gS2", "]"}], "[", 
   RowBox[{"k", "[", "\[Nu]", "]"}], "]"}], "//", 
  "NoScalar"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ToMetric", "[", "g", "]"}], "[", "%", "]"}]}], "Input",
 CellLabel->"In[61]:=",ExpressionUUID->"b72c7848-80e7-4ca7-8d19-dfa60971de06"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox["[",
     FontColor->RGBColor[1, 0, 0]], 
    InterpretationBox[
     StyleBox[GridBox[{
        {"k", 
         StyleBox[GridBox[{
            {" "},
            {"\[Nu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`k[-$CellContext`\[Nu]],
     Editable->False], 
    StyleBox["]",
     FontColor->RGBColor[1, 0, 0]]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xConf`ConformalFrame[$CellContext`gS2][
   $CellContext`k[-$CellContext`\[Nu]]],
  Editable->False]], "Output",
 CellLabel->"Out[61]=",ExpressionUUID->"0d14e2e7-b09e-4dfa-9ac3-570ccb88538e"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"k", 
      StyleBox[GridBox[{
         {" "},
         {"\[Nu]"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`k[-$CellContext`\[Nu]],
  Editable->False]], "Output",
 CellLabel->"Out[62]=",ExpressionUUID->"ec4fa2c5-1688-4d29-b04a-30965397f7bb"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"i", "[", 
        RowBox[{"g", 
         SuperscriptBox["S", "2"]}], "]"}], 
       StyleBox[GridBox[{
          {"\[Nu]", "\[Sigma]$15824"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`InvgS2[$CellContext`\[Nu], $CellContext`\[Sigma]$15824],
   Editable->False], " ", 
  SuperscriptBox[
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False], "2"], " ", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     StyleBox["[",
      FontColor->RGBColor[1, 0, 0]], 
     InterpretationBox[
      StyleBox[GridBox[{
         {"k", 
          StyleBox[GridBox[{
             {" "},
             {"\[Sigma]$15824"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`k[-$CellContext`\[Sigma]$15824],
      Editable->False], 
     StyleBox["]",
      FontColor->RGBColor[1, 0, 0]]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xConf`ConformalFrame[$CellContext`gS2][
    $CellContext`k[-$CellContext`\[Sigma]$15824]],
   Editable->False]}]], "Output",
 CellLabel->"Out[63]=",ExpressionUUID->"a9de7d13-ef21-4708-84f9-eab6b389e48a"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"g", 
       StyleBox[GridBox[{
          {"\[Nu]", "\[Sigma]$15824"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`g[$CellContext`\[Nu], $CellContext`\[Sigma]$15824],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"k", 
       StyleBox[GridBox[{
          {" "},
          {"\[Sigma]$15824"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`k[-$CellContext`\[Sigma]$15824],
   Editable->False]}]], "Output",
 CellLabel->
  "Out[64]=",ExpressionUUID->"b443ec8a-8e9d-4249-b243-3e47de179f6f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ToMetric", "[", "gS2", "]"}], "[", 
   RowBox[{
    RowBox[{"CD", "[", 
     RowBox[{"-", "\[Mu]"}], "]"}], "[", 
    RowBox[{"k", "[", 
     RowBox[{"-", "\[Nu]"}], "]"}], "]"}], "]"}], "//", 
  "NoScalar"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ToMetric", "[", "g", "]"}], "[", "%", "]"}], "//", 
  "NoScalar"}]}], "Input",
 CellLabel->"In[65]:=",ExpressionUUID->"7a08d0e7-9998-4bcf-ab52-4928df4a7828"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox[
      RowBox[{"\[Del]", "gS2"}], "\[Mu]"], 
     StyleBox["[",
      FontColor->RGBColor[1, 0, 0]], 
     InterpretationBox[
      StyleBox[GridBox[{
         {"k", 
          StyleBox[GridBox[{
             {" "},
             {"\[Nu]"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`k[-$CellContext`\[Nu]],
      Editable->False], 
     StyleBox["]",
      FontColor->RGBColor[1, 0, 0]]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`CDgS2[-$CellContext`\[Mu]][
    xAct`xConf`ConformalFrame[$CellContext`gS2][
     $CellContext`k[-$CellContext`\[Nu]]]],
   Editable->False], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox[
         RowBox[{"\[Del]", "gS2"}], "\[Nu]"], "S"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CDgS2[-$CellContext`\[Nu]][
       $CellContext`S[]],
      Editable->False], ")"}], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["[",
        FontColor->RGBColor[1, 0, 0]], 
       InterpretationBox[
        StyleBox[GridBox[{
           {"k", 
            StyleBox[GridBox[{
               {" "},
               {"\[Mu]"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`k[-$CellContext`\[Mu]],
        Editable->False], 
       StyleBox["]",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xConf`ConformalFrame[$CellContext`gS2][
      $CellContext`k[-$CellContext`\[Mu]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox[
         RowBox[{"\[Del]", "gS2"}], "\[Mu]"], "S"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CDgS2[-$CellContext`\[Mu]][
       $CellContext`S[]],
      Editable->False], ")"}], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["[",
        FontColor->RGBColor[1, 0, 0]], 
       InterpretationBox[
        StyleBox[GridBox[{
           {"k", 
            StyleBox[GridBox[{
               {" "},
               {"\[Nu]"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`k[-$CellContext`\[Nu]],
        Editable->False], 
       StyleBox["]",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xConf`ConformalFrame[$CellContext`gS2][
      $CellContext`k[-$CellContext`\[Nu]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"[", 
          RowBox[{"g", 
           SuperscriptBox["S", "2"]}], "]"}], 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Mu]", "\[Nu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`gS2[-$CellContext`\[Mu], -$CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"i", "[", 
          RowBox[{"g", 
           SuperscriptBox["S", "2"]}], "]"}], 
         StyleBox[GridBox[{
            {"\[Sigma]$15965", "\[Sigma]$15966"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`InvgS2[$CellContext`\[Sigma]$15965, \
$CellContext`\[Sigma]$15966],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox[
         RowBox[{"\[Del]", "gS2"}], "\[Sigma]$15966"], "S"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CDgS2[-$CellContext`\[Sigma]$15966][
       $CellContext`S[]],
      Editable->False], ")"}], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["[",
        FontColor->RGBColor[1, 0, 0]], 
       InterpretationBox[
        StyleBox[GridBox[{
           {"k", 
            StyleBox[GridBox[{
               {" "},
               {"\[Sigma]$15965"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`k[-$CellContext`\[Sigma]$15965],
        Editable->False], 
       StyleBox["]",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xConf`ConformalFrame[$CellContext`gS2][
      $CellContext`k[-$CellContext`\[Sigma]$15965]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False]]}]], "Output",
 CellLabel->"Out[65]=",ExpressionUUID->"b8f89d49-ae19-4e30-850e-b51f662f8af1"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubscriptBox["\[Del]", "\[Mu]"], GridBox[{
      {"k", 
       StyleBox[GridBox[{
          {" "},
          {"\[Nu]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`CD[-$CellContext`\[Mu]][
   $CellContext`k[-$CellContext`\[Nu]]],
  Editable->False]], "Output",
 CellLabel->
  "Out[66]=",ExpressionUUID->"2ac1f753-62b4-4657-b209-512f96029e74"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ToMetric", "[", "gS2", "]"}], "[", 
  RowBox[{"RicciCD", "[", 
   RowBox[{
    RowBox[{"-", "\[Mu]"}], ",", 
    RowBox[{"-", "\[Nu]"}]}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ToMetric", "[", "g", "]"}], "[", "%", "]"}]}], "Input",
 CellLabel->"In[67]:=",ExpressionUUID->"47563fff-6c76-40d8-a87d-5fcf8847ef5c"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"R", "[", 
        RowBox[{"\[Del]", "gS2"}], "]"}], 
       StyleBox[GridBox[{
          {" ", " "},
          {"\[Mu]", "\[Nu]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`RicciCDgS2[-$CellContext`\[Mu], -$CellContext`\[Nu]],
   Editable->False], "-", 
  FractionBox[
   RowBox[{"3", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"[", 
          RowBox[{"g", 
           SuperscriptBox["S", "2"]}], "]"}], 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Mu]", "\[Nu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`gS2[-$CellContext`\[Mu], -$CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"i", "[", 
              RowBox[{"g", 
               SuperscriptBox["S", "2"]}], "]"}], 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`InvgS2[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubscriptBox[
             RowBox[{"\[Del]", "gS2"}], "\[Alpha]"], "S"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CDgS2[-$CellContext`\[Alpha]][
           $CellContext`S[]],
          Editable->False], ")"}], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubscriptBox[
             RowBox[{"\[Del]", "gS2"}], "\[Beta]"], "S"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CDgS2[-$CellContext`\[Beta]][
           $CellContext`S[]],
          Editable->False], ")"}]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`InvgS2[$CellContext`\[Alpha], \
$CellContext`\[Beta]] $CellContext`CDgS2[-$CellContext`\[Alpha]][
        $CellContext`S[]] $CellContext`CDgS2[-$CellContext`\[Beta]][
        $CellContext`S[]]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"[", 
          RowBox[{"g", 
           SuperscriptBox["S", "2"]}], "]"}], 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Mu]", "\[Nu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`gS2[-$CellContext`\[Mu], -$CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"i", "[", 
              RowBox[{"g", 
               SuperscriptBox["S", "2"]}], "]"}], 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`InvgS2[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubscriptBox[
             RowBox[{"\[Del]", "gS2"}], "\[Beta]"], 
            SubscriptBox[
             RowBox[{"\[Del]", "gS2"}], "\[Alpha]"], "S"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CDgS2[-$CellContext`\[Beta]][
           $CellContext`CDgS2[-$CellContext`\[Alpha]][
            $CellContext`S[]]],
          Editable->False], ")"}]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`InvgS2[$CellContext`\[Alpha], \
$CellContext`\[Beta]] $CellContext`CDgS2[-$CellContext`\[Beta]][
        $CellContext`CDgS2[-$CellContext`\[Alpha]][
         $CellContext`S[]]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox[
         RowBox[{"\[Del]", "gS2"}], "\[Nu]"], 
        SubscriptBox[
         RowBox[{"\[Del]", "gS2"}], "\[Mu]"], "S"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CDgS2[-$CellContext`\[Nu]][
       $CellContext`CDgS2[-$CellContext`\[Mu]][
        $CellContext`S[]]],
      Editable->False], ")"}]}], 
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False]]}]], "Output",
 CellLabel->"Out[67]=",ExpressionUUID->"27be7b11-a847-4bb3-b09a-099fe1c5f0a4"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{"R", "[", "\[Del]", "]"}], 
      StyleBox[GridBox[{
         {" ", " "},
         {"\[Mu]", "\[Nu]"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`RicciCD[-$CellContext`\[Mu], -$CellContext`\[Nu]],
  Editable->False]], "Output",
 CellLabel->
  "Out[68]=",ExpressionUUID->"d11e1759-7d87-4a72-8714-7cfcd6969413"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["internal behaviour of ConformalTransformation", \
"Section",ExpressionUUID->"0ea510c4-0f6f-45ae-81ba-e291684c11b5"],

Cell["\<\
So what ConformalTransformaton[metric1, metric2][expr] does, is 
1) to use separate the indices in their natural positions
2) Use ToMetric[metric]
3) Apply ConformalFrame[metric2] on the expression to formally transform it \
to the new frame. 
4) Then use the rules RulesChangeConformalFrame[metric1,metric2]. These are \
automatic rules.
5) Apply ToMetric[finalframe]. finalframe is metric1 if FinalFrame->Automatic \
or it is the one specified by FinalFrame->finalframe.
\
\>", "Text",ExpressionUUID->"3e5aecdf-c103-46e1-8e26-777068faac2e"],

Cell["\<\
For instance if we put all these steps together on the Ricci scalar with up \
indices we get\
\>", "Text",ExpressionUUID->"bd3f118c-057c-46d1-baf8-ca9033249fdd"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"RicciCD", "[", 
  RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SeparateMetric", "[", "]"}], "[", "%", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ToMetric", "[", "g", "]"}], "[", "%", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ConformalFrame", "[", "gS2", "]"}], "[", "%", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ToMetric", "[", "g", "]"}], "[", "%", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"%", "//", "NoScalar"}], "//", "ContractMetric"}], "//", 
  "ToCanonical"}]}], "Input",
 CellLabel->"In[69]:=",ExpressionUUID->"cf37ff2e-0d0d-4020-a52d-0a6b30b595ea"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{"R", "[", "\[Del]", "]"}], 
      StyleBox[GridBox[{
         {"\[Mu]", "\[Nu]"},
         {" ", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`RicciCD[$CellContext`\[Mu], $CellContext`\[Nu]],
  Editable->False]], "Output",
 CellLabel->"Out[69]=",ExpressionUUID->"c2281009-83a8-4b00-8ba5-cccd14cad961"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"g", 
       StyleBox[GridBox[{
          {"\[Mu]", "\[Sigma]$16428"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`g[$CellContext`\[Mu], $CellContext`\[Sigma]$16428],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"g", 
       StyleBox[GridBox[{
          {"\[Nu]", "\[Sigma]$16429"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`g[$CellContext`\[Nu], $CellContext`\[Sigma]$16429],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"R", "[", "\[Del]", "]"}], 
       StyleBox[GridBox[{
          {" ", " "},
          {"\[Sigma]$16428", "\[Sigma]$16429"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`RicciCD[-$CellContext`\[Sigma]$16428, \
-$CellContext`\[Sigma]$16429],
   Editable->False]}]], "Output",
 CellLabel->"Out[70]=",ExpressionUUID->"48e481a8-0d44-4361-916f-181d86cae232"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"g", 
       StyleBox[GridBox[{
          {"\[Mu]", "\[Sigma]$16428"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`g[$CellContext`\[Mu], $CellContext`\[Sigma]$16428],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"g", 
       StyleBox[GridBox[{
          {"\[Nu]", "\[Sigma]$16429"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`g[$CellContext`\[Nu], $CellContext`\[Sigma]$16429],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"R", "[", "\[Del]", "]"}], 
       StyleBox[GridBox[{
          {" ", " "},
          {"\[Sigma]$16428", "\[Sigma]$16429"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`RicciCD[-$CellContext`\[Sigma]$16428, \
-$CellContext`\[Sigma]$16429],
   Editable->False]}]], "Output",
 CellLabel->"Out[71]=",ExpressionUUID->"de76ff65-7d70-4772-b96f-e841be04a34e"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"i", "[", 
        RowBox[{"g", 
         SuperscriptBox["S", "2"]}], "]"}], 
       StyleBox[GridBox[{
          {"\[Mu]", "\[Sigma]$16428"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`InvgS2[$CellContext`\[Mu], $CellContext`\[Sigma]$16428],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"i", "[", 
        RowBox[{"g", 
         SuperscriptBox["S", "2"]}], "]"}], 
       StyleBox[GridBox[{
          {"\[Nu]", "\[Sigma]$16429"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`InvgS2[$CellContext`\[Nu], $CellContext`\[Sigma]$16429],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"R", "[", 
        RowBox[{"\[Del]", "gS2"}], "]"}], 
       StyleBox[GridBox[{
          {" ", " "},
          {"\[Sigma]$16428", "\[Sigma]$16429"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`RicciCDgS2[-$CellContext`\[Sigma]$16428, -$CellContext`\
\[Sigma]$16429],
   Editable->False]}]], "Output",
 CellLabel->"Out[72]=",ExpressionUUID->"7e512e94-709f-4079-852c-7d0da0a24635"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Mu]", "\[Sigma]$16428"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Mu], $CellContext`\[Sigma]$16428],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Sigma]$16429"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Sigma]$16429],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"R", "[", "\[Del]", "]"}], 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Sigma]$16428", "\[Sigma]$16429"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`RicciCD[-$CellContext`\[Sigma]$16428, \
-$CellContext`\[Sigma]$16429],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "4"]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Mu]", "\[Nu]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Mu], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Alpha]][
          $CellContext`S[]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Beta]"], "S"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Beta]][
          $CellContext`S[]],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
        $CellContext`S[]] $CellContext`CD[-$CellContext`\[Beta]][
        $CellContext`S[]]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "6"]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Mu]", "\[Nu]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Mu], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Beta]"], 
           SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Beta]][
          $CellContext`CD[-$CellContext`\[Alpha]][
           $CellContext`S[]]],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Beta]][
        $CellContext`CD[-$CellContext`\[Alpha]][
         $CellContext`S[]]]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "5"]], "+", 
  FractionBox[
   RowBox[{"4", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Mu]", "\[Sigma]$16428"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Mu], $CellContext`\[Sigma]$16428],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Sigma]$16429"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Sigma]$16429],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Sigma]$16428"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Sigma]$16428][
      $CellContext`S[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Sigma]$16429"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Sigma]$16429][
      $CellContext`S[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "6"]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Mu]", "\[Sigma]$16428"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Mu], $CellContext`\[Sigma]$16428],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Sigma]$16429"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Sigma]$16429],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Sigma]$16429"], 
       SubscriptBox["\[Del]", "\[Sigma]$16428"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Sigma]$16429][
      $CellContext`CD[-$CellContext`\[Sigma]$16428][
       $CellContext`S[]]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "5"]]}]], "Output",
 CellLabel->"Out[73]=",ExpressionUUID->"ed70929a-ebc9-4648-81ca-cb4abf31e42b"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"R", "[", "\[Del]", "]"}], 
        StyleBox[GridBox[{
           {"\[Mu]", "\[Nu]"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[$CellContext`\[Mu], $CellContext`\[Nu]],
    Editable->False], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "4"]], "+", 
  FractionBox[
   RowBox[{"4", " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Mu]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Mu]][
      $CellContext`S[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Nu]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Nu]][
      $CellContext`S[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "6"]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Nu]"], 
       SuperscriptBox["\[Del]", "\[Mu]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Nu]][
      $CellContext`CD[$CellContext`\[Mu]][
       $CellContext`S[]]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "5"]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Mu]", "\[Nu]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Mu], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Sigma]$16637"], 
       SuperscriptBox["\[Del]", "\[Sigma]$16637"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Sigma]$16637][
      $CellContext`CD[$CellContext`\[Sigma]$16637][
       $CellContext`S[]]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "5"]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Mu]", "\[Nu]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Mu], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Sigma]$16637"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Sigma]$16637][
      $CellContext`S[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Sigma]$16637"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Sigma]$16637][
      $CellContext`S[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "6"]]}]], "Output",
 CellLabel->
  "Out[74]=",ExpressionUUID->"6e7d201a-e619-43bc-9534-8928cbbe4cda"]
}, Open  ]],

Cell["And if we were to ask a different final frame :", \
"Text",ExpressionUUID->"5931f0d0-346c-4c29-b07e-92cdc3d4de6d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ToMetric", "[", "gS2", "]"}], "[", "%", "]"}]], "Input",
 CellLabel->"In[75]:=",ExpressionUUID->"384474b0-301f-42e4-b5d3-96f481be32f6"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"i", "[", 
        RowBox[{"g", 
         SuperscriptBox["S", "2"]}], "]"}], 
       StyleBox[GridBox[{
          {"\[Mu]", "\[Sigma]$16676"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`InvgS2[$CellContext`\[Mu], $CellContext`\[Sigma]$16676],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"i", "[", 
        RowBox[{"g", 
         SuperscriptBox["S", "2"]}], "]"}], 
       StyleBox[GridBox[{
          {"\[Nu]", "\[Sigma]$16677"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`InvgS2[$CellContext`\[Nu], $CellContext`\[Sigma]$16677],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"R", "[", 
        RowBox[{"\[Del]", "gS2"}], "]"}], 
       StyleBox[GridBox[{
          {" ", " "},
          {"\[Sigma]$16676", "\[Sigma]$16677"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`RicciCDgS2[-$CellContext`\[Sigma]$16676, -$CellContext`\
\[Sigma]$16677],
   Editable->False]}]], "Output",
 CellLabel->
  "Out[75]=",ExpressionUUID->"9d70eff7-b974-431c-b62c-bfadd2d5e130"]
}, Open  ]],

Cell["\<\
And if we use the function ConformalTransformation this gives also (depending \
on the final frame asked)\
\>", "Text",ExpressionUUID->"0d8caa3e-9a39-44ce-a8dc-32efbb31b690"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ConformalTransformation", "[", 
   RowBox[{"g", ",", "gS2"}], "]"}], "[", 
  RowBox[{"RicciCD", "[", 
   RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ConformalTransformation", "[", 
   RowBox[{"g", ",", "gS2", ",", 
    RowBox[{"FinalFrame", "->", "gS2"}]}], "]"}], "[", 
  RowBox[{"RicciCD", "[", 
   RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}], "]"}]}], "Input",
 CellLabel->"In[76]:=",ExpressionUUID->"6ac1279f-5321-4eed-bfe7-794d0631548a"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Mu]", "\[Sigma]$16920"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Mu], $CellContext`\[Sigma]$16920],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Sigma]$16921"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Sigma]$16921],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"R", "[", "\[Del]", "]"}], 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Sigma]$16920", "\[Sigma]$16921"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`RicciCD[-$CellContext`\[Sigma]$16920, \
-$CellContext`\[Sigma]$16921],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "4"]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Mu]", "\[Nu]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Mu], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Alpha]][
          $CellContext`S[]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Beta]"], "S"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Beta]][
          $CellContext`S[]],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
        $CellContext`S[]] $CellContext`CD[-$CellContext`\[Beta]][
        $CellContext`S[]]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "6"]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Mu]", "\[Nu]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Mu], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Beta]"], 
           SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Beta]][
          $CellContext`CD[-$CellContext`\[Alpha]][
           $CellContext`S[]]],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Beta]][
        $CellContext`CD[-$CellContext`\[Alpha]][
         $CellContext`S[]]]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "5"]], "+", 
  FractionBox[
   RowBox[{"4", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Mu]", "\[Sigma]$16920"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Mu], $CellContext`\[Sigma]$16920],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Sigma]$16921"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Sigma]$16921],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Sigma]$16920"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Sigma]$16920][
      $CellContext`S[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Sigma]$16921"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Sigma]$16921][
      $CellContext`S[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "6"]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Mu]", "\[Sigma]$16920"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Mu], $CellContext`\[Sigma]$16920],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Sigma]$16921"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Sigma]$16921],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Sigma]$16921"], 
       SubscriptBox["\[Del]", "\[Sigma]$16920"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Sigma]$16921][
      $CellContext`CD[-$CellContext`\[Sigma]$16920][
       $CellContext`S[]]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "5"]]}]], "Output",
 CellLabel->"Out[76]=",ExpressionUUID->"3d1db021-0151-49b6-8a6d-cd53dcb4cc17"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"i", "[", 
        RowBox[{"g", 
         SuperscriptBox["S", "2"]}], "]"}], 
       StyleBox[GridBox[{
          {"\[Mu]", "\[Sigma]$17130"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`InvgS2[$CellContext`\[Mu], $CellContext`\[Sigma]$17130],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"i", "[", 
        RowBox[{"g", 
         SuperscriptBox["S", "2"]}], "]"}], 
       StyleBox[GridBox[{
          {"\[Nu]", "\[Sigma]$17131"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`InvgS2[$CellContext`\[Nu], $CellContext`\[Sigma]$17131],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"R", "[", 
        RowBox[{"\[Del]", "gS2"}], "]"}], 
       StyleBox[GridBox[{
          {" ", " "},
          {"\[Sigma]$17130", "\[Sigma]$17131"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`RicciCDgS2[-$CellContext`\[Sigma]$17130, -$CellContext`\
\[Sigma]$17131],
   Editable->False]}]], "Output",
 CellLabel->
  "Out[77]=",ExpressionUUID->"0811567a-3651-4ca3-8cef-c221bd795259"]
}, Open  ]],

Cell["\<\
Note that transforming an expression to a given target frame, and expressing \
the result in that same target frame amounts to formally replacing all \
quantities by their conformally transformed counterparts, hence it is \
trivial. Examples :\
\>", "Text",ExpressionUUID->"da75db19-0fad-4fbf-bcdd-6d8efd1f5004"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ConformalTransformation", "[", 
   RowBox[{"g", ",", "gS2", ",", 
    RowBox[{"FinalFrame", "->", "gS2"}]}], "]"}], "[", 
  RowBox[{
   RowBox[{"CD", "[", "\[Nu]", "]"}], "[", 
   RowBox[{"k", "[", "\[Mu]", "]"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ConformalTransformation", "[", 
   RowBox[{"g", ",", "gS2", ",", 
    RowBox[{"FinalFrame", "->", "gS2"}]}], "]"}], "[", 
  RowBox[{
   RowBox[{"CD", "[", "\[Nu]", "]"}], "[", 
   RowBox[{"k", "[", "\[Mu]", "]"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ConformalTransformation", "[", 
   RowBox[{"g", ",", "gS2", ",", 
    RowBox[{"FinalFrame", "->", "gS2"}]}], "]"}], "[", 
  RowBox[{"RicciCD", "[", 
   RowBox[{
    RowBox[{"-", "\[Mu]"}], ",", 
    RowBox[{"-", "\[Nu]"}]}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ConformalTransformation", "[", 
   RowBox[{"g", ",", "gS2", ",", 
    RowBox[{"FinalFrame", "->", "gS2"}]}], "]"}], "[", 
  RowBox[{"RiemannCD", "[", 
   RowBox[{
    RowBox[{"-", "\[Mu]"}], ",", 
    RowBox[{"-", "\[Nu]"}], ",", 
    RowBox[{"-", "\[Alpha]"}], ",", 
    RowBox[{"-", "\[Beta]"}]}], "]"}], "]"}]}], "Input",
 CellLabel->"In[78]:=",ExpressionUUID->"aab33022-4e38-4234-ba50-80e07e5011e3"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"i", "[", 
        RowBox[{"g", 
         SuperscriptBox["S", "2"]}], "]"}], 
       StyleBox[GridBox[{
          {"\[Mu]", "\[Sigma]$17213"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`InvgS2[$CellContext`\[Mu], $CellContext`\[Sigma]$17213],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"i", "[", 
        RowBox[{"g", 
         SuperscriptBox["S", "2"]}], "]"}], 
       StyleBox[GridBox[{
          {"\[Nu]", "\[Sigma]$17217"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`InvgS2[$CellContext`\[Nu], $CellContext`\[Sigma]$17217],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox[
      RowBox[{"\[Del]", "gS2"}], "\[Sigma]$17217"], 
     StyleBox["[",
      FontColor->RGBColor[1, 0, 0]], 
     InterpretationBox[
      StyleBox[GridBox[{
         {"k", 
          StyleBox[GridBox[{
             {" "},
             {"\[Sigma]$17213"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`k[-$CellContext`\[Sigma]$17213],
      Editable->False], 
     StyleBox["]",
      FontColor->RGBColor[1, 0, 0]]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`CDgS2[-$CellContext`\[Sigma]$17217][
    xAct`xConf`ConformalFrame[$CellContext`gS2][
     $CellContext`k[-$CellContext`\[Sigma]$17213]]],
   Editable->False]}]], "Output",
 CellLabel->"Out[78]=",ExpressionUUID->"94848f2d-dc92-4a69-88f8-e402277a8f64"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"i", "[", 
        RowBox[{"g", 
         SuperscriptBox["S", "2"]}], "]"}], 
       StyleBox[GridBox[{
          {"\[Mu]", "\[Sigma]$17300"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`InvgS2[$CellContext`\[Mu], $CellContext`\[Sigma]$17300],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"i", "[", 
        RowBox[{"g", 
         SuperscriptBox["S", "2"]}], "]"}], 
       StyleBox[GridBox[{
          {"\[Nu]", "\[Sigma]$17304"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`InvgS2[$CellContext`\[Nu], $CellContext`\[Sigma]$17304],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox[
      RowBox[{"\[Del]", "gS2"}], "\[Sigma]$17304"], 
     StyleBox["[",
      FontColor->RGBColor[1, 0, 0]], 
     InterpretationBox[
      StyleBox[GridBox[{
         {"k", 
          StyleBox[GridBox[{
             {" "},
             {"\[Sigma]$17300"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`k[-$CellContext`\[Sigma]$17300],
      Editable->False], 
     StyleBox["]",
      FontColor->RGBColor[1, 0, 0]]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`CDgS2[-$CellContext`\[Sigma]$17304][
    xAct`xConf`ConformalFrame[$CellContext`gS2][
     $CellContext`k[-$CellContext`\[Sigma]$17300]]],
   Editable->False]}]], "Output",
 CellLabel->"Out[79]=",ExpressionUUID->"00e0bc49-68c1-4079-a356-c9e4f66c5e91"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{"R", "[", 
       RowBox[{"\[Del]", "gS2"}], "]"}], 
      StyleBox[GridBox[{
         {" ", " "},
         {"\[Mu]", "\[Nu]"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`RicciCDgS2[-$CellContext`\[Mu], -$CellContext`\[Nu]],
  Editable->False]], "Output",
 CellLabel->"Out[80]=",ExpressionUUID->"6def0d5f-d903-47e9-aea3-a3bd4ae83c8f"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"[", 
        RowBox[{"g", 
         SuperscriptBox["S", "2"]}], "]"}], 
       StyleBox[GridBox[{
          {" ", " "},
          {"\[Nu]", "\[Sigma]$17496"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`gS2[-$CellContext`\[Nu], -$CellContext`\[Sigma]$17496],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"R", "[", 
        RowBox[{"\[Del]", "gS2"}], "]"}], 
       StyleBox[GridBox[{
          {" ", " ", " ", "\[Sigma]$17496"},
          {"\[Alpha]", "\[Beta]", "\[Mu]", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`RiemannCDgS2[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Mu], $CellContext`\[Sigma]$17496],
   Editable->False]}]], "Output",
 CellLabel->
  "Out[81]=",ExpressionUUID->"3ffe987e-a59f-47f8-a966-4bd4e27e0661"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Word of caution on syntax.", \
"Section",ExpressionUUID->"31582070-77c1-42a9-8663-506f88290f77"],

Cell["\<\
By Default we have set in xConf that ToCanonical should use \
UseMetricOnVBundle->None. Indeed we do not want ToCanonical to move index \
positions inside the ConformalFrame inert head.
Indeed a conformal transformation is position dependent. If the user insists \
in using ToCanonical with UseMetricOnVBundle->All while having expressions \
expressed in a frame which is not the ambient frame, this will generate \
errors.\
\>", "Text",ExpressionUUID->"720554a5-dabc-4aa6-a207-8a809f9dfd9e"],

Cell["This would still be fine :", \
"Text",ExpressionUUID->"ac05bf96-9305-4f36-9b7e-5bb1472c70c1"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"g", "[", 
   RowBox[{"\[Mu]", ",", "\[Alpha]"}], "]"}], 
  RowBox[{
   RowBox[{"ConformalFrame", "[", "g", "]"}], "[", 
   RowBox[{"k", "[", 
    RowBox[{"-", "\[Mu]"}], "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"ToCanonical", "[", 
  RowBox[{"%", ",", 
   RowBox[{"UseMetricOnVBundle", "->", "All"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ToMetric", "[", "g", "]"}], "[", 
  RowBox[{"%", "-", "%%"}], "]"}]}], "Input",
 CellLabel->"In[82]:=",ExpressionUUID->"12a38f02-8d7e-49f5-b6ed-b9af95e80d90"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"g", 
       StyleBox[GridBox[{
          {"\[Mu]", "\[Alpha]"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`g[$CellContext`\[Mu], $CellContext`\[Alpha]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     StyleBox["[",
      FontColor->GrayLevel[0]], 
     InterpretationBox[
      StyleBox[GridBox[{
         {"k", 
          StyleBox[GridBox[{
             {" "},
             {"\[Mu]"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`k[-$CellContext`\[Mu]],
      Editable->False], 
     StyleBox["]",
      FontColor->GrayLevel[0]]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xConf`ConformalFrame[$CellContext`g][
    $CellContext`k[-$CellContext`\[Mu]]],
   Editable->False]}]], "Output",
 CellLabel->"Out[82]=",ExpressionUUID->"bc8d8e48-a89c-46fa-85d8-6798f4915af0"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox["[",
     FontColor->GrayLevel[0]], 
    InterpretationBox[
     StyleBox[GridBox[{
        {"k", 
         StyleBox[GridBox[{
            {"\[Alpha]"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`k[$CellContext`\[Alpha]],
     Editable->False], 
    StyleBox["]",
     FontColor->GrayLevel[0]]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xConf`ConformalFrame[$CellContext`g][
   $CellContext`k[$CellContext`\[Alpha]]],
  Editable->False]], "Output",
 CellLabel->"Out[83]=",ExpressionUUID->"a5de759d-e9cd-4500-a145-b52d3fb83d80"],

Cell[BoxData["0"], "Output",
 CellLabel->
  "Out[84]=",ExpressionUUID->"d350214e-09ff-41c4-b460-efbb7d5375de"]
}, Open  ]],

Cell["But this is wrong :", \
"Text",ExpressionUUID->"7cf3b215-3cac-4b52-908c-c5f7ffa9f7a2"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"g", "[", 
   RowBox[{"\[Mu]", ",", "\[Alpha]"}], "]"}], 
  RowBox[{
   RowBox[{"ConformalFrame", "[", "gs2", "]"}], "[", 
   RowBox[{"k", "[", 
    RowBox[{"-", "\[Mu]"}], "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"ToCanonical", "[", 
  RowBox[{"%", ",", 
   RowBox[{"UseMetricOnVBundle", "->", "All"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ToMetric", "[", "g", "]"}], "[", 
   RowBox[{"%", "-", "%%"}], "]"}], "//", "ToCanonical"}]}], "Input",
 CellLabel->"In[85]:=",ExpressionUUID->"e4814ed4-6826-4a0e-991e-b4aa319fbcfc"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"g", 
       StyleBox[GridBox[{
          {"\[Mu]", "\[Alpha]"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`g[$CellContext`\[Mu], $CellContext`\[Alpha]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     StyleBox["[",
      FontColor->RGBColor[0, 0, 1]], 
     InterpretationBox[
      StyleBox[GridBox[{
         {"k", 
          StyleBox[GridBox[{
             {" "},
             {"\[Mu]"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`k[-$CellContext`\[Mu]],
      Editable->False], 
     StyleBox["]",
      FontColor->RGBColor[0, 0, 1]]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xConf`ConformalFrame[$CellContext`gs2][
    $CellContext`k[-$CellContext`\[Mu]]],
   Editable->False]}]], "Output",
 CellLabel->"Out[85]=",ExpressionUUID->"62bc3646-9fd4-438b-bc21-31fd8170c82a"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox["[",
     FontColor->RGBColor[0, 0, 1]], 
    InterpretationBox[
     StyleBox[GridBox[{
        {"k", 
         StyleBox[GridBox[{
            {"\[Alpha]"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`k[$CellContext`\[Alpha]],
     Editable->False], 
    StyleBox["]",
     FontColor->RGBColor[0, 0, 1]]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xConf`ConformalFrame[$CellContext`gs2][
   $CellContext`k[$CellContext`\[Alpha]]],
  Editable->False]], "Output",
 CellLabel->"Out[86]=",ExpressionUUID->"d62bcfea-82ea-4757-8a8c-289ce2e67e5a"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Alpha]", "\[Mu]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Mu]],
     Editable->False]}], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"k", 
        StyleBox[GridBox[{
           {" "},
           {"\[Mu]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`k[-$CellContext`\[Mu]],
    Editable->False]}], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Alpha]", "\[Mu]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"k", 
         StyleBox[GridBox[{
            {" "},
            {"\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`k[-$CellContext`\[Mu]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["s",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`s[],
     Editable->False], "2"]]}]], "Output",
 CellLabel->
  "Out[87]=",ExpressionUUID->"932e4a85-7360-417c-a2a1-2978e5ad2fa9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"g", "[", 
   RowBox[{
    RowBox[{"-", "\[Mu]"}], ",", 
    RowBox[{"-", "\[Alpha]"}]}], "]"}], 
  RowBox[{
   RowBox[{"ConformalFrame", "[", "gs2", "]"}], "[", 
   RowBox[{"k", "[", "\[Mu]", "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"ToCanonical", "[", 
  RowBox[{"%", ",", 
   RowBox[{"UseMetricOnVBundle", "->", "None"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"ToCanonical", "[", 
  RowBox[{"%", ",", 
   RowBox[{"UseMetricOnVBundle", "->", "All"}]}], "]"}]}], "Input",
 CellLabel->"In[88]:=",ExpressionUUID->"2bd9a9a0-b549-4b6b-9c9b-24c768f40401"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"g", 
       StyleBox[GridBox[{
          {" ", " "},
          {"\[Mu]", "\[Alpha]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`g[-$CellContext`\[Mu], -$CellContext`\[Alpha]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     StyleBox["[",
      FontColor->RGBColor[0, 0, 1]], 
     InterpretationBox[
      StyleBox[GridBox[{
         {"k", 
          StyleBox[GridBox[{
             {"\[Mu]"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`k[$CellContext`\[Mu]],
      Editable->False], 
     StyleBox["]",
      FontColor->RGBColor[0, 0, 1]]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xConf`ConformalFrame[$CellContext`gs2][
    $CellContext`k[$CellContext`\[Mu]]],
   Editable->False]}]], "Output",
 CellLabel->"Out[88]=",ExpressionUUID->"adf23426-e7b0-4ba4-bc14-b6d23d5cd5c4"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"g", 
       StyleBox[GridBox[{
          {" ", " "},
          {"\[Alpha]", "\[Mu]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     StyleBox["[",
      FontColor->RGBColor[0, 0, 1]], 
     InterpretationBox[
      StyleBox[GridBox[{
         {"k", 
          StyleBox[GridBox[{
             {"\[Mu]"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`k[$CellContext`\[Mu]],
      Editable->False], 
     StyleBox["]",
      FontColor->RGBColor[0, 0, 1]]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xConf`ConformalFrame[$CellContext`gs2][
    $CellContext`k[$CellContext`\[Mu]]],
   Editable->False]}]], "Output",
 CellLabel->"Out[89]=",ExpressionUUID->"351944c1-ec17-4129-bae8-c6295c0ef828"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"g", 
       StyleBox[GridBox[{
          {" ", " "},
          {"\[Alpha]", "\[Mu]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     StyleBox["[",
      FontColor->RGBColor[0, 0, 1]], 
     InterpretationBox[
      StyleBox[GridBox[{
         {"k", 
          StyleBox[GridBox[{
             {"\[Mu]"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`k[$CellContext`\[Mu]],
      Editable->False], 
     StyleBox["]",
      FontColor->RGBColor[0, 0, 1]]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xConf`ConformalFrame[$CellContext`gs2][
    $CellContext`k[$CellContext`\[Mu]]],
   Editable->False]}]], "Output",
 CellLabel->
  "Out[90]=",ExpressionUUID->"68ff2245-a20b-4205-9fdb-9436722805d7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"g", "[", 
   RowBox[{"\[Mu]", ",", "\[Alpha]"}], "]"}], 
  RowBox[{
   RowBox[{"ConformalFrame", "[", "gs2", "]"}], "[", 
   RowBox[{"k", "[", 
    RowBox[{"-", "\[Mu]"}], "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"ToCanonical", "[", 
  RowBox[{"%", ",", 
   RowBox[{"UseMetricOnVBundle", "->", "None"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"ToCanonical", "[", 
  RowBox[{"%", ",", 
   RowBox[{"UseMetricOnVBundle", "->", "All"}]}], "]"}]}], "Input",
 CellLabel->"In[91]:=",ExpressionUUID->"4f9bfac2-7e96-4684-9406-82462a04a23e"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"g", 
       StyleBox[GridBox[{
          {"\[Mu]", "\[Alpha]"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`g[$CellContext`\[Mu], $CellContext`\[Alpha]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     StyleBox["[",
      FontColor->RGBColor[0, 0, 1]], 
     InterpretationBox[
      StyleBox[GridBox[{
         {"k", 
          StyleBox[GridBox[{
             {" "},
             {"\[Mu]"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`k[-$CellContext`\[Mu]],
      Editable->False], 
     StyleBox["]",
      FontColor->RGBColor[0, 0, 1]]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xConf`ConformalFrame[$CellContext`gs2][
    $CellContext`k[-$CellContext`\[Mu]]],
   Editable->False]}]], "Output",
 CellLabel->"Out[91]=",ExpressionUUID->"c145f7ac-4361-49bb-914a-b21b3cc68c0f"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"g", 
       StyleBox[GridBox[{
          {"\[Alpha]", "\[Mu]"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Mu]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     StyleBox["[",
      FontColor->RGBColor[0, 0, 1]], 
     InterpretationBox[
      StyleBox[GridBox[{
         {"k", 
          StyleBox[GridBox[{
             {" "},
             {"\[Mu]"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`k[-$CellContext`\[Mu]],
      Editable->False], 
     StyleBox["]",
      FontColor->RGBColor[0, 0, 1]]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xConf`ConformalFrame[$CellContext`gs2][
    $CellContext`k[-$CellContext`\[Mu]]],
   Editable->False]}]], "Output",
 CellLabel->"Out[92]=",ExpressionUUID->"2ea982ad-6bee-4934-8131-3afb1b85828c"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox["[",
     FontColor->RGBColor[0, 0, 1]], 
    InterpretationBox[
     StyleBox[GridBox[{
        {"k", 
         StyleBox[GridBox[{
            {"\[Alpha]"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`k[$CellContext`\[Alpha]],
     Editable->False], 
    StyleBox["]",
     FontColor->RGBColor[0, 0, 1]]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xConf`ConformalFrame[$CellContext`gs2][
   $CellContext`k[$CellContext`\[Alpha]]],
  Editable->False]], "Output",
 CellLabel->
  "Out[93]=",ExpressionUUID->"96340470-a33a-4573-a454-bc88da9cf0e9"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tests (to be erased eventually)", \
"Section",ExpressionUUID->"963cb2e8-b388-4db1-82fb-18071965e144"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"UndefMetric", "[", "gS2", "]"}], "*)"}]], "Input",
 CellLabel->"In[94]:=",ExpressionUUID->"60f6c24e-c6e5-4bd8-8904-3e18ccb6d6cc"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$PrePrint", "=", "ScreenDollarIndices"}], ";"}]], "Input",
 CellLabel->"In[95]:=",ExpressionUUID->"a30b5d27-2d73-4fa9-a3c2-c61c096bd3ec"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CgS1", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"ConformalTransformation", "[", 
     RowBox[{"g", ",", "gs2", ",", 
      RowBox[{"FinalFrame", "->", "g"}]}], "]"}], "[", 
    RowBox[{"RiemannCD", "[", 
     RowBox[{
      RowBox[{"-", "\[Alpha]"}], ",", 
      RowBox[{"-", "\[Beta]"}], ",", 
      RowBox[{"-", "\[Mu]"}], ",", "\[Nu]"}], "]"}], "]"}], "-", 
   RowBox[{"RiemannCD", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Mu]"}], ",", "\[Nu]"}], "]"}]}]}]], "Input",
 CellLabel->"In[96]:=",ExpressionUUID->"d68b5a95-f9fa-4a4e-9dc6-cbe5f15ae5d7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "\[Nu]"},
             {"\[Beta]", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {" ", " "},
             {"\[Alpha]", "\[Mu]"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"g", 
              StyleBox[GridBox[{
                 {"\[Alpha]", "\[Beta]"},
                 {" ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->Rational[39, 4]]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubscriptBox["\[Del]", "\[Alpha]"], "s"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[-$CellContext`\[Alpha]][
           $CellContext`s[]],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubscriptBox["\[Del]", "\[Beta]"], "s"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[-$CellContext`\[Beta]][
           $CellContext`s[]],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
         $CellContext`s[]] $CellContext`CD[-$CellContext`\[Beta]][
         $CellContext`s[]]],
      Editable->False]}], 
    SuperscriptBox[
     InterpretationBox[
      StyleBox["s",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`s[],
      Editable->False], "2"]]}], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Alpha]"], "s"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Alpha]][
          $CellContext`s[]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Beta]"], "s"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Beta]][
          $CellContext`s[]],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
        $CellContext`s[]] $CellContext`CD[-$CellContext`\[Beta]][
        $CellContext`s[]]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["s",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`s[],
     Editable->False], "2"]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "s"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`s[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], "s"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`s[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["s",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`s[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "s"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`s[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], "s"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`s[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["s",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`s[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], 
       SubscriptBox["\[Del]", "\[Alpha]"], "s"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`CD[-$CellContext`\[Alpha]][
       $CellContext`s[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["s",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`s[],
    Editable->False]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], 
       SubscriptBox["\[Del]", "\[Beta]"], "s"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`CD[-$CellContext`\[Beta]][
       $CellContext`s[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["s",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`s[],
    Editable->False]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "s"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`s[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "s"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`s[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["s",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`s[],
     Editable->False], "2"]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "s"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`s[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "s"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`s[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["s",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`s[],
     Editable->False], "2"]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], 
       SubscriptBox["\[Del]", "\[Alpha]"], "s"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`CD[-$CellContext`\[Alpha]][
       $CellContext`s[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["s",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`s[],
    Editable->False]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], 
       SubscriptBox["\[Del]", "\[Beta]"], "s"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`CD[-$CellContext`\[Beta]][
       $CellContext`s[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["s",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`s[],
    Editable->False]]}]], "Output",
 CellLabel->
  "Out[96]=",ExpressionUUID->"666b8d91-381e-4c94-b782-7a4c7d219914"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CgS1S2", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"ConformalTransformation", "[", 
     RowBox[{"g", ",", "gS2", ",", 
      RowBox[{"FinalFrame", "->", "g"}]}], "]"}], "[", 
    RowBox[{"RiemannCD", "[", 
     RowBox[{
      RowBox[{"-", "\[Alpha]"}], ",", 
      RowBox[{"-", "\[Beta]"}], ",", 
      RowBox[{"-", "\[Mu]"}], ",", "\[Nu]"}], "]"}], "]"}], "-", 
   RowBox[{"RiemannCD", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Mu]"}], ",", "\[Nu]"}], "]"}]}]}]], "Input",
 CellLabel->"In[97]:=",ExpressionUUID->"193d315e-2950-47e9-92fe-813fa3a4e60f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "\[Nu]"},
             {"\[Beta]", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {" ", " "},
             {"\[Alpha]", "\[Mu]"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"g", 
              StyleBox[GridBox[{
                 {"\[Alpha]", "\[Beta]"},
                 {" ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->Rational[39, 4]]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[-$CellContext`\[Alpha]][
           $CellContext`S[]],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubscriptBox["\[Del]", "\[Beta]"], "S"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[-$CellContext`\[Beta]][
           $CellContext`S[]],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
         $CellContext`S[]] $CellContext`CD[-$CellContext`\[Beta]][
         $CellContext`S[]]],
      Editable->False]}], 
    SuperscriptBox[
     InterpretationBox[
      StyleBox["S",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`S[],
      Editable->False], "2"]]}], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Alpha]][
          $CellContext`S[]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Beta]"], "S"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Beta]][
          $CellContext`S[]],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
        $CellContext`S[]] $CellContext`CD[-$CellContext`\[Beta]][
        $CellContext`S[]]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "2"]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`S[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`S[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], 
       SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`CD[-$CellContext`\[Alpha]][
       $CellContext`S[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], 
       SubscriptBox["\[Del]", "\[Beta]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`CD[-$CellContext`\[Beta]][
       $CellContext`S[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "2"]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "2"]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], 
       SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`CD[-$CellContext`\[Alpha]][
       $CellContext`S[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], 
       SubscriptBox["\[Del]", "\[Beta]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`CD[-$CellContext`\[Beta]][
       $CellContext`S[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False]]}]], "Output",
 CellLabel->
  "Out[97]=",ExpressionUUID->"8ab32f94-9aa8-4645-9f29-d34ac7526ae5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CgS2", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"ConformalTransformation", "[", 
     RowBox[{"gs2", ",", "gS2", ",", 
      RowBox[{"FinalFrame", "->", "g"}]}], "]"}], "[", 
    RowBox[{"RiemannCD", "[", 
     RowBox[{
      RowBox[{"-", "\[Alpha]"}], ",", 
      RowBox[{"-", "\[Beta]"}], ",", 
      RowBox[{"-", "\[Mu]"}], ",", "\[Nu]"}], "]"}], "]"}], "-", 
   RowBox[{"RiemannCD", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Mu]"}], ",", "\[Nu]"}], "]"}]}]}]], "Input",
 CellLabel->"In[98]:=",ExpressionUUID->"a055878b-2dc9-4f39-bff2-79530620db82"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "\[Nu]"},
             {"\[Beta]", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {" ", " "},
             {"\[Alpha]", "\[Mu]"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"g", 
              StyleBox[GridBox[{
                 {"\[Alpha]", "\[Beta]"},
                 {" ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->Rational[39, 4]]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubscriptBox["\[Del]", "\[Alpha]"], "s"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[-$CellContext`\[Alpha]][
           $CellContext`s[]],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubscriptBox["\[Del]", "\[Beta]"], "s"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[-$CellContext`\[Beta]][
           $CellContext`s[]],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
         $CellContext`s[]] $CellContext`CD[-$CellContext`\[Beta]][
         $CellContext`s[]]],
      Editable->False]}], 
    SuperscriptBox[
     InterpretationBox[
      StyleBox["s",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`s[],
      Editable->False], "2"]]}], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Alpha]"], "s"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Alpha]][
          $CellContext`s[]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Beta]"], "s"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Beta]][
          $CellContext`s[]],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
        $CellContext`s[]] $CellContext`CD[-$CellContext`\[Beta]][
        $CellContext`s[]]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["s",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`s[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Alpha]"], "s"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Alpha]][
          $CellContext`s[]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Beta]"], "S"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Beta]][
          $CellContext`S[]],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
        $CellContext`s[]] $CellContext`CD[-$CellContext`\[Beta]][
        $CellContext`S[]]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["s",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`s[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False]}]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Alpha]"], "s"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Alpha]][
          $CellContext`s[]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Beta]"], "S"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Beta]][
          $CellContext`S[]],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
        $CellContext`s[]] $CellContext`CD[-$CellContext`\[Beta]][
        $CellContext`S[]]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["s",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`s[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False]}]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Alpha]][
          $CellContext`S[]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Beta]"], "S"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Beta]][
          $CellContext`S[]],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
        $CellContext`S[]] $CellContext`CD[-$CellContext`\[Beta]][
        $CellContext`S[]]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Alpha]][
          $CellContext`S[]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Beta]"], "S"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Beta]][
          $CellContext`S[]],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
        $CellContext`S[]] $CellContext`CD[-$CellContext`\[Beta]][
        $CellContext`S[]]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], "s"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`s[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["s",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`s[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False]}]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], "s"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`s[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["s",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`s[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False]}]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "s"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`s[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`S[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["s",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`s[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False]}]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`S[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "2"]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "s"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`s[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`S[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["s",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`s[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False]}]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`S[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "2"]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], 
       SubscriptBox["\[Del]", "\[Alpha]"], "s"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`CD[-$CellContext`\[Alpha]][
       $CellContext`s[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["s",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`s[],
    Editable->False]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], 
       SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`CD[-$CellContext`\[Alpha]][
       $CellContext`S[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], 
       SubscriptBox["\[Del]", "\[Beta]"], "s"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`CD[-$CellContext`\[Beta]][
       $CellContext`s[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["s",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`s[],
    Editable->False]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], 
       SubscriptBox["\[Del]", "\[Beta]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`CD[-$CellContext`\[Beta]][
       $CellContext`S[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "s"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`s[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["s",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`s[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False]}]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "s"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`s[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["s",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`s[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False]}]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "s"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`s[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["s",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`s[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False]}]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "s"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`s[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["s",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`s[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False]}]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], 
       SubscriptBox["\[Del]", "\[Alpha]"], "s"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`CD[-$CellContext`\[Alpha]][
       $CellContext`s[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["s",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`s[],
    Editable->False]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], 
       SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`CD[-$CellContext`\[Alpha]][
       $CellContext`S[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], 
       SubscriptBox["\[Del]", "\[Beta]"], "s"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`CD[-$CellContext`\[Beta]][
       $CellContext`s[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["s",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`s[],
    Editable->False]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], 
       SubscriptBox["\[Del]", "\[Beta]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`CD[-$CellContext`\[Beta]][
       $CellContext`S[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False]]}]], "Output",
 CellLabel->
  "Out[98]=",ExpressionUUID->"e76add68-37ec-4871-88e5-4c635be10b6b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TS2CgS1", "=", 
  RowBox[{
   RowBox[{"ConformalTransformation", "[", 
    RowBox[{"gs2", ",", "gS2", ",", 
     RowBox[{"FinalFrame", "->", "g"}]}], "]"}], "[", "CgS1", 
   "]"}]}]], "Input",
 CellLabel->"In[99]:=",ExpressionUUID->"804d510c-18f1-462c-a697-a141886e8768"],

Cell[BoxData["$Aborted"], "Output",
 CellLabel->
  "Out[99]=",ExpressionUUID->"bf5b353a-91ca-4c8d-a35e-2d7b87c0c23f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ContractMetric", "[", 
   RowBox[{"TS2CgS1", "+", "CgS2"}], "]"}], "//", "ToCanonical"}]], "Input",
 CellLabel->
  "In[100]:=",ExpressionUUID->"49ee204d-243a-4a30-9f4a-a410b20dd028"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "\[Nu]"},
             {"\[Beta]", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {" ", " "},
             {"\[Alpha]", "\[Mu]"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"g", 
              StyleBox[GridBox[{
                 {"\[Alpha]", "\[Beta]"},
                 {" ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->Rational[39, 4]]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[-$CellContext`\[Alpha]][
           $CellContext`S[]],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubscriptBox["\[Del]", "\[Beta]"], "S"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[-$CellContext`\[Beta]][
           $CellContext`S[]],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
         $CellContext`S[]] $CellContext`CD[-$CellContext`\[Beta]][
         $CellContext`S[]]],
      Editable->False]}], 
    SuperscriptBox[
     InterpretationBox[
      StyleBox["S",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`S[],
      Editable->False], "2"]]}], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Alpha]][
          $CellContext`S[]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Beta]"], "S"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Beta]][
          $CellContext`S[]],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
        $CellContext`S[]] $CellContext`CD[-$CellContext`\[Beta]][
        $CellContext`S[]]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "2"]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "2"]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], 
       SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`CD[-$CellContext`\[Alpha]][
       $CellContext`S[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], 
       SubscriptBox["\[Del]", "\[Beta]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`CD[-$CellContext`\[Beta]][
       $CellContext`S[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Nu]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Nu]][
      $CellContext`S[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Nu]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Nu]][
      $CellContext`S[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Nu]"], 
       SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Nu]][
      $CellContext`CD[-$CellContext`\[Alpha]][
       $CellContext`S[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Nu]"], 
       SubscriptBox["\[Del]", "\[Beta]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Nu]][
      $CellContext`CD[-$CellContext`\[Beta]][
       $CellContext`S[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False]]}]], "Output",
 CellLabel->"Out[100]=",ExpressionUUID->"2499b85d-c54d-45f8-bc02-6933554d26cb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ContractMetric", "[", "CgS1S2", "]"}], "//", 
  "ToCanonical"}]], "Input",
 CellLabel->
  "In[101]:=",ExpressionUUID->"85db8e57-f7eb-4c62-bda4-019c7adcdfbb"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "\[Nu]"},
             {"\[Beta]", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {" ", " "},
             {"\[Alpha]", "\[Mu]"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"g", 
              StyleBox[GridBox[{
                 {"\[Alpha]", "\[Beta]"},
                 {" ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->Rational[39, 4]]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[-$CellContext`\[Alpha]][
           $CellContext`S[]],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubscriptBox["\[Del]", "\[Beta]"], "S"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[-$CellContext`\[Beta]][
           $CellContext`S[]],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
         $CellContext`S[]] $CellContext`CD[-$CellContext`\[Beta]][
         $CellContext`S[]]],
      Editable->False]}], 
    SuperscriptBox[
     InterpretationBox[
      StyleBox["S",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`S[],
      Editable->False], "2"]]}], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Alpha]][
          $CellContext`S[]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Beta]"], "S"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Beta]][
          $CellContext`S[]],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
        $CellContext`S[]] $CellContext`CD[-$CellContext`\[Beta]][
        $CellContext`S[]]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "2"]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "2"]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], 
       SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`CD[-$CellContext`\[Alpha]][
       $CellContext`S[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], 
       SubscriptBox["\[Del]", "\[Beta]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`CD[-$CellContext`\[Beta]][
       $CellContext`S[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Nu]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Nu]][
      $CellContext`S[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Nu]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Nu]][
      $CellContext`S[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Nu]"], 
       SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Nu]][
      $CellContext`CD[-$CellContext`\[Alpha]][
       $CellContext`S[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Nu]"], 
       SubscriptBox["\[Del]", "\[Beta]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Nu]][
      $CellContext`CD[-$CellContext`\[Beta]][
       $CellContext`S[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False]]}]], "Output",
 CellLabel->"Out[101]=",ExpressionUUID->"5fe4295f-fe77-419a-a920-9356a121e8cf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "-", "%%"}], "//", "ToCanonical"}]], "Input",
 CellLabel->
  "In[102]:=",ExpressionUUID->"99d4ae0e-6658-4d59-8596-5c54add793e0"],

Cell[BoxData["0"], "Output",
 CellLabel->"Out[102]=",ExpressionUUID->"8dc5275e-8bc8-4b7c-92b9-e38ec7b0eab1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ContractMetric", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ConformalTransformation", "[", 
      RowBox[{"g", ",", "gS2", ",", 
       RowBox[{"FinalFrame", "->", "g"}]}], "]"}], "[", "CgS1", "]"}], "-", 
    "CgS1"}], "]"}], "//", "ToCanonical"}]], "Input",
 CellLabel->
  "In[126]:=",ExpressionUUID->"b6292ff1-42aa-4667-994c-8a772aae10c3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"2", " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "\[Nu]"},
             {"\[Beta]", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {" ", " "},
             {"\[Alpha]", "\[Mu]"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"g", 
              StyleBox[GridBox[{
                 {"\[Alpha]", "\[Beta]"},
                 {" ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->Rational[39, 4]]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubscriptBox["\[Del]", "\[Alpha]"], "s"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[-$CellContext`\[Alpha]][
           $CellContext`s[]],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubscriptBox["\[Del]", "\[Beta]"], "S"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[-$CellContext`\[Beta]][
           $CellContext`S[]],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
         $CellContext`s[]] $CellContext`CD[-$CellContext`\[Beta]][
         $CellContext`S[]]],
      Editable->False]}], 
    RowBox[{
     InterpretationBox[
      StyleBox["s",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`s[],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox["S",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`S[],
      Editable->False]}]]}], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Alpha]"], "s"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Alpha]][
          $CellContext`s[]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Beta]"], "S"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Beta]][
          $CellContext`S[]],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
        $CellContext`s[]] $CellContext`CD[-$CellContext`\[Beta]][
        $CellContext`S[]]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["s",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`s[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False]}]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "s"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`s[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["s",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`s[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False]}]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "s"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`s[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["s",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`s[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False]}]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "s"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`s[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["s",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`s[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False]}]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "s"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`s[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["s",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`s[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False]}]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Nu]"], "s"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Nu]][
      $CellContext`s[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["s",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`s[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False]}]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Nu]"], "s"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Nu]][
      $CellContext`s[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["s",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`s[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False]}]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "s"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`s[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Nu]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Nu]][
      $CellContext`S[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["s",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`s[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False]}]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "s"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`s[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Nu]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Nu]][
      $CellContext`S[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["s",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`s[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False]}]]}]], "Output",
 CellLabel->"Out[126]=",ExpressionUUID->"6560b309-aec6-431a-8c92-d1f8b2314dc2"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1107, 847},
WindowMargins->{{90, Automatic}, {Automatic, 54}},
Visible->True,
DockedCells->{
  Cell[
   BoxData[
    TemplateBox[{
      ButtonBox[
      "\"\[Dagger]\"", ButtonFunction :> Exit[], Appearance -> Automatic, 
       Evaluator -> Automatic, Method -> "Preemptive"], 
      ButtonBox[
      "\"\[RightTriangle]\"", ButtonFunction :> FrontEnd`FrontEndExecute[
         FrontEnd`FrontEndToken["EvaluatorStart"]], Evaluator -> None, 
       Appearance -> Automatic, Method -> "Preemptive"], 
      ButtonBox[
      "\"\[RightTriangle]\[RightTriangle]\"", ButtonFunction :> 
       FrontEnd`FrontEndExecute[
         FrontEnd`FrontEndToken["EvaluateNotebook"]], Evaluator -> None, 
       Appearance -> Automatic, Method -> "Preemptive"], 
      ButtonBox["\"EvalInit\"", ButtonFunction :> FrontEnd`FrontEndExecute[
         FrontEnd`FrontEndToken["EvaluateInitialization"]], Evaluator -> None,
        Appearance -> Automatic, Method -> "Preemptive"], 
      ButtonBox[
      "\"Init\"", 
       ButtonFunction :> (Module[{Utility`Toolbar`cell = NotebookSelection[
             SelectedNotebook[]], Utility`Toolbar`isInit}, 
          Utility`Toolbar`isInit = ReplaceAll[InitializationCell, 
             Options[Utility`Toolbar`cell, InitializationCell]]; If[
            TrueQ[
             Or[
             Utility`Toolbar`isInit == True, Utility`Toolbar`isInit == On]], 
            SetOptions[Utility`Toolbar`cell, InitializationCell -> False], 
            SetOptions[Utility`Toolbar`cell, InitializationCell -> True]]]; 
        Null), Appearance -> Automatic, Evaluator -> Automatic, Method -> 
       "Preemptive"], 
      ButtonBox["\"DeInit\"", ButtonFunction :> SetOptions[
         NotebookSelection[
          SelectedNotebook[]], InitializationCell -> False], Appearance -> 
       Automatic, Evaluator -> Automatic, Method -> "Preemptive"], 
      ButtonBox["\"\[DeleteKey]\"", ButtonFunction :> FrontEnd`FrontEndExecute[
         FrontEnd`FrontEndToken["DeleteGeneratedCells"]], Evaluator -> None, 
       Appearance -> Automatic, Method -> "Preemptive"]}, "Row", 
     DisplayFunction -> (
      RowBox[{#, "\[InvisibleSpace]", #2, "\[InvisibleSpace]", #3, 
        "\[InvisibleSpace]", #4, "\[InvisibleSpace]", #5, 
        "\[InvisibleSpace]", #6, "\[InvisibleSpace]", #7}]& ), 
     InterpretationFunction -> (RowBox[{"Row", "[", 
        RowBox[{"{", 
          RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5, ",", #6, ",", #7}], 
          "}"}], "]"}]& )]], "DockedCell"]},
PrivateNotebookOptions->{"FileOutlineCache"->False},
ShowSelection->True,
TrackCellChangeTimes->False,
FrontEndVersion->"14.1 pour Mac OS X ARM (64-bit) (July 16, 2024)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "PastelColor.nb", 
  CharacterEncoding -> "UTF-8"],
ExpressionUUID->"d5a261cc-427a-495a-8802-fcb83c286279"
]

